/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.datatransforms;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.connection.DataUtilities;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;

public class ResultSetExportComponent
extends ComponentBase {
    private static final long serialVersionUID = 3289900246113442203L;

    public Log getLogger() {
        return LogFactory.getLog(ResultSetExportComponent.class);
    }

    public boolean init() {
        return true;
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    protected boolean validateAction() {
        boolean hasResultSetParameter = this.isDefinedInput("result-set");
        if (!hasResultSetParameter) {
            this.error(Messages.getString("JFreeReport.ERROR_0022_DATA_INPUT_INVALID_OBJECT"));
            return false;
        }
        if (this.getResultOutputName() == null) {
            this.error(Messages.getString("JFreeReport.ERROR_0022_DATA_INPUT_INVALID_OBJECT"));
            return false;
        }
        return true;
    }

    protected boolean executeAction() {
        Object resultSetObject = this.getInputValue("result-set");
        if (resultSetObject instanceof IPentahoResultSet) {
            IPentahoResultSet resultset = (IPentahoResultSet)resultSetObject;
            if (this.getResultOutputName() != null) {
                this.setOutputValue(this.getResultOutputName(), DataUtilities.getXMLString((IPentahoResultSet)resultset));
            }
            return true;
        }
        return false;
    }

    public void done() {
    }

    public String getResultOutputName() {
        Set outputs = this.getOutputNames();
        if (outputs == null || outputs.size() == 0) {
            this.error(Messages.getString("Template.ERROR_0002_OUTPUT_COUNT_WRONG"));
            return null;
        }
        String outputName = null;
        try {
            outputName = this.getInputStringValue("output-name");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (outputName == null) {
            outputName = (String)outputs.iterator().next();
        }
        return outputName;
    }
}

