/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.deprecated;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

public class ContentOutputComponent
extends ComponentBase {
    private static final long serialVersionUID = -6300339081029611956L;
    private static final String INPUT_NAME_EXPECTED = "CONTENTOUTPUT";
    private static final String OUTPUT_NAME = "content";
    private static final String COMPONENT_SETTING_MIME_TYPE = "mime-type";

    protected boolean validateAction() {
        if (!this.isDefinedInput(INPUT_NAME_EXPECTED)) {
            this.error(Messages.getErrorString("ContentOutputComponent.ERROR_0001_CONTENTOUTPUT_NOT_DEFINED"));
            return false;
        }
        if (!this.isDefinedInput(COMPONENT_SETTING_MIME_TYPE)) {
            this.error(Messages.getErrorString("ContentOutputComponent.ERROR_0006_MIME_TYPE_REQUIRED"));
            return false;
        }
        if (!this.isDefinedOutput(OUTPUT_NAME)) {
            this.error(Messages.getErrorString("ContentOutputComponent.ERROR_0008_CONTENT_OUTPUT_REQUIRED"));
            return false;
        }
        return true;
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    public void done() {
    }

    public Log getLogger() {
        return LogFactory.getLog(ContentOutputComponent.class);
    }

    protected boolean executeAction() throws Throwable {
        String mimeType = this.getInputStringValue(COMPONENT_SETTING_MIME_TYPE);
        Object dataToOutput = this.getInputValue(INPUT_NAME_EXPECTED);
        if (dataToOutput != null) {
            IContentItem outputContentItem = this.getOutputContentItem(OUTPUT_NAME, mimeType);
            if (outputContentItem != null) {
                outputContentItem.setMimeType(mimeType);
                OutputStream outputStream = null;
                if (dataToOutput instanceof String) {
                    String theOutput = (String)dataToOutput;
                    if (theOutput.length() > 0) {
                        try {
                            outputStream = outputContentItem.getOutputStream(this.getActionName());
                            outputStream.write(theOutput.getBytes(LocaleHelper.getSystemEncoding()));
                            outputStream.flush();
                            outputStream.close();
                            outputContentItem.closeOutputStream();
                        }
                        catch (Exception e) {
                            this.error(Messages.getErrorString("ContentOutputComponent.ERROR_0003_WRITING_OUTPUT"), e);
                            return false;
                        }
                        this.trace(theOutput);
                        return true;
                    }
                    this.error(Messages.getErrorString("ContentOutputComponent.ERROR_0002_EMPTY_OUTPUT"));
                    return false;
                }
                if (dataToOutput instanceof InputStream) {
                    int len;
                    InputStream is = (InputStream)dataToOutput;
                    byte[] buff = new byte[1024];
                    outputStream = outputContentItem.getOutputStream(null);
                    while ((len = is.read(buff)) >= 0) {
                        outputStream.write(buff, 0, len);
                    }
                    outputStream.flush();
                    outputStream.close();
                    outputContentItem.closeOutputStream();
                    return true;
                }
                if (dataToOutput instanceof ByteArrayOutputStream) {
                    ByteArrayOutputStream baos = (ByteArrayOutputStream)dataToOutput;
                    outputStream = outputContentItem.getOutputStream(null);
                    outputStream.write(baos.toByteArray());
                    outputStream.flush();
                    outputStream.close();
                    outputContentItem.closeOutputStream();
                    return true;
                }
                this.error(Messages.getErrorString("ContentOutputComponent.ERROR_0007_UNKNOWN_TYPE", dataToOutput.getClass().getName()));
                return false;
            }
            this.error(Messages.getErrorString("ContentOutputComponent.ERROR_0005_OUTPUT_CONTENT_ITEM"));
            return false;
        }
        this.error(Messages.getErrorString("ContentOutputComponent.ERROR_0004_CONTENTOUTPUT_NULL"));
        return false;
    }

    public boolean init() {
        return true;
    }
}

