/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.eclipsebirt;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterDefn;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderContext;
import org.eclipse.birt.report.engine.api.ReportParameterConverter;
import org.eclipse.birt.report.engine.api.impl.ScalarParameterDefn;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.actions.BirtReportAction;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;

public class BIRTReportComponent
extends ComponentBase {
    protected static final Log logger = LogFactory.getLog(BIRTReportComponent.class);
    protected static IReportEngine reportEngine = null;
    private static final long serialVersionUID = -6051215996386090147L;
    private static final int OUTPUT_TYPE_HTML = 0;
    private static final int OUTPUT_TYPE_PDF = 1;
    private static final ArrayList outputTypeStrings = new ArrayList();
    private String type;
    private int typeIdx = -1;
    private String mimeType;
    private String extension = "";
    private IRenderOption renderOptions;
    private IGetParameterDefinitionTask parameterDefinitionTask;

    public Log getLogger() {
        return LogFactory.getLog(BIRTReportComponent.class);
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    protected boolean validateAction() {
        boolean actionValidated = true;
        BirtReportAction reportAction = null;
        if (this.getActionDefinition() instanceof BirtReportAction) {
            reportAction = (BirtReportAction)this.getActionDefinition();
            if (reportEngine == null) {
                this.error(Messages.getErrorString("BIRTReportComponent.ERROR_0016_ENGINE_NOT_INITIALIZED"));
                actionValidated = false;
            }
            if (actionValidated) {
                if (reportAction.getOutputType() != ActionInputConstant.NULL_INPUT) {
                    String outputType = reportAction.getOutputType().getStringValue();
                    if (!outputType.equals("html") && !outputType.equals("pdf")) {
                        actionValidated = false;
                        this.error(Messages.getErrorString("BIRT.ERROR_0003_REPORT_TYPE_NOT_VALID", this.type));
                    }
                } else {
                    actionValidated = false;
                    this.error(Messages.getErrorString("BIRT.ERROR_0001_REPORT_TYPE_NOT_SPECIFIED"));
                }
            }
        } else {
            actionValidated = false;
            this.error(Messages.getErrorString("ComponentBase.ERROR_0001_UNKNOWN_ACTION_TYPE", this.getActionDefinition().getElement().asXML()));
        }
        if (actionValidated && reportAction.getReportDefinition() == null) {
            this.error(Messages.getErrorString("BIRT.ERROR_0002_REPORT_DEFINITION_NOT_SPECIFIED"));
            actionValidated = false;
        }
        return actionValidated;
    }

    public boolean init() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeAction() {
        InputStream reportDefinition;
        BirtReportAction reportAction = (BirtReportAction)this.getActionDefinition();
        IActionSequenceResource reportDefResource = this.getResource(reportAction.getReportDefinition().getName());
        String reportDefinitionPath = reportDefResource.getAddress();
        try {
            reportDefinition = ((ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getSession())).getResourceInputStream(reportDefResource, true, 1);
        }
        catch (FileNotFoundException e1) {
            this.error(e1.getLocalizedMessage());
            return false;
        }
        this.type = reportAction.getOutputType().getStringValue();
        this.typeIdx = outputTypeStrings.indexOf(this.type);
        if (this.typeIdx < 0) {
            this.error(Messages.getErrorString("BIRT.ERROR_0003_REPORT_TYPE_NOT_VALID", this.type));
            return false;
        }
        switch (this.typeIdx) {
            case 0: {
                this.mimeType = "text/html";
                this.extension = ".html";
                this.renderOptions = new HTMLRenderOption();
                break;
            }
            case 1: {
                this.mimeType = "application/pdf";
                this.extension = ".pdf";
                this.renderOptions = new HTMLRenderOption();
                break;
            }
            default: {
                this.error(Messages.getErrorString("BIRT.ERROR_0003_REPORT_TYPE_NOT_VALID", this.type));
                return false;
            }
        }
        this.debug(Messages.getString("BIRT.DEBUG_EXECUTING_REPORT", reportDefinitionPath, this.type));
        String fullyQualifiedServerUrl = PentahoSystem.getApplicationContext().getFullyQualifiedServerURL();
        boolean result = false;
        try {
            IReportRunnable design = reportEngine.openReportDesign(reportDefinition);
            if (design == null) {
                return false;
            }
            this.parameterDefinitionTask = reportEngine.createGetParameterDefinitionTask(design);
            HashMap parameterMap = new HashMap();
            int parameterStatus = this.setupParameters(this.parameterDefinitionTask.getParameterDefns(false), parameterMap);
            if (parameterStatus == 1) {
                this.error(Messages.getErrorString("BIRT.ERROR_0005_INVALID_REPORT_PARAMETERS"));
                return false;
            }
            if (parameterStatus == 3) {
                return true;
            }
            this.parameterDefinitionTask.close();
            IRunAndRenderTask runTask = reportEngine.createRunAndRenderTask(design);
            IPentahoSession session = this.getSession();
            runTask.setLocale(session.getLocale());
            OutputStream outputStream = null;
            IContentItem contentItem = null;
            IActionOutput actionOutput = reportAction.getOutputReport();
            if (actionOutput != null) {
                if (actionOutput.getName().equals("report-output")) {
                    contentItem = this.getOutputItem(reportAction.getOutputReport().getName(), this.mimeType, this.extension);
                } else {
                    contentItem = this.getOutputContentItem(actionOutput.getName());
                    contentItem.setMimeType(this.mimeType);
                }
                try {
                    outputStream = contentItem.getOutputStream(this.getActionName());
                }
                catch (Exception e) {}
            } else {
                this.warn(Messages.getString("Base.WARN_NO_OUTPUT_STREAM"));
                outputStream = this.getDefaultOutputStream(this.mimeType);
                if (outputStream != null) {
                    this.setOutputMimeType(this.mimeType);
                }
            }
            if (outputStream == null) {
                this.error(Messages.getErrorString("BIRT.ERROR_0006_INVALID_OUTPUT_STREAM"));
                return false;
            }
            try {
                result = this.generateReport(parameterMap, outputStream, runTask, fullyQualifiedServerUrl);
            }
            finally {
                if (contentItem != null) {
                    contentItem.closeOutputStream();
                }
            }
        }
        catch (Throwable e) {
            this.error(Messages.getErrorString("BIRT.ERROR_0007_REPORT_ERRORS_ENCOUNTERED", reportDefinitionPath), e);
        }
        return result;
    }

    private int setupParameters(Collection params, HashMap reportParameterMap) {
        try {
            boolean parameterUINeeded = false;
            if (this.getOutputPreference() == 1) {
                parameterUINeeded = true;
            }
            for (IParameterDefn param : params) {
                String paramValue;
                ScalarParameterDefn scalarParm = null;
                if (param instanceof ScalarParameterDefn) {
                    scalarParm = (ScalarParameterDefn)param;
                }
                String paramName = param.getName();
                String defaultValue = "";
                if (scalarParm != null) {
                    defaultValue = scalarParm.getDefaultValue();
                }
                if (!this.isDefinedInput(paramName)) continue;
                String contextValue = this.getInputStringValue(paramName);
                IActionParameter paramParameter = this.getInputParameter(paramName);
                if (paramParameter == null || (!paramParameter.hasValue() || parameterUINeeded) && !paramParameter.hasSelections()) {
                    if (paramParameter.getPromptStatus() == 3) {
                        parameterUINeeded = true;
                        continue;
                    }
                    paramParameter = null;
                }
                if (paramParameter == null) {
                    if (scalarParm != null) {
                        if (this.parameterUIOk()) {
                            int controlType = scalarParm.getControlType();
                            if (controlType == 1) {
                                ArrayList<Object> values = new ArrayList<Object>();
                                HashMap<String, Object> displayNames = new HashMap<String, Object>();
                                Collection coll = this.parameterDefinitionTask.getSelectionList(scalarParm.getName());
                                if (coll != null) {
                                    for (IParameterSelectionChoice selectionItem : coll) {
                                        Object value = selectionItem.getValue();
                                        if (value == null) continue;
                                        String label = selectionItem.getLabel();
                                        displayNames.put(value.toString(), label != null ? label : value);
                                        values.add(value);
                                    }
                                }
                                this.createFeedbackParameter(param.getName(), scalarParm.getPromptText(), scalarParm.getHelpText(), defaultValue, values, displayNames, null);
                            } else {
                                this.createFeedbackParameter(param.getName(), scalarParm.getPromptText(), scalarParm.getHelpText(), defaultValue, true);
                            }
                            parameterUINeeded = true;
                            continue;
                        }
                        return 1;
                    }
                    if (defaultValue.length() == 0) {
                        this.error(Messages.getErrorString("BIRT.ERROR_0009_PARAMETER_NOT_PROVIDED", paramName));
                        return 1;
                    }
                }
                if ((paramValue = contextValue) == null || "".equals(paramValue)) continue;
                if (scalarParm != null) {
                    String format = scalarParm.getDisplayFormat();
                    ReportParameterConverter cfgConverter = new ReportParameterConverter(format, Locale.getDefault());
                    Object configValueObj = cfgConverter.parse(paramValue, scalarParm.getDataType());
                    reportParameterMap.put(paramName, configValueObj);
                    continue;
                }
                reportParameterMap.put(paramName, paramValue);
            }
            if (parameterUINeeded) {
                return 3;
            }
            if (this.getRuntimeContext().isPromptPending()) {
                return 3;
            }
            return 2;
        }
        catch (Throwable error) {
            this.error(Messages.getErrorString("BIRT.ERROR_0005_INVALID_REPORT_PARAMETERS"), error);
            return 1;
        }
    }

    private boolean parameterUIOk() {
        if (!this.feedbackAllowed()) {
            return false;
        }
        this.setFeedbackMimeType("text/html");
        return true;
    }

    private boolean generateReport(HashMap parameterMap, OutputStream outputStream, IRunAndRenderTask task, String fullyQualifiedServerUrl) {
        try {
            HashMap<String, Object> appContextMap = new HashMap<String, Object>();
            IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
            if (this.typeIdx == 0) {
                HTMLRenderContext htmlContext = new HTMLRenderContext();
                htmlContext.setBaseImageURL(requestContext.getContextPath() + "getImage?image=");
                htmlContext.setImageDirectory(PentahoSystem.getApplicationContext().getSolutionPath("system/tmp"));
                htmlContext.setSupportedImageFormats("PNG;GIF;JPG;BMP");
                appContextMap.put("HTML_RENDER_CONTEXT", htmlContext);
            } else if (this.typeIdx == 1) {
                PDFRenderContext pdfContext = new PDFRenderContext();
                pdfContext.setBaseURL(fullyQualifiedServerUrl + "getImage?image=");
                pdfContext.setSupportedImageFormats("PNG;GIF;JPG;BMP");
                appContextMap.put("PDF_RENDER_CONTEXT", pdfContext);
            }
            task.setAppContext(appContextMap);
            task.setRenderOption(this.renderOptions);
            this.renderOptions.setOutputFormat(this.type);
            this.renderOptions.setOutputStream(outputStream);
            task.setParameterValues((Map)parameterMap);
            this.debug(task.toString());
            task.run();
            outputStream.flush();
            outputStream.close();
            return true;
        }
        catch (IOException ioe) {
            this.error(null, ioe);
            this.error(Messages.getErrorString("BIRT.ERROR_0010_REPORT_COULD_NOT_BE_RUN", ioe.getMessage()));
        }
        catch (EngineException ee) {
            this.error(null, ee);
            this.error(Messages.getErrorString("BIRT.ERROR_0010_REPORT_COULD_NOT_BE_RUN", ee.getMessage()));
        }
        return false;
    }

    public void done() {
    }

    static {
        outputTypeStrings.add("html");
        outputTypeStrings.add("pdf");
    }
}

