/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.eclipsebirt;

import java.io.File;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.eclipsebirt.BIRTReportComponent;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.util.logging.Logger;

public class BirtSystemListener
implements IPentahoSystemListener {
    private static IReportEngine reportEngine = null;
    private static final Log logger = LogFactory.getLog(BirtSystemListener.class);
    private static String workaroundProtocolHandler = null;
    String imageDirectory = null;
    String logDirectory = null;

    public boolean startup(IPentahoSession session) {
        this.imageDirectory = PentahoSystem.getApplicationContext().getFileOutputPath("system/tmp/BIRT");
        File dir = new File(this.imageDirectory);
        try {
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }
        catch (Exception e) {
            Logger.warn((String)BirtSystemListener.class.getName(), (String)Messages.getErrorString("BIRT.ERROR_0011_DIRECTORY_CREATION_FAILED", this.imageDirectory));
        }
        this.logDirectory = PentahoSystem.getApplicationContext().getFileOutputPath("system/logs/BIRT");
        dir = new File(this.logDirectory);
        try {
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }
        catch (Exception e) {
            Logger.warn((String)BirtSystemListener.class.getName(), (String)Messages.getErrorString("BIRT.ERROR_0011_DIRECTORY_CREATION_FAILED", this.logDirectory));
        }
        BIRTReportComponent.reportEngine = reportEngine = this.createBIRTEngine();
        return reportEngine != null;
    }

    public void shutdown() {
        BIRTReportComponent.reportEngine = null;
        File dir = new File(this.imageDirectory);
        try {
            File[] files;
            if (!dir.exists()) {
                return;
            }
            for (File element : files = dir.listFiles()) {
                element.delete();
            }
        }
        catch (Exception e) {
            Logger.warn((String)BirtSystemListener.class.getName(), (String)Messages.getErrorString("BIRT.ERROR_0012_CANT_COMPLETE_PURGE", this.logDirectory));
        }
        try {
            reportEngine.destroy();
            Platform.shutdown();
            if (workaroundProtocolHandler != null) {
                System.setProperty("java.protocol.handler.pkgs", workaroundProtocolHandler);
                workaroundProtocolHandler = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private IReportEngine createBIRTEngine() {
        try {
            String birtHome = PentahoSystem.getApplicationContext().getSolutionPath("system/BIRT");
            birtHome = birtHome.replaceAll("\\\\.\\\\", "\\\\");
            String birtResourcePath = PentahoSystem.getApplicationContext().getSolutionPath("system/BIRT/resources");
            birtResourcePath = birtResourcePath.replaceAll("\\\\.\\\\", "\\\\");
            Logger.debug((String)BirtSystemListener.class.getName(), (String)Messages.getString("BIRT.DEBUG_BIRT_HOME", birtHome));
            EngineConfig config = new EngineConfig();
            config.setEngineHome(birtHome);
            config.setResourcePath(birtResourcePath);
            String logDest = PentahoSystem.getApplicationContext().getFileOutputPath("system/logs/BIRT");
            int loggingLevel = Logger.getLogLevel();
            if (loggingLevel == 1) {
                config.setLogConfig(logDest, Level.ALL);
            } else if (loggingLevel == 2) {
                config.setLogConfig(logDest, Level.FINE);
            } else if (loggingLevel == 3) {
                config.setLogConfig(logDest, Level.INFO);
            } else if (loggingLevel == 4) {
                config.setLogConfig(logDest, Level.WARNING);
            } else if (loggingLevel == 5) {
                config.setLogConfig(logDest, Level.SEVERE);
            } else if (loggingLevel == 6) {
                config.setLogConfig(logDest, Level.SEVERE);
            }
            RenderOption option = new RenderOption();
            option.setOutputFormat("html");
            HTMLRenderOption renderOption = new HTMLRenderOption((IRenderOption)option);
            renderOption.setImageDirectory(this.imageDirectory);
            config.getEmitterConfigs().put("html", renderOption);
            String protocolHandler = System.getProperty("java.protocol.handler.pkgs");
            if (protocolHandler != null && protocolHandler.indexOf("org.jboss.net.protocol") != -1) {
                StringTokenizer tok = new StringTokenizer(protocolHandler, "|");
                StringBuffer newProtocolHandler = new StringBuffer();
                while (tok.hasMoreElements()) {
                    String name = tok.nextToken();
                    if (name.equals("org.jboss.net.protocol")) continue;
                    newProtocolHandler.append(name).append('|');
                }
                newProtocolHandler.setLength(Math.max(0, newProtocolHandler.length() - 1));
                workaroundProtocolHandler = System.setProperty("java.protocol.handler.pkgs", newProtocolHandler.toString());
            }
            Platform.startup((PlatformConfig)config);
            IReportEngineFactory factory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
            IReportEngine engine = factory.createReportEngine(config);
            return engine;
        }
        catch (BirtException be) {
            logger.error(null, (Throwable)be);
            Logger.error((String)BirtSystemListener.class.getName(), (String)Messages.getErrorString("BIRT.ERROR_0008_INVALID_CONFIGURATION"));
            return null;
        }
    }
}

