/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jasperreports;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.actionsequence.dom.ActionInput;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionResource;
import org.pentaho.actionsequence.dom.actions.JasperReportAction;
import org.pentaho.platform.api.data.DatasourceServiceException;
import org.pentaho.platform.api.data.IDatasourceService;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JasperReportsComponent
extends ComponentBase {
    private static final String REMOVE_EMPTY_ROWS = "remove-empty-rows";
    private static final String IMAGE_URL = "image-url";
    private static final String IMAGE_DIR = "image-dir";
    private static final String TEXT_HTML = "text/html";
    private static final String CONFIG_XML = "jasperreports/jasperreports-conf.xml";
    private static final String HTML = "html";
    private static final String PDF = "pdf";
    private static final String XML = "xml";
    private static final String XLS = "xls";
    private static final String CSV = "csv";
    private static final String TXT = "txt";
    private static final String RTF = "rtf";
    private static final String NEED_TO_PROMPT = "NeedToPrompt";
    private static final String RETURN_IMMEDIATELY = "ReturnImmediately";
    private static final long serialVersionUID = -4422766007912720969L;
    public static final String JASPER_REPORTS_DESIGN_EXTENSION = ".jrxml";
    private static Log logger = LogFactory.getLog(JasperReportsComponent.class);
    public static final String COMPILED_JASPER_REPORTS_EXTENSION = ".jasper";
    public static final String REPORT_FOLDER_PARAMETER = "REPORT_FOLDER";

    public Log getLogger() {
        return logger;
    }

    protected boolean validateSystemSettings() {
        String imageUrl = PentahoSystem.getSystemSetting((String)CONFIG_XML, (String)"jasperreports/imageHandling/imageUrl", null);
        String imageDir = PentahoSystem.getSystemSetting((String)CONFIG_XML, (String)"jasperreports/imageHandling/imageDir", null);
        String removeEmptyRows = PentahoSystem.getSystemSetting((String)CONFIG_XML, (String)"jasperreports/htmlExportOptions/removeEmptySpaceBetweenRows", (String)"false");
        this.debug(Messages.getString("JasperReport.DEBUG_IMAGE_URL") + imageUrl);
        this.debug(Messages.getString("JasperReport.DEBUG_IMAGE_DIRECTORY") + imageDir);
        this.debug(Messages.getString("JasperReport.DEBUG_REMOVE_EMPTRY_ROWS") + removeEmptyRows);
        if (imageUrl == null) {
            this.error(Messages.getErrorString("JasperReport.ERROR_0001_IMAGE_URL_NOT_DEFINED"));
            return false;
        }
        if (imageDir == null) {
            this.error(Messages.getErrorString("JasperReport.ERROR_0002_IMAGE_DIRECTORY_INVALID"));
            return false;
        }
        this.saveSetting(IMAGE_URL, imageUrl);
        this.saveSetting(IMAGE_DIR, imageDir);
        this.saveSetting(REMOVE_EMPTY_ROWS, removeEmptyRows);
        return true;
    }

    public boolean validateAction() {
        boolean actionValidated = true;
        JasperReportAction reportAction = (JasperReportAction)this.getActionDefinition();
        if (this.getActionDefinition() instanceof JasperReportAction) {
            if (reportAction.getJndi() == ActionInputConstant.NULL_INPUT) {
                if (reportAction.getDriver() != ActionInputConstant.NULL_INPUT) {
                    this.error(Messages.getErrorString("JasperReport.ERROR_0003_JDBC_DRIVER_NOT_SPECIFIED"));
                    actionValidated = false;
                }
                if (actionValidated && reportAction.getConnection() == ActionInputConstant.NULL_INPUT) {
                    this.error(Messages.getErrorString("JasperReport.ERROR_0004_JDBC_CONNECTION_NOT_SPECIFIED"));
                    actionValidated = false;
                }
                if (actionValidated && reportAction.getUserId() == ActionInputConstant.NULL_INPUT) {
                    this.error(Messages.getErrorString("JasperReport.ERROR_0005_JDBC_USER_NOT_SPECIFIED"));
                    actionValidated = false;
                }
            }
            if (actionValidated && reportAction.getOutputType() == ActionInputConstant.NULL_INPUT) {
                this.error(Messages.getErrorString("JasperReport.ERROR_0006_OUTPUT_TYPE_NOT_SPECIFIED"));
                actionValidated = false;
            }
            if (actionValidated && reportAction.getReportDefinition() == null) {
                this.error(Messages.getErrorString("JasperReport.ERROR_0007_REPORT_DEFINITION_NOT_SPECIFIED"));
                actionValidated = false;
            }
        } else {
            actionValidated = false;
            this.error(Messages.getErrorString("ComponentBase.ERROR_0001_UNKNOWN_ACTION_TYPE", this.getActionDefinition().getElement().asXML()));
        }
        return actionValidated;
    }

    private JRExporter getExporter(String outputType, String reportName) {
        JRHtmlExporter exporter = null;
        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
        if (HTML.equals(outputType)) {
            String removeEmptyRows = this.getStringSetting("removeEmptyRows");
            exporter = new JRHtmlExporter();
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)Boolean.FALSE);
            if (removeEmptyRows != null && "true".equalsIgnoreCase(removeEmptyRows)) {
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
            }
            String imageUrl = requestContext.getContextPath() + this.getStringSetting(IMAGE_URL);
            StringBuffer tempImgPath = new StringBuffer().append(PentahoSystem.getApplicationContext().getSolutionPath(this.getStringSetting(IMAGE_DIR)));
            if (tempImgPath.charAt(tempImgPath.length() - 1) != File.separatorChar) {
                tempImgPath.append(File.separator);
            }
            tempImgPath.append(reportName).append(File.separator);
            String imagePath = tempImgPath.toString();
            File imageDir = new File(imagePath);
            imageDir.mkdirs();
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_DIR, (Object)imageDir);
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)(imageUrl + reportName + "/"));
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR, (Object)Boolean.TRUE);
            this.debug(Messages.getString("JasperReport.DEBUG_IMAGE_DIRECTORY", imagePath));
        } else if (PDF.equals(outputType)) {
            exporter = new JRPdfExporter();
        } else if (XLS.equals(outputType)) {
            exporter = new JRXlsExporter();
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.TRUE);
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
        } else if (CSV.equals(outputType)) {
            exporter = new JRCsvExporter();
        } else if (XML.equals(outputType)) {
            exporter = new JRXmlExporter();
        } else if (TXT.equals(outputType)) {
            exporter = new JRTextExporter();
            exporter.setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_HEIGHT, (Object)new Integer("120"));
            exporter.setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_WIDTH, (Object)new Integer("120"));
        } else if (RTF.equals(outputType)) {
            exporter = new JRRtfExporter();
        }
        return exporter;
    }

    public boolean executeAction() {
        IContentItem contentItem;
        OutputStream outputStream;
        JasperReportAction reportAction = (JasperReportAction)this.getActionDefinition();
        String reportOutputType = reportAction.getOutputType().getStringValue();
        this.debug(Messages.getString("JasperReport.DEBUG_OUTPUT_TYPE", reportOutputType));
        String mimeType = JasperReportsComponent.getMimeType(reportOutputType);
        if (mimeType == null) {
            this.error(Messages.getErrorString("JasperReport.ERROR_0011_OUTPUT_TYPE_INVALID"));
            return false;
        }
        String extension = "." + reportOutputType;
        HashSet<String> compiledReportPaths = new HashSet<String>();
        JasperReport jrreport = null;
        HashMap allReportParameters = new HashMap();
        IActionResource reportDefinition = reportAction.getReportDefinition();
        if (reportDefinition != null) {
            IActionSequenceResource resource = this.getResource(reportDefinition.getName());
            HashMap returnImmediately = new HashMap();
            this.processCurrentReport(resource, compiledReportPaths, jrreport, allReportParameters, returnImmediately, reportOutputType);
            if (!returnImmediately.isEmpty() && returnImmediately.containsKey(RETURN_IMMEDIATELY)) {
                return true;
            }
        } else {
            org.pentaho.actionsequence.dom.IActionSequenceResource[] actionSequenceResources;
            for (org.pentaho.actionsequence.dom.IActionSequenceResource element : actionSequenceResources = reportAction.getDocument().getResources()) {
                IActionSequenceResource resource = this.getResource(element.getName());
                HashMap returnImmediately = new HashMap();
                this.processCurrentReport(resource, compiledReportPaths, jrreport, allReportParameters, returnImmediately, reportOutputType);
                if (returnImmediately.isEmpty() || !returnImmediately.containsKey(RETURN_IMMEDIATELY)) continue;
                return true;
            }
        }
        if ((outputStream = this.getOutputStream(mimeType, extension, contentItem = null)) == null) {
            this.error(Messages.getErrorString("JasperReport.ERROR_0013_OUTPUT_STREAM_INVALID"));
            return false;
        }
        return this.exportReport(compiledReportPaths, allReportParameters, reportOutputType, outputStream, contentItem);
    }

    private boolean processCurrentReport(IActionSequenceResource resource, HashSet<String> compiledReportPaths, JasperReport jrreport, HashMap allReportParameters, HashMap returnImmediately, String reportOutputType) {
        boolean continueProcessing = true;
        String reportDefinitionPath = JasperReportsComponent.getReportDefinitionPath(resource);
        String compiledReportPath = "";
        if (reportDefinitionPath == null) {
            this.error(Messages.getErrorString("JasperReport.ERROR_0008_REPORT_DEFINITION_UNREADABLE"));
            continueProcessing = false;
        }
        if (continueProcessing && null == (compiledReportPath = this.getCompiledReportPath(reportDefinitionPath))) {
            continueProcessing = false;
        }
        if (continueProcessing) {
            compiledReportPaths.add(compiledReportPath);
            continueProcessing = this.didReportCompile(reportDefinitionPath, compiledReportPath);
        }
        if (continueProcessing && null == (jrreport = this.loadJasperReport(compiledReportPath))) {
            continueProcessing = false;
        }
        if (continueProcessing && jrreport != null) {
            JRParameter[] jrparams = jrreport.getParameters();
            this.debug(Messages.getString("JasperReport.DEBUG_LOADED_DESIGN", Integer.toString(jrparams.length)));
            HashMap needToPrompt = new HashMap();
            Map reportParameters = this.getReportParameters(jrparams, needToPrompt);
            reportParameters.put(REPORT_FOLDER_PARAMETER, new File(reportDefinitionPath).getParent());
            if (XLS.equals(reportOutputType) || HTML.equals(reportOutputType) || CSV.equals(reportOutputType)) {
                reportParameters.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
            }
            allReportParameters.put(compiledReportPath, reportParameters);
            if (!needToPrompt.isEmpty() && needToPrompt.containsKey(NEED_TO_PROMPT)) {
                this.setFeedbackMimeType(TEXT_HTML);
                returnImmediately.put(RETURN_IMMEDIATELY, null);
            } else if (this.getRuntimeContext().isPromptPending()) {
                returnImmediately.put(RETURN_IMMEDIATELY, null);
            }
        }
        return continueProcessing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exportReport(HashSet<String> compiledReportPaths, Map allReportParameters, String reportOutputType, OutputStream outputStream, IContentItem contentItem) {
        Connection conn = this.getConnection();
        if (conn == null) {
            return false;
        }
        try {
            String reportBaseName = "";
            ArrayList<JasperPrint> jasperPrintList = new ArrayList<JasperPrint>();
            for (String compiledReportPath : compiledReportPaths) {
                Map reportParameters = (Map)allReportParameters.get(compiledReportPath);
                JasperPrint jrprint = JasperFillManager.fillReport((String)compiledReportPath, (Map)reportParameters, (Connection)conn);
                jasperPrintList.add(jrprint);
                File compiledReportFile = new File(compiledReportPath);
                String lastReportBaseName = compiledReportFile.getName();
                int extensionIdx = lastReportBaseName.lastIndexOf(".");
                if (extensionIdx > 0) {
                    lastReportBaseName = lastReportBaseName.substring(0, extensionIdx);
                }
                reportBaseName = reportBaseName.concat(lastReportBaseName);
            }
            JRExporter exporter = this.getExporter(reportOutputType, reportBaseName);
            ArrayList jasperPrintListReversed = new ArrayList();
            for (int i = jasperPrintList.size() - 1; i >= 0; --i) {
                jasperPrintListReversed.add(jasperPrintList.get(i));
            }
            exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, jasperPrintListReversed);
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)outputStream);
            exporter.exportReport();
        }
        catch (JRException jre) {
            this.error(Messages.getErrorString("JasperReport.ERROR_0014_REPORT_EXECUTION_FAILED"), jre);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                conn.close();
                if (contentItem != null) {
                    contentItem.closeOutputStream();
                }
            }
            catch (SQLException ignored) {}
        }
        return true;
    }

    private Map getReportParameters(JRParameter[] jrparams, HashMap needToPrompt) {
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        for (JRParameter param : jrparams) {
            if (param.isSystemDefined()) continue;
            String parameterName = param.getName();
            Object parameterValue = null;
            IActionInput actionInput = this.getActionDefinition().getInput(parameterName);
            if (actionInput != null) {
                if (actionInput instanceof ActionInput && ((ActionInput)actionInput).getType().equals("string-list")) {
                    Object parameterObject = this.getInputValue(parameterName);
                    parameterValue = this.sqlQuote(parameterObject);
                } else {
                    parameterValue = this.getInputStringValue(parameterName);
                }
            }
            if (parameterValue != null && parameterValue.toString().length() != 0) {
                this.debug(Messages.getString("JasperReport.DEBUG_ADDING_PARAMETER", parameterName, parameterValue.toString()));
                reportParameters.put(parameterName, parameterValue);
                continue;
            }
            if (!param.isForPrompting()) continue;
            this.debug(Messages.getString("JasperReport.DEBUG_PARAMETER_NEEDED", parameterName));
            if (!this.feedbackAllowed()) continue;
            IActionParameter paramParameter = this.getInputParameter(parameterName);
            if (paramParameter.getPromptStatus() != 3) {
                String displayName = param.getDescription();
                if (displayName == null || displayName.trim().length() == 0) {
                    displayName = parameterName;
                }
                String defaultValue = "";
                this.createFeedbackParameter(parameterName, displayName, "", defaultValue, true);
            }
            needToPrompt.put(NEED_TO_PROMPT, Boolean.TRUE);
        }
        return reportParameters;
    }

    private JasperReport loadJasperReport(String compiledReportPath) {
        this.debug(Messages.getString("JasperReport.DEBUG_LOADING_REPORT_DESIGN"));
        JasperReport jrreport = null;
        try {
            jrreport = (JasperReport)JRLoader.loadObject((String)compiledReportPath);
        }
        catch (JRException jre) {
            jrreport = null;
            this.error(Messages.getErrorString("JasperReport.ERROR_0012_REPORT_DESIGN_NO_LOADABLE", compiledReportPath), jre);
        }
        return jrreport;
    }

    private String getCompiledReportPath(String reportDefinitionPath) {
        String compiledReportPath = null;
        this.debug(Messages.getString("JasperReport.GETTING_REPORT_PATH", reportDefinitionPath));
        File sourceFile = new File(reportDefinitionPath);
        String reportBaseName = sourceFile.getName();
        int extensionIdx = reportBaseName.lastIndexOf(".");
        if (extensionIdx > 0) {
            reportBaseName = reportBaseName.substring(0, extensionIdx);
        }
        if (reportDefinitionPath.endsWith(COMPILED_JASPER_REPORTS_EXTENSION)) {
            compiledReportPath = reportDefinitionPath;
        } else if (!sourceFile.exists()) {
            compiledReportPath = null;
            this.error(Messages.getErrorString("JasperReport.ERROR_0009_REPORT_DEFINITION_MISSING", reportDefinitionPath));
        } else {
            this.debug(Messages.getString("JasperReport.DEBUG_REPORT_FILE_FOUND"));
            StringBuffer sb = new StringBuffer();
            sb.append(sourceFile.getParent());
            if (!sourceFile.getParent().endsWith(File.separator)) {
                sb.append(File.separator);
            }
            sb.append(reportBaseName).append(COMPILED_JASPER_REPORTS_EXTENSION);
            compiledReportPath = sb.toString();
        }
        return compiledReportPath;
    }

    private boolean didReportCompile(String reportDefinitionPath, String compiledReportPath) {
        boolean reportCompiled = true;
        this.debug(Messages.getString("JasperReport.DEBUG_RUNNING_REPORT", reportDefinitionPath));
        this.debug(Messages.getString("JasperReport.DEBUG_COMPILED_REPORT_LOCATION", compiledReportPath));
        File compiledReportFile = new File(compiledReportPath);
        File sourceFile = new File(reportDefinitionPath);
        if (!compiledReportFile.exists() || sourceFile.lastModified() > compiledReportFile.lastModified()) {
            this.debug(Messages.getString("JasperReport.DEBUG_COMPILING_REPORT"));
            System.setProperty("jasper.reports.compiler.class", "net.sf.jasperreports.engine.design.JRJdtCompiler");
            try {
                JasperCompileManager.compileReportToFile((String)reportDefinitionPath, (String)compiledReportPath);
            }
            catch (JRException jre) {
                this.error(Messages.getErrorString("JasperReport.ERROR_0010_UNABLE_TO_COMPILE", reportDefinitionPath, compiledReportPath), jre);
                reportCompiled = false;
            }
            if (reportCompiled) {
                this.debug(Messages.getString("JasperReport.DEBUG_COMPILED_OK"));
            }
        }
        return reportCompiled;
    }

    private static String getReportDefinitionPath(IActionSequenceResource resource) {
        String reportDefinitionPath = null;
        reportDefinitionPath = resource.getSourceType() == 1 ? PentahoSystem.getApplicationContext().getSolutionPath(resource.getAddress()) : resource.getAddress();
        return reportDefinitionPath;
    }

    private static String getMimeType(String reportOutputType) {
        String mimeType = null;
        mimeType = HTML.equals(reportOutputType) ? TEXT_HTML : (PDF.equals(reportOutputType) ? "application/pdf" : (XLS.equals(reportOutputType) ? "application/vnd.ms-excel" : (CSV.equals(reportOutputType) ? "text/text" : (XML.equals(reportOutputType) ? "text/xml" : (TXT.equals(reportOutputType) ? "text/plain" : (RTF.equals(reportOutputType) ? "application/rtf" : "application/octet-stream"))))));
        return mimeType;
    }

    private OutputStream getOutputStream(String mimeType, String extension, IContentItem contentItem) {
        OutputStream outputStream = null;
        JasperReportAction reportAction = (JasperReportAction)this.getActionDefinition();
        if (reportAction.getOutputReport() != null) {
            contentItem = this.getOutputItem(reportAction.getOutputReport().getName(), mimeType, extension);
            try {
                outputStream = contentItem.getOutputStream(this.getActionName());
            }
            catch (IOException e) {
                outputStream = null;
            }
        } else if (this.getOutputNames().size() == 1) {
            String outputName = (String)this.getOutputNames().iterator().next();
            contentItem = this.getOutputContentItem(outputName, mimeType);
            try {
                outputStream = contentItem.getOutputStream(this.getActionName());
            }
            catch (IOException e) {
                outputStream = null;
            }
        } else {
            this.warn(Messages.getString("Base.WARN_NO_OUTPUT_STREAM"));
            outputStream = this.getDefaultOutputStream(mimeType);
            if (outputStream != null) {
                this.setOutputMimeType(mimeType);
            }
        }
        return outputStream;
    }

    public boolean init() {
        return true;
    }

    public void done() {
    }

    private Connection getConnection() {
        try {
            JasperReportAction reportAction = (JasperReportAction)this.getActionDefinition();
            String jndiUrl = reportAction.getJndi().getStringValue();
            Connection conn = null;
            if (jndiUrl != null) {
                IDatasourceService datasourceService = (IDatasourceService)PentahoSystem.getObjectFactory().get(IDatasourceService.class, null);
                DataSource ds = datasourceService.getDataSource(jndiUrl);
                return ds.getConnection();
            }
            String driver = reportAction.getDriver().getStringValue();
            String connectString = reportAction.getConnection().getStringValue();
            String user = reportAction.getUserId().getStringValue();
            String password = reportAction.getPassword().getStringValue();
            Class.forName(driver);
            conn = DriverManager.getConnection(connectString, user, password);
            return conn;
        }
        catch (ObjectFactoryException objface) {
            this.error(Messages.getErrorString("JasperReport.ERROR_0017_UNABLE_TO_FACTORY_OBJECT"));
        }
        catch (ClassNotFoundException cnfe) {
            this.error(Messages.getErrorString("JasperReport.ERROR_0015_JDBC_DRIVER_LOAD_FAILED"));
        }
        catch (SQLException se) {
            this.error(Messages.getErrorString("JasperReport.ERROR_0016_DATABASE_CONNECTION_FAILED"), se);
        }
        catch (DatasourceServiceException dse) {
            this.error(Messages.getErrorString("JasperReport.ERROR_0016_DATABASE_CONNECTION_FAILED"), dse);
        }
        return null;
    }

    private String sqlQuote(Object obj) {
        if (obj == null) {
            return null;
        }
        String out = null;
        if (obj instanceof String[]) {
            List<String> c = Arrays.asList((String[])obj);
            out = JasperReportsComponent.quoteMe(c);
        } else if (obj instanceof List) {
            out = JasperReportsComponent.quoteMe((Collection)obj);
        } else {
            if (!(obj instanceof String)) {
                this.warn("Unknown type " + obj.getClass() + " in object " + obj);
            }
            out = "'" + obj.toString().replaceAll("'", "'") + "'";
        }
        return out;
    }

    private static String quoteMe(Collection c) {
        if (c.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Object value : c) {
            sb.append(",'");
            sb.append(value.toString().replaceAll("'", "''"));
            sb.append("'");
        }
        return sb.substring(1);
    }
}

