/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.actionsequence.dom.actions.JFreeReportAction;
import org.pentaho.commons.connection.ActivationHelper;
import org.pentaho.commons.connection.IPentahoConnection;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.jfreereport.castormodel.reportspec.ReportSpec;
import org.pentaho.jfreereport.wizard.utility.CastorUtility;
import org.pentaho.jfreereport.wizard.utility.report.ReportGenerationUtility;
import org.pentaho.jfreereport.wizard.utility.report.ReportParameterUtility;
import org.pentaho.platform.api.data.IDatasourceService;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.PentahoConnectionFactory;
import org.pentaho.platform.plugin.action.jfreereport.JFreeReportComponent;
import org.pentaho.platform.plugin.action.jfreereport.helper.PentahoTableDataFactory;
import org.pentaho.platform.plugin.action.jfreereport.helper.PentahoTableModel;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.reporting.engine.classic.core.MasterReport;

public class ReportWizardSpecComponent
extends JFreeReportComponent {
    private static final long serialVersionUID = 3435921119638344882L;
    private ReportSpec reportSpec;

    public Log getLogger() {
        return LogFactory.getLog(ReportWizardSpecComponent.class);
    }

    public boolean validateAction() {
        JFreeReportAction jFreeReportAction = (JFreeReportAction)this.getActionDefinition();
        return jFreeReportAction.getReportDefinition() != null && super.validateAction();
    }

    protected boolean executeReportAction() {
        boolean result = true;
        try {
            this.reportSpec = this.getReportSpec();
            result = super.executeReportAction();
        }
        catch (IOException ex) {
            this.error(ex.getLocalizedMessage());
            result = false;
        }
        return result;
    }

    public MasterReport getReport() throws Exception {
        MasterReport report = null;
        if (this.reportSpec != null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ReportGenerationUtility.createJFreeReportXML((ReportSpec)this.reportSpec, (OutputStream)outputStream, (int)0, (int)0, (boolean)false, (String)"", (int)0, (int)0);
            String reportDefinition = new String(outputStream.toByteArray());
            report = this.createReport(reportDefinition);
        } else {
            report = super.getReport();
        }
        return report;
    }

    protected PentahoTableDataFactory getDataFactory() throws ClassNotFoundException, InstantiationException, IllegalAccessException, Exception {
        PentahoTableDataFactory factory = null;
        if (this.reportSpec != null) {
            if (!this.isDefinedInput("_PERFORM.QUERY") || "true".equals(this.getInputParameter("_PERFORM.QUERY"))) {
                if (this.reportSpec.getReportSpecChoice().getXqueryUrl() == null) {
                    IPentahoResultSet pentahoResultSet = this.getResultSet(this.getReportSpec());
                    factory = new PentahoTableDataFactory();
                    pentahoResultSet.beforeFirst();
                    factory.addTable("default", new PentahoTableModel(pentahoResultSet));
                }
            } else {
                factory = super.getDataFactory();
            }
        } else {
            factory = super.getDataFactory();
        }
        return factory;
    }

    public ReportSpec getReportSpec() throws IOException {
        JFreeReportAction jFreeReportAction = (JFreeReportAction)this.getActionDefinition();
        ActivationHelper.PentahoStreamSourceWrapper dataSource = new ActivationHelper.PentahoStreamSourceWrapper(jFreeReportAction.getReportDefinitionDataSource());
        ReportSpec reportSpec = null;
        reportSpec = this.loadFromZip(dataSource.getInputStream());
        if (reportSpec == null) {
            dataSource = new ActivationHelper.PentahoStreamSourceWrapper(jFreeReportAction.getReportDefinitionDataSource());
            reportSpec = (ReportSpec)CastorUtility.getInstance().readCastorObject(dataSource.getInputStream(), ReportSpec.class);
        }
        return reportSpec;
    }

    private ReportSpec loadFromZip(InputStream reportSpecInputStream) {
        try {
            ZipInputStream zis = new ZipInputStream(reportSpecInputStream);
            ZipEntry reportSpecEntry = this.findReportSpec(zis);
            if (reportSpecEntry == null) {
                return null;
            }
            return (ReportSpec)CastorUtility.getInstance().readCastorObject((InputStream)zis, ReportSpec.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private ZipEntry findReportSpec(ZipInputStream zStrm) throws IOException {
        ZipEntry reportSpecEntry = null;
        reportSpecEntry = zStrm.getNextEntry();
        while (null != reportSpecEntry && !reportSpecEntry.getName().endsWith(".xreportspec")) {
            reportSpecEntry = zStrm.getNextEntry();
        }
        return reportSpecEntry;
    }

    public IPentahoResultSet getResultSet(ReportSpec reportSpec) throws Exception {
        String jndiName = reportSpec.getReportSpecChoice().getJndiSource();
        IPentahoConnection connection = null;
        if (reportSpec.getIsMDX()) {
            String connectStr = "";
            IDatasourceService datasourceService = (IDatasourceService)PentahoSystem.getObjectFactory().get(IDatasourceService.class, null);
            String dsName = datasourceService.getDSBoundName(jndiName);
            if (dsName == null) {
                this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0005_INVALID_CONNECTION"));
                return null;
            }
            connectStr = "dataSource=" + dsName + "; Catalog=mondrian";
            Properties props = new Properties();
            props.setProperty("connection", connectStr);
            props.setProperty("provider", reportSpec.getMondrianCubeDefinitionPath());
            connection = PentahoConnectionFactory.getConnection((String)"MDX", (Properties)props, (IPentahoSession)this.getSession(), (ILogger)this);
        } else {
            connection = PentahoConnectionFactory.getConnection((String)"SQL", (String)jndiName, (IPentahoSession)this.getSession(), (ILogger)this);
        }
        String query = ReportParameterUtility.setupParametersForActionSequence((String)reportSpec.getQuery());
        query = this.setupQueryParameters(query);
        IPentahoResultSet res = connection.executeQuery(query);
        return res;
    }

    public String setupQueryParameters(String query) {
        Set inputNames = this.getInputNames();
        for (String inputName : inputNames) {
            IActionParameter inputParameter = this.getInputParameter(inputName);
            Object value = inputParameter.getValue();
            if (!(value instanceof String)) continue;
            String paramValue = (String)value;
            String param = "\\{" + inputName + "\\}";
            query = query.replaceAll(param, paramValue);
        }
        return query;
    }
}

