/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport.components;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.jfreereport.AbstractJFreeReportComponent;
import org.pentaho.platform.plugin.action.jfreereport.helper.ReportUtils;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportGenerator;
import org.pentaho.reporting.libraries.resourceloader.FactoryParameterKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.xml.sax.InputSource;

@Deprecated
public class JFreeReportLoadComponent
extends AbstractJFreeReportComponent {
    private static final long serialVersionUID = -2240691437049710246L;

    protected boolean validateAction() {
        if (this.isDefinedResource("report-definition")) {
            return true;
        }
        if (this.isDefinedInput("report-definition")) {
            IActionParameter o = this.getInputParameter("report-definition");
            return o != null && o.getValue() instanceof String;
        }
        if (this.isDefinedInput("resource-name")) {
            if (this.isDefinedResource(this.getInputStringValue("resource-name"))) {
                return true;
            }
            this.error(Messages.getErrorString("JFreeReport.ERROR_0004_REPORT_DEFINITION_UNREADABLE"));
            return false;
        }
        if (this.isDefinedResource("report-jar")) {
            InputStream in;
            if (!this.isDefinedInput("report-location")) {
                this.error(Messages.getErrorString("JFreeReport.ERROR_0011_REPORT_LOCATION_MISSING"));
                return false;
            }
            IActionSequenceResource resource = this.getResource("report-jar");
            ISolutionRepository solutionRepository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getSession());
            try {
                in = solutionRepository.getResourceInputStream(resource, true, 1);
            }
            catch (FileNotFoundException e1) {
                this.error(Messages.getErrorString("JFreeReport.ERROR_0010_REPORT_JAR_MISSING", resource.getAddress()));
                return false;
            }
            try {
                if (in.read() == -1) {
                    this.error(Messages.getErrorString("JFreeReport.ERROR_0009_REPORT_JAR_UNREADABLE"));
                    return false;
                }
            }
            catch (Exception e) {
                this.error(Messages.getErrorString("JFreeReport.ERROR_0009_REPORT_JAR_UNREADABLE"));
                return false;
            }
            if (!this.isDefinedInput("report-location")) {
                this.error(Messages.getErrorString("JFreeReport.ERROR_0012_CLASS_LOCATION_MISSING"));
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    public void done() {
    }

    private MasterReport getReportFromResource() throws ResourceException, IOException {
        String resName;
        MasterReport report = null;
        if (this.isDefinedResource("report-definition")) {
            IActionSequenceResource resource = this.getResource("report-definition");
            if (resource.getSourceType() == 6) {
                String repDef = resource.getAddress();
                ReportGenerator generator = ReportGenerator.getInstance();
                report = generator.parseReport(new InputSource(new ByteArrayInputStream(repDef.getBytes())), this.getDefinedResourceURL(null));
            }
            report = this.parseReport(resource);
        } else if (this.isDefinedInput("resource-name") && this.isDefinedResource(resName = this.getInputStringValue("resource-name"))) {
            IActionSequenceResource resource = this.getResource(resName);
            report = this.parseReport(resource);
        }
        return report;
    }

    private MasterReport getReportFromInputParam() throws ResourceException, UnsupportedEncodingException, IOException {
        IActionParameter o;
        MasterReport report = null;
        if (this.isDefinedInput("report-definition") && (o = this.getInputParameter("report-definition")) != null) {
            String repDef = o.getStringValue();
            ReportGenerator generator = ReportGenerator.getInstance();
            IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
            URL url = null;
            try {
                url = new URL(requestContext.getContextPath());
            }
            catch (Exception e) {
                this.warn(Messages.getString("JFreeReportLoadComponent.WARN_COULD_NOT_CREATE_URL"));
            }
            report = generator.parseReport(new InputSource(new ByteArrayInputStream(repDef.getBytes("UTF-8"))), this.getDefinedResourceURL(url));
        }
        return report;
    }

    private MasterReport getReportFromJar() throws Exception {
        MasterReport report;
        IActionSequenceResource resource = this.getResource("report-jar");
        ClassLoader loader = ReportUtils.createJarLoader(this.getSession(), resource);
        if (loader == null) {
            throw new Exception(Messages.getString("JFreeReportLoadComponent.ERROR_0035_COULD_NOT_CREATE_CLASSLOADER"));
        }
        String reportLocation = this.getInputStringValue("report-location");
        URL resourceUrl = loader.getResource(reportLocation);
        if (resourceUrl == null) {
            throw new Exception(Messages.getErrorString("JFreeReport.ERROR_0016_REPORT_RESOURCE_INVALID", reportLocation, resource.getAddress()));
        }
        try {
            ReportGenerator generator = ReportGenerator.getInstance();
            report = generator.parseReport(resourceUrl, this.getDefinedResourceURL(resourceUrl));
        }
        catch (Exception ex) {
            throw new Exception(Messages.getErrorString("JFreeReport.ERROR_0007_COULD_NOT_PARSE", reportLocation), ex);
        }
        return report;
    }

    public MasterReport getReport() throws Exception {
        MasterReport report = this.getReportFromResource();
        if (report == null && (report = this.getReportFromInputParam()) == null) {
            report = this.getReportFromJar();
        }
        return report;
    }

    protected boolean executeAction() throws Throwable {
        boolean result = false;
        try {
            MasterReport report = this.getReport();
            if (report != null) {
                this.addTempParameterObject("_REPORT.OBJECT", report);
                result = true;
            }
        }
        catch (Exception ex) {
            this.error(ex.getMessage());
        }
        return result;
    }

    private URL getDefinedResourceURL(URL defaultValue) {
        if (!this.isDefinedInput("res-url")) {
            return defaultValue;
        }
        try {
            String inputStringValue = this.getInputStringValue(Messages.getString("res-url"));
            return new URL(inputStringValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private String getBaseServerURL(String pentahoBaseURL) {
        try {
            URL url = new URL(pentahoBaseURL);
            return url.getProtocol() + "://" + url.getHost() + ":" + url.getPort();
        }
        catch (Exception exception) {
            return pentahoBaseURL;
        }
    }

    private String getHostColonPort(String pentahoBaseURL) {
        try {
            URL url = new URL(pentahoBaseURL);
            return url.getHost() + ":" + url.getPort();
        }
        catch (Exception exception) {
            return pentahoBaseURL;
        }
    }

    private MasterReport parseReport(IActionSequenceResource resource) {
        try {
            String resourceUrl = "solution:/" + resource.getAddress();
            String fullyQualifiedServerUrl = PentahoSystem.getApplicationContext().getFullyQualifiedServerURL();
            HashMap<FactoryParameterKey, String> helperObjects = new HashMap<FactoryParameterKey, String>();
            helperObjects.put(new FactoryParameterKey("pentahoBaseURL"), fullyQualifiedServerUrl);
            helperObjects.put(new FactoryParameterKey("serverBaseURL"), this.getBaseServerURL(fullyQualifiedServerUrl));
            helperObjects.put(new FactoryParameterKey("solutionRoot"), PentahoSystem.getApplicationContext().getSolutionPath(""));
            helperObjects.put(new FactoryParameterKey("hostColonPort"), this.getHostColonPort(fullyQualifiedServerUrl));
            helperObjects.put(new FactoryParameterKey("requestContextPath"), PentahoRequestContextHolder.getRequestContext().getContextPath());
            Iterator it = this.getInputNames().iterator();
            while (it.hasNext()) {
                try {
                    String inputName = (String)it.next();
                    String inputValue = this.getInputStringValue(inputName);
                    helperObjects.put(new FactoryParameterKey(inputName), inputValue);
                }
                catch (Exception e) {}
            }
            ResourceManager resourceManager = new ResourceManager();
            resourceManager.registerDefaults();
            ResourceKey contextKey = resourceManager.createKey((Object)resourceUrl, helperObjects);
            ResourceKey key = resourceManager.createKey((Object)resourceUrl, helperObjects);
            return ReportGenerator.getInstance().parseReport(resourceManager, key, contextKey);
        }
        catch (Exception ex) {
            this.error(Messages.getErrorString("JFreeReport.ERROR_0007_COULD_NOT_PARSE", resource.getAddress()), ex);
            return null;
        }
    }

    public boolean init() {
        return true;
    }

    public Log getLogger() {
        return LogFactory.getLog(JFreeReportLoadComponent.class);
    }
}

