/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport.helper;

import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;

public class PentahoResourceBundleFactory
implements ResourceBundleFactory {
    private static final long serialVersionUID = -1555502100120929073L;
    private String path;
    private String baseName;
    private ClassLoader loader;

    public PentahoResourceBundleFactory(String inPath, String inBaseName, IPentahoSession inSession) {
        this.path = inPath;
        this.baseName = inBaseName;
        this.loader = ((ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)inSession)).getClassLoader(this.path);
    }

    public Locale getLocale() {
        return LocaleHelper.getLocale();
    }

    public ResourceBundle getResourceBundle(String resourceName) {
        if (resourceName == null) {
            resourceName = this.baseName;
        }
        try {
            return ResourceBundle.getBundle(resourceName, this.getLocale(), this.loader);
        }
        catch (Exception e) {
            Logger.error((String)this.getClass().getName(), (String)Messages.getErrorString("JFreeReport.ERROR_0024_COULD_NOT_READ_PROPERTIES", this.path + File.separator + this.baseName), (Throwable)e);
            return null;
        }
    }

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }
}

