/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport.helper;

import java.io.FileNotFoundException;
import java.io.InputStream;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.actionsequence.ActionSequenceResource;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.loader.AbstractResourceData;

public class PentahoResourceData
extends AbstractResourceData {
    private static final long serialVersionUID = 1806026106310340013L;
    private String filename;
    private ResourceKey key;

    public PentahoResourceData(ResourceKey key) throws ResourceLoadingException {
        if (key == null) {
            throw new NullPointerException();
        }
        this.key = key;
        this.filename = (String)key.getIdentifier();
    }

    public InputStream getResourceAsStream(ResourceManager caller) throws ResourceLoadingException {
        int resourceType = 1;
        if (this.filename.contains("://")) {
            resourceType = 2;
        }
        ActionSequenceResource resource = new ActionSequenceResource("", resourceType, "application/binary", (String)this.key.getIdentifier());
        try {
            ISolutionRepository solutionRepository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class);
            return solutionRepository.getResourceInputStream((IActionSequenceResource)resource, true, 1);
        }
        catch (FileNotFoundException e) {
            throw new ResourceLoadingException(e.getLocalizedMessage(), (Exception)e);
        }
    }

    public Object getAttribute(String lookupKey) {
        if (lookupKey.equals("filename")) {
            return this.filename;
        }
        return null;
    }

    public long getVersion(ResourceManager caller) throws ResourceLoadingException {
        ActionSequenceResource resource = new ActionSequenceResource("", 1, "application/binary", (String)this.key.getIdentifier());
        ISolutionRepository solutionRepository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class);
        ISolutionFile file = solutionRepository.getSolutionFile((IActionSequenceResource)resource, 1);
        long version = -1L;
        if (file != null) {
            version = file.getLastModified();
        }
        return version;
    }

    public ResourceKey getKey() {
        return this.key;
    }
}

