/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport.helper;

import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.TableModel;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.data.IPreparedComponent;
import org.pentaho.platform.plugin.action.jfreereport.helper.PentahoTableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class PentahoTableDataFactory
implements DataFactory,
Cloneable {
    private static final long serialVersionUID = -338882557376609479L;
    private HashMap<String, TableModel> tables = new HashMap();
    private HashMap<String, IPreparedComponent> components = new HashMap();
    private ResourceManager resourceManager;
    private ResourceKey contextKey;

    public PentahoTableDataFactory() {
    }

    public PentahoTableDataFactory(String name, TableModel tableModel) {
        this();
        this.addTable(name, tableModel);
    }

    public void initialize(Configuration configuration, ResourceManager resourceManager, ResourceKey contextKey, ResourceBundleFactory resourceBundleFactory) {
        this.resourceManager = resourceManager;
        this.contextKey = contextKey;
    }

    public void addTable(String name, TableModel tableModel) {
        this.tables.put(name, tableModel);
    }

    public void addPreparedComponent(String name, IPreparedComponent component) {
        this.components.put(name, component);
    }

    public void removeTable(String name) {
        this.tables.remove(name);
    }

    public TableModel queryData(String query, DataRow parameters) {
        IPreparedComponent component;
        TableModel model = this.tables.get(query);
        if (model == null && (component = this.components.get(query)) != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (parameters != null) {
                String[] columnNames;
                for (String columnName : columnNames = parameters.getColumnNames()) {
                    map.put(columnName, parameters.get(columnName));
                }
            }
            IPentahoResultSet rs = component.executePrepared(map);
            model = new PentahoTableModel(rs);
        }
        return model;
    }

    public void open() {
    }

    public void close() {
    }

    public void closeTables() {
        for (TableModel model : this.tables.values()) {
            if (!(model instanceof CloseableTableModel)) continue;
            CloseableTableModel closeableTableModel = (CloseableTableModel)model;
            closeableTableModel.close();
        }
        this.tables.clear();
    }

    public DataFactory derive() {
        return (DataFactory)this.clone();
    }

    public Object clone() {
        try {
            PentahoTableDataFactory dataFactory = (PentahoTableDataFactory)super.clone();
            dataFactory.tables = (HashMap)this.tables.clone();
            dataFactory.components = (HashMap)this.components.clone();
            return dataFactory;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Failed", e);
        }
    }

    public String[] getQueryNames() {
        ArrayList<String> queryNameList = new ArrayList<String>();
        queryNameList.addAll(this.tables.keySet());
        queryNameList.addAll(this.components.keySet());
        String[] queryNames = queryNameList.toArray(new String[queryNameList.size()]);
        return queryNames;
    }

    public boolean isQueryExecutable(String query, DataRow parameters) {
        boolean queryExecutable = this.tables.containsKey(query) || this.components.containsKey(query);
        return queryExecutable;
    }

    public void cancelRunningQuery() {
    }
}

