/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport.helper;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import org.jfree.io.IOUtils;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.messages.Messages;

public class ReportUtils {
    private ReportUtils() {
    }

    public static synchronized File getTempDirectory(IPentahoSession session) {
        IApplicationContext ctx = PentahoSystem.getApplicationContext();
        if (ctx != null) {
            String fileOutputPath = ctx.getFileOutputPath("system/tmp/");
            File tempDir = new File(fileOutputPath);
            String id = session.getId();
            File userTempDir = id == null ? tempDir : new File(tempDir, id);
            userTempDir.mkdir();
            return userTempDir;
        }
        throw new IllegalStateException(Messages.getString("ReportUtils.ERROR_0036_PENTAHO_SYSTEM_NOT_OK"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader createJarLoader(IPentahoSession session, IActionSequenceResource resource) {
        IPentahoSession iPentahoSession = session;
        synchronized (iPentahoSession) {
            try {
                URL url = ReportUtils.getURL(session, resource, true);
                if (url == null) {
                    return null;
                }
                Map cache = ReportUtils.getClassLoaderCache(session);
                ClassLoaderEntry entry = (ClassLoaderEntry)cache.get(url);
                if (entry != null && entry.getEntry() != null) {
                    return entry.getEntry();
                }
                URL jarURL = new URL("jar:" + url.toExternalForm() + "!/");
                URLClassLoader urlClassLoader = URLClassLoader.newInstance(new URL[]{jarURL});
                cache.put(url, new ClassLoaderEntry(urlClassLoader));
                return urlClassLoader;
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getClassLoaderCache(IPentahoSession session) {
        IPentahoSession iPentahoSession = session;
        synchronized (iPentahoSession) {
            Object maybeMap = session.getAttribute("-x-pentaho-classloaders");
            if (maybeMap instanceof Map) {
                return (Map)maybeMap;
            }
            HashMap map = new HashMap();
            session.setAttribute("-x-pentaho-classloaders", map);
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL getURL(IPentahoSession session, IActionSequenceResource resource, boolean create) throws IOException {
        String reportJarPath;
        File file;
        File file2;
        if (resource.getSourceType() == 2) {
            return new URL(resource.getAddress());
        }
        if (resource.getSourceType() == 3 && (file2 = new File(resource.getAddress())).exists() && file2.canRead()) {
            return file2.toURL();
        }
        if (resource.getSourceType() == 1 && (file = new File(reportJarPath = PentahoSystem.getApplicationContext().getSolutionPath(resource.getAddress()))).exists() && file.canRead()) {
            return file.toURL();
        }
        if (create) {
            File temp = ReportUtils.getTempDirectory(session);
            File tempFile = PentahoSystem.getApplicationContext().createTempFile(session, "loaded-jar-", ".jar", temp, true);
            URL url = tempFile.toURL();
            ISolutionRepository solutionRepository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)session);
            InputStream in = solutionRepository.getResourceInputStream(resource, true, 1);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));
            try {
                IOUtils.getInstance().copyStreams(in, (OutputStream)out);
            }
            finally {
                in.close();
                ((OutputStream)out).close();
            }
            return url;
        }
        return null;
    }

    public static URL getURL(IPentahoSession session, IActionSequenceResource resource) throws IOException {
        return ReportUtils.getURL(session, resource, false);
    }

    private static class ClassLoaderEntry
    implements Serializable {
        private static final long serialVersionUID = 8925334939030498948L;
        private transient ClassLoader entry;

        public ClassLoaderEntry(ClassLoader entry) {
            this.entry = entry;
        }

        public ClassLoader getEntry() {
            return this.entry;
        }
    }
}

