/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport.outputs;

import java.io.OutputStream;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.plugin.action.jfreereport.outputs.AbstractGenerateContentComponent;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.reporting.engine.classic.core.MasterReport;

public abstract class AbstractGenerateStreamContentComponent
extends AbstractGenerateContentComponent {
    private static final long serialVersionUID = -4562767913928444314L;
    private IContentItem contentItem = null;

    protected AbstractGenerateStreamContentComponent() {
    }

    protected boolean validateAction() {
        if (!super.validateAction()) {
            return false;
        }
        if (this.isDefinedOutput("report-output")) {
            return true;
        }
        if (this.getOutputNames().size() == 1) {
            return true;
        }
        if (this.getOutputNames().size() == 0) {
            this.warn(Messages.getString("Base.WARN_NO_OUTPUT_STREAM"));
            return true;
        }
        this.warn(Messages.getString("AbstractGenerateStreamContentComponent.JFreeReport.ERROR_0038_NO_OUTPUT_DEFINED"));
        return false;
    }

    protected abstract String getMimeType();

    protected abstract String getExtension();

    protected final boolean performExport(MasterReport report) {
        OutputStream outputStream = this.createOutputStream();
        if (outputStream == null) {
            this.error(Messages.getErrorString("JFreeReport.ERROR_0008_INVALID_OUTPUT_STREAM"));
            return false;
        }
        return this.performExport(report, outputStream);
    }

    protected final void close() {
        if (this.contentItem != null) {
            this.contentItem.closeOutputStream();
        }
    }

    protected abstract boolean performExport(MasterReport var1, OutputStream var2);

    protected OutputStream createOutputStream() {
        String mimeType = this.getMimeType();
        if (this.isDefinedOutput("report-output")) {
            this.contentItem = this.getOutputItem("report-output", mimeType, this.getExtension());
            try {
                this.contentItem.setMimeType(mimeType);
                return this.contentItem.getOutputStream(this.getActionName());
            }
            catch (Exception e) {
                return null;
            }
        }
        if (this.getOutputNames().size() == 1) {
            String outputName = (String)this.getOutputNames().iterator().next();
            this.contentItem = this.getOutputContentItem(outputName, mimeType);
            try {
                this.contentItem.setMimeType(mimeType);
                return this.contentItem.getOutputStream(this.getActionName());
            }
            catch (Exception e) {
                return null;
            }
        }
        if (this.getOutputNames().size() == 0) {
            OutputStream outputStream = this.getDefaultOutputStream(mimeType);
            return outputStream;
        }
        return null;
    }

    protected IContentItem getContentItem() {
        return this.contentItem;
    }
}

