/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport.outputs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.IContentRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.jfreereport.helper.PentahoURLRewriter;
import org.pentaho.platform.plugin.action.jfreereport.outputs.AbstractGenerateStreamContentComponent;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.YieldReportListener;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.StreamReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.AllItemsHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.StreamHtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriter;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.file.FileRepository;
import org.pentaho.reporting.libraries.repository.stream.StreamRepository;

public class JFreeReportHtmlComponent
extends AbstractGenerateStreamContentComponent {
    private static final long serialVersionUID = -4296469329232291213L;
    private static final boolean DO_NOT_USE_THE_CONTENT_REPOSITORY = true;

    protected String getMimeType() {
        return "text/html";
    }

    protected String getExtension() {
        return ".html";
    }

    protected boolean performExport(MasterReport report, OutputStream outputStream) {
        try {
            PentahoURLRewriter rewriter;
            DefaultNameGenerator dataNameGenerator;
            ContentLocation dataLocation;
            IContentRepository contentRepository = null;
            try {
                contentRepository = (IContentRepository)PentahoSystem.get(IContentRepository.class, (IPentahoSession)this.getSession());
            }
            catch (Throwable t) {
                this.debug(Messages.getString("JFreeReportHtmlComponent.DEBUG_0044_PROCESSING_WITHOUT_CONTENT_REPOS"), t);
            }
            String contentHandlerPattern = this.getInputStringValue("content-handler");
            if (contentHandlerPattern == null) {
                Configuration globalConfig = ClassicEngineBoot.getInstance().getGlobalConfig();
                contentHandlerPattern = globalConfig.getConfigProperty("org.pentaho.web.ContentHandler");
            }
            IApplicationContext ctx = PentahoSystem.getApplicationContext();
            if (contentRepository != null) {
                // empty if block
            }
            this.debug(Messages.getString("JFreeReportHtmlComponent.DEBUG_0044_PROCESSING_WITHOUT_CONTENT_REPOS"));
            if (ctx != null) {
                File dataDirectory = new File(ctx.getFileOutputPath("system/tmp/"));
                if (dataDirectory.exists() && !dataDirectory.isDirectory()) {
                    if (!(dataDirectory = dataDirectory.getParentFile()).isDirectory()) {
                        throw new ReportProcessingException(Messages.getErrorString("JFreeReportDirectoryComponent.ERROR_0001_INVALID_DIR", dataDirectory.getPath()));
                    }
                } else if (!dataDirectory.exists()) {
                    dataDirectory.mkdirs();
                }
                FileRepository dataRepository = new FileRepository(dataDirectory);
                dataLocation = dataRepository.getRoot();
                dataNameGenerator = new DefaultNameGenerator(dataLocation);
                rewriter = new PentahoURLRewriter(contentHandlerPattern);
            } else {
                dataLocation = null;
                dataNameGenerator = null;
                rewriter = new PentahoURLRewriter(contentHandlerPattern);
            }
            StreamRepository targetRepository = new StreamRepository(null, outputStream);
            ContentLocation targetRoot = targetRepository.getRoot();
            StreamHtmlOutputProcessor outputProcessor = new StreamHtmlOutputProcessor(report.getConfiguration());
            AllItemsHtmlPrinter printer = new AllItemsHtmlPrinter(report.getResourceManager());
            printer.setContentWriter(targetRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, "index", "html"));
            printer.setDataWriter(dataLocation, (NameGenerator)dataNameGenerator);
            printer.setUrlRewriter((URLRewriter)rewriter);
            outputProcessor.setPrinter((HtmlPrinter)printer);
            StreamReportProcessor sp = new StreamReportProcessor(report, (OutputProcessor)outputProcessor);
            int yieldRate = this.getYieldRate();
            if (yieldRate > 0) {
                sp.addReportProgressListener((ReportProgressListener)new YieldReportListener(yieldRate));
            }
            sp.processReport();
            sp.close();
            outputStream.flush();
            this.close();
            return true;
        }
        catch (ReportProcessingException e) {
            this.error(Messages.getString("JFreeReportHtmlComponent.ERROR_0046_FAILED_TO_PROCESS_REPORT"), e);
            return false;
        }
        catch (IOException e) {
            this.error(Messages.getString("JFreeReportHtmlComponent.ERROR_0046_FAILED_TO_PROCESS_REPORT"), e);
            return false;
        }
        catch (ContentIOException e) {
            this.error(Messages.getString("JFreeReportHtmlComponent.ERROR_0046_FAILED_TO_PROCESS_REPORT"), e);
            return false;
        }
    }
}

