/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport.outputs;

import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.platform.plugin.action.jfreereport.outputs.AbstractGenerateStreamContentComponent;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.YieldReportListener;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.FlowReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.AllItemsHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.FlowHtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.SingleRepositoryURLRewriter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriter;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.zip.ZipRepository;

public class JFreeReportZipHtmlComponent
extends AbstractGenerateStreamContentComponent {
    private static final long serialVersionUID = -3904516365257691828L;

    protected String getMimeType() {
        return "application/zip";
    }

    protected String getExtension() {
        return ".zip";
    }

    protected boolean performExport(MasterReport report, OutputStream outputStream) {
        try {
            String dataDirectory = this.getInputStringValue("data-directory");
            if (dataDirectory == null) {
                dataDirectory = "data";
            }
            ZipRepository zipRepository = new ZipRepository();
            ContentLocation root = zipRepository.getRoot();
            ContentLocation data = RepositoryUtilities.createLocation((Repository)zipRepository, (String[])RepositoryUtilities.split((String)dataDirectory, (String)"/"));
            FlowHtmlOutputProcessor outputProcessor = new FlowHtmlOutputProcessor(report.getConfiguration());
            AllItemsHtmlPrinter printer = new AllItemsHtmlPrinter(report.getResourceManager());
            printer.setContentWriter(root, (NameGenerator)new DefaultNameGenerator(root, "report.html"));
            printer.setDataWriter(data, (NameGenerator)new DefaultNameGenerator(data, "content"));
            printer.setUrlRewriter((URLRewriter)new SingleRepositoryURLRewriter());
            outputProcessor.setPrinter((HtmlPrinter)printer);
            FlowReportProcessor sp = new FlowReportProcessor(report, (OutputProcessor)outputProcessor);
            int yieldRate = this.getYieldRate();
            if (yieldRate > 0) {
                sp.addReportProgressListener((ReportProgressListener)new YieldReportListener(yieldRate));
            }
            sp.processReport();
            zipRepository.write(outputStream);
            this.close();
            return true;
        }
        catch (ReportProcessingException e) {
            this.error(Messages.getString("JFreeReportZipHtmlComponent.ERROR_0046_FAILED_TO_PROCESS_REPORT"), e);
            return false;
        }
        catch (IOException e) {
            this.error(Messages.getString("JFreeReportZipHtmlComponent.ERROR_0046_FAILED_TO_PROCESS_REPORT"), e);
            return false;
        }
        catch (ContentIOException e) {
            this.error(Messages.getString("JFreeReportZipHtmlComponent.ERROR_0046_FAILED_TO_PROCESS_REPORT"), e);
            return false;
        }
    }
}

