/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.plugin.action.jfreereport.repository.ReportContentLocation;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;

public class ReportContentItem
implements ContentItem {
    private IContentItem backend;
    private ReportContentLocation parent;

    public ReportContentItem(IContentItem backend, ReportContentLocation parent) {
        this.backend = backend;
        this.parent = parent;
    }

    public String getMimeType() throws ContentIOException {
        return this.backend.getMimeType();
    }

    public OutputStream getOutputStream() throws ContentIOException, IOException {
        return this.backend.getOutputStream(this.parent.getActionName());
    }

    public InputStream getInputStream() throws ContentIOException, IOException {
        return this.backend.getInputStream();
    }

    public boolean isReadable() {
        return false;
    }

    public boolean isWriteable() {
        return true;
    }

    public String getName() {
        return this.backend.getName();
    }

    public Object getContentId() {
        return this.backend.getId();
    }

    public Object getAttribute(String domain, String key) {
        if ("org.jfree.repository".equals(domain)) {
            if ("size".equals(key)) {
                return new Long(this.backend.getFileSize());
            }
            if ("version".equals(key)) {
                return this.backend.getFileDateTime();
            }
        }
        return null;
    }

    public boolean setAttribute(String domain, String key, Object object) {
        return false;
    }

    public ContentLocation getParent() {
        return this.parent;
    }

    public Repository getRepository() {
        return this.parent.getRepository();
    }

    public boolean delete() {
        this.backend.removeVersion(this.backend.getId());
        return true;
    }
}

