/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport.repository;

import java.util.ArrayList;
import java.util.Iterator;
import org.jfree.io.IOUtils;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository.IContentLocation;
import org.pentaho.platform.plugin.action.jfreereport.repository.ReportContentItem;
import org.pentaho.platform.plugin.action.jfreereport.repository.ReportContentRepository;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;
import org.pentaho.reporting.libraries.repository.ContentCreationException;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.dummy.DummyContentItem;

public class ReportContentLocation
implements ContentLocation {
    private IContentLocation location;
    private ReportContentRepository repository;
    private String actionName;

    public ReportContentLocation(IContentLocation location, ReportContentRepository repository, String actionName) {
        this.location = location;
        this.repository = repository;
        this.actionName = actionName;
    }

    public ContentEntity[] listContents() throws ContentIOException {
        ArrayList<ReportContentItem> itemCollection = new ArrayList<ReportContentItem>();
        Iterator iterator = this.location.getContentItemIterator();
        while (iterator.hasNext()) {
            IContentItem item = (IContentItem)iterator.next();
            itemCollection.add(new ReportContentItem(item, this));
        }
        return itemCollection.toArray(new ContentEntity[itemCollection.size()]);
    }

    public ContentEntity getEntry(String string) throws ContentIOException {
        IContentItem rawItem = this.location.getContentItemByName(string);
        if (rawItem == null) {
            throw new ContentIOException(Messages.getErrorString("ReportContentLocation.ERROR_0001_NO_ITEM", string));
        }
        return new ReportContentItem(rawItem, this);
    }

    public ContentItem createItem(String name) throws ContentCreationException {
        String extension = IOUtils.getInstance().getFileExtension(name);
        String mimeType = this.repository.getMimeRegistry().getMimeType((ContentItem)new DummyContentItem((ContentLocation)this, name));
        IContentItem iContentItem = this.location.newContentItem(name, Messages.getString("ReportContentLocation.GENERATED_REPORT_CONTENT"), extension, mimeType, null, 1);
        return new ReportContentItem(iContentItem, this);
    }

    public ContentLocation createLocation(String string) throws ContentCreationException {
        throw new ContentCreationException(Messages.getErrorString("ReportContentLocation.ERROR_0002_CANT_CREATE_CONTENT_LOCATION", string));
    }

    public boolean exists(String string) {
        return this.location.getContentItemByName(string) != null;
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getName() {
        return this.location.getName();
    }

    public Object getContentId() {
        return this.location.getId();
    }

    public Object getAttribute(String domain, String key) {
        if ("org.jfree.repository".equals(domain) && "version".equals(key)) {
            return IntegerCache.getInteger((int)this.location.getRevision());
        }
        return null;
    }

    public boolean setAttribute(String domain, String key, Object object) {
        return false;
    }

    public ContentLocation getParent() {
        return null;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public boolean delete() {
        return false;
    }
}

