/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.kettle;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.selectvalues.SelectValuesMeta;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;
import org.pentaho.di.trans.steps.tableoutput.TableOutputMeta;
import org.pentaho.platform.plugin.action.kettle.KettleComponent;

public class Custom1
extends KettleComponent {
    private static final long serialVersionUID = -3534575935705861245L;

    protected boolean customizeTrans(Trans trans, LogWriter logWriter) {
        return true;
    }

    private void execSQL(TransMeta transMeta, String targetDatabaseName) throws KettleStepException, KettleDatabaseException {
        String sql = transMeta.getSQLStatementsString();
        Database targetDatabase = new Database(transMeta.findDatabase(targetDatabaseName));
        targetDatabase.connect();
        targetDatabase.execStatements(sql);
    }

    public static final TransMeta buildCopyTable(String transformationName, String sourceDatabaseName, String sourceTableName, String[] sourceFields, String targetDatabaseName, String targetTableName, String[] targetFields, LogWriter logWriter) throws KettleException {
        try {
            TransMeta transMeta = new TransMeta();
            transMeta.setName(transformationName);
            DatabaseMeta sourceDBInfo = transMeta.findDatabase(sourceDatabaseName);
            DatabaseMeta targetDBInfo = transMeta.findDatabase(targetDatabaseName);
            String fromstepname = "read from [" + sourceTableName + "]";
            TableInputMeta tii = new TableInputMeta();
            tii.setDatabaseMeta(sourceDBInfo);
            String selectSQL = "SELECT " + Const.CR;
            for (int i = 0; i < sourceFields.length; ++i) {
                selectSQL = i > 0 ? selectSQL + ", " : selectSQL + " ";
                selectSQL = selectSQL + sourceFields[i] + Const.CR;
            }
            selectSQL = selectSQL + "FROM " + sourceTableName;
            tii.setSQL(selectSQL);
            PluginRegistry registry = PluginRegistry.getInstance();
            String fromstepid = registry.getPluginId((Object)tii);
            StepMeta fromstep = new StepMeta(fromstepid, fromstepname, (StepMetaInterface)tii);
            fromstep.setLocation(150, 100);
            fromstep.setDraw(true);
            fromstep.setDescription("Reads information from table [" + sourceTableName + "] on database [" + sourceDBInfo + "]");
            transMeta.addStep(fromstep);
            SelectValuesMeta svi = new SelectValuesMeta();
            svi.allocate(0, 0, sourceFields.length);
            for (int i = 0; i < sourceFields.length; ++i) {
                svi.getMeta()[i].setName(sourceFields[i]);
                svi.getMeta()[i].setRename(sourceFields[i]);
            }
            String selstepname = "Rename field names";
            String selstepid = registry.getPluginId((Object)svi);
            StepMeta selstep = new StepMeta(selstepid, selstepname, (StepMetaInterface)svi);
            selstep.setLocation(350, 100);
            selstep.setDraw(true);
            selstep.setDescription("Rename field names");
            transMeta.addStep(selstep);
            TransHopMeta shi = new TransHopMeta(fromstep, selstep);
            transMeta.addTransHop(shi);
            fromstep = selstep;
            String tostepname = "write to [" + targetTableName + "]";
            TableOutputMeta toi = new TableOutputMeta();
            toi.setDatabaseMeta(targetDBInfo);
            toi.setTablename(targetTableName);
            toi.setCommitSize(200);
            toi.setTruncateTable(true);
            String tostepid = registry.getPluginId((Object)toi);
            StepMeta tostep = new StepMeta(tostepid, tostepname, (StepMetaInterface)toi);
            tostep.setLocation(550, 100);
            tostep.setDraw(true);
            tostep.setDescription("Write information to table [" + targetTableName + "] on database [" + targetDBInfo + "]");
            transMeta.addStep(tostep);
            TransHopMeta hi = new TransHopMeta(fromstep, tostep);
            transMeta.addTransHop(hi);
            return transMeta;
        }
        catch (Exception e) {
            throw new KettleException("An unexpected error occurred creating the new transformation", (Throwable)e);
        }
    }
}

