/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.kettle;

import javax.sql.DataSource;
import org.pentaho.di.core.database.DataSourceNamingException;
import org.pentaho.di.core.database.DataSourceProviderFactory;
import org.pentaho.di.core.database.DataSourceProviderInterface;
import org.pentaho.platform.api.data.DatasourceServiceException;
import org.pentaho.platform.api.data.IDatasourceService;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class PlatformKettleDataSourceProvider
implements DataSourceProviderInterface {
    protected static final PlatformKettleDataSourceProvider instance = new PlatformKettleDataSourceProvider();

    private PlatformKettleDataSourceProvider() {
    }

    public DataSourceProviderInterface getInstance() {
        return instance;
    }

    protected static void hookupProvider() {
        DataSourceProviderFactory.setDataSourceProviderInterface((DataSourceProviderInterface)instance);
    }

    public DataSource getNamedDataSource(String dataSourceName) throws DataSourceNamingException {
        IDatasourceService datasourceService = (IDatasourceService)PentahoSystem.get(IDatasourceService.class, null);
        if (datasourceService != null) {
            try {
                return datasourceService.getDataSource(dataSourceName);
            }
            catch (DatasourceServiceException ex) {
                throw new DataSourceNamingException((Throwable)ex);
            }
        }
        return null;
    }
}

