/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.mdx;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.actions.MdxConnectionAction;
import org.pentaho.actionsequence.dom.actions.MdxQueryAction;
import org.pentaho.commons.connection.IPentahoConnection;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.data.IDataComponent;
import org.pentaho.platform.api.data.IDatasourceService;
import org.pentaho.platform.api.data.IPreparedComponent;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IParameterResolver;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.PentahoConnectionFactory;
import org.pentaho.platform.engine.services.runtime.MapParameterResolver;
import org.pentaho.platform.engine.services.runtime.TemplateUtil;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalogHelper;
import org.pentaho.platform.plugin.services.connections.mondrian.MDXConnection;

public abstract class MDXBaseComponent
extends ComponentBase
implements IDataComponent,
IPreparedComponent {
    private static final long serialVersionUID = 495868243986115468L;
    private IPentahoResultSet rSet;
    private boolean connectionOwner = true;
    private IPentahoConnection connection;
    String preparedQuery = null;

    public abstract boolean validateSystemSettings();

    public abstract Log getLogger();

    public IPentahoResultSet getResultSet() {
        return this.rSet;
    }

    protected boolean validateAction() {
        boolean actionValidated = true;
        MdxQueryAction queryAction = null;
        MdxConnectionAction connAction = null;
        try {
            if (this.getActionDefinition() instanceof MdxQueryAction) {
                queryAction = (MdxQueryAction)this.getActionDefinition();
                actionValidated = this.isConnectionInfoSpecified((MdxConnectionAction)queryAction);
                if (actionValidated && queryAction.getQuery() == ActionInputConstant.NULL_INPUT) {
                    this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0001_QUERY_NOT_SPECIFIED", this.getActionName()));
                    actionValidated = false;
                }
                if (actionValidated && queryAction.getOutputResultSet() == null && queryAction.getOutputPreparedStatement() == null) {
                    this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0003_OUTPUT_NOT_SPECIFIED", this.getActionName()));
                    actionValidated = false;
                }
            } else if (this.getActionDefinition() instanceof MdxConnectionAction) {
                connAction = (MdxConnectionAction)this.getActionDefinition();
                actionValidated = this.isConnectionInfoSpecified(connAction);
                if (connAction.getOutputConnection() == null) {
                    this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0003_OUTPUT_NOT_SPECIFIED", this.getActionName()));
                    actionValidated = false;
                }
            }
        }
        catch (Exception e) {
            actionValidated = false;
            this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0004_VALIDATION_FAILED", this.getActionName()), e);
        }
        return actionValidated;
    }

    private boolean isConnectionInfoSpecified(MdxConnectionAction connAction) {
        boolean value = true;
        if (connAction instanceof MdxQueryAction) {
            if (connAction.getConnection() == ActionInputConstant.NULL_INPUT && connAction.getMdxConnectionString() == null && connAction.getJndi() == ActionInputConstant.NULL_INPUT && connAction.getConnectionProps() == ActionInputConstant.NULL_INPUT && ((MdxQueryAction)connAction).getMdxConnection() == ActionInputConstant.NULL_INPUT) {
                this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0002_CONNECTION_NOT_SPECIFIED", this.getActionName()));
                value = false;
            }
        } else if (connAction instanceof MdxConnectionAction && connAction.getConnection() == ActionInputConstant.NULL_INPUT && connAction.getMdxConnectionString() == null && connAction.getJndi() == ActionInputConstant.NULL_INPUT && connAction.getConnectionProps() == ActionInputConstant.NULL_INPUT) {
            this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0002_CONNECTION_NOT_SPECIFIED", this.getActionName()));
            value = false;
        }
        return value;
    }

    public void done() {
    }

    protected boolean executeAction() {
        boolean value = false;
        try {
            if (this.getActionDefinition() instanceof MdxQueryAction) {
                MdxQueryAction queryAction = (MdxQueryAction)this.getActionDefinition();
                if (queryAction.getMdxConnection() != ActionInputConstant.NULL_INPUT) {
                    if (queryAction.getMdxConnection().getValue() != null) {
                        this.connectionOwner = false;
                        IPreparedComponent component = (IPreparedComponent)queryAction.getMdxConnection().getValue();
                        IPentahoConnection conn = component.shareConnection();
                        if (conn.getDatasourceType() == "MDX") {
                            this.connection = conn;
                        } else {
                            this.error(Messages.getErrorString("IPreparedComponent.ERROR_0001_INVALID_CONNECTION_TYPE", this.getActionName()));
                        }
                    } else {
                        this.error(Messages.getErrorString("IPreparedComponent.ERROR_0002_CONNECTION_NOT_AVAILABLE", this.getActionName()));
                    }
                } else {
                    this.dispose();
                    this.connection = this.getDatasourceConnection();
                }
                if (this.connection != null) {
                    String query = queryAction.getQuery().getStringValue();
                    if (queryAction.getOutputPreparedStatement() != null) {
                        this.prepareQuery(query);
                        this.setOutputValue("prepared_component", (Object)this);
                        value = true;
                    } else {
                        value = this.runQuery(this.connection, query);
                    }
                } else {
                    this.error(Messages.getErrorString("IPreparedComponent.ERROR_0004_NO_CONNECTION_INFO", this.getActionName()));
                }
            } else if (this.getActionDefinition() instanceof MdxConnectionAction) {
                this.dispose();
                this.connection = this.getDatasourceConnection();
                if (this.connection != null) {
                    this.setOutputValue("prepared_component", (Object)this);
                    value = true;
                }
            } else {
                this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0004_VALIDATION_FAILED", this.getActionName()));
            }
        }
        catch (Exception e) {
            this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0006_EXECUTE_FAILED", this.getActionName()), e);
        }
        return value;
    }

    protected boolean prepareQuery(String rawQuery) {
        try {
            if (this.connection == null) {
                this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0008_NO_CONNECTION"));
                return false;
            }
            if (!this.connection.initialized()) {
                this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0008_NO_CONNECTION"));
                return false;
            }
            if (rawQuery != null) {
                this.preparedQuery = this.applyInputsToFormat(rawQuery);
            }
            return true;
        }
        catch (Exception e) {
            this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0006_EXECUTE_FAILED", this.getActionName()), e);
            return false;
        }
    }

    public void dispose() {
        if (this.connectionOwner && this.connection != null) {
            this.connection.close();
        }
        this.connection = null;
    }

    public IPentahoConnection shareConnection() {
        return this.connection;
    }

    public IPentahoResultSet executePrepared(Map preparedParams) {
        try {
            IPentahoResultSet resultSet;
            if (this.connection == null) {
                this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0008_NO_CONNECTION"));
                return null;
            }
            if (!this.connection.initialized()) {
                this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0008_NO_CONNECTION"));
                return null;
            }
            if (this.preparedQuery == null) {
                this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0001_QUERY_NOT_SPECIFIED", this.getActionName()));
                return null;
            }
            String query = TemplateUtil.applyTemplate((String)this.preparedQuery, (IRuntimeContext)this.getRuntimeContext(), (IParameterResolver)new MapParameterResolver(preparedParams, "PREPARELATER", this.getRuntimeContext()));
            this.debug(Messages.getString("MDXBaseComponent.DEBUG_RUNNING_QUERY", query));
            this.rSet = resultSet = this.connection.executeQuery(query);
            return resultSet;
        }
        catch (Exception e) {
            this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0006_EXECUTE_FAILED", this.getActionName()), e);
            return null;
        }
    }

    protected boolean runQuery(IPentahoConnection localConnection, String rawQuery) {
        try {
            IPentahoResultSet resultSet;
            if (localConnection == null) {
                this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0008_NO_CONNECTION"));
                return false;
            }
            if (!localConnection.initialized()) {
                this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0008_NO_CONNECTION"));
                return false;
            }
            if (rawQuery == null) {
                this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0001_QUERY_NOT_SPECIFIED", this.getActionName()));
                return false;
            }
            this.debug(Messages.getString("MDXBaseComponent.DEBUG_RUNNING_QUERY", rawQuery));
            this.rSet = resultSet = localConnection.executeQuery(rawQuery);
            if (resultSet != null) {
                MdxQueryAction mdxQueryAction = (MdxQueryAction)this.getActionDefinition();
                IActionOutput actionOutput = mdxQueryAction.getOutputResultSet();
                if (actionOutput != null) {
                    actionOutput.setValue((Object)resultSet);
                }
                return true;
            }
            this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0006_EXECUTE_FAILED", this.getActionName()));
            localConnection.close();
            return false;
        }
        catch (Exception e) {
            this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0006_EXECUTE_FAILED", this.getActionName()), e);
            return false;
        }
    }

    public IPentahoConnection getDatasourceConnection() {
        int[] timeouts;
        for (int element : timeouts = new int[]{200, 500, 2000}) {
            try {
                IPentahoConnection con = this.getConnection();
                try {
                    con.clearWarnings();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return con;
            }
            catch (Exception ex) {
                this.waitFor(element);
            }
        }
        IPentahoConnection con = this.getConnection();
        try {
            con.clearWarnings();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return con;
    }

    protected void waitFor(int millis) {
        try {
            this.debug(Messages.getString("MDXBaseComponent.DEBUG_WAITING_FOR_CONNECTION", Integer.toString(millis)));
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected IPentahoConnection getConnection() {
        IPentahoConnection localConnection = null;
        MdxConnectionAction connAction = (MdxConnectionAction)this.getActionDefinition();
        try {
            String mdxConnectionStr = connAction.getMdxConnectionString().getStringValue();
            Properties mdxConnectionProps = (Properties)connAction.getConnectionProps().getValue();
            String jdbcStr = connAction.getConnection().getStringValue();
            String jndiStr = connAction.getJndi().getStringValue();
            String location = connAction.getLocation().getStringValue();
            String role = connAction.getRole().getStringValue();
            String catalog = connAction.getCatalog().getStringValue();
            if (catalog == null && connAction.getCatalogResource() != null) {
                File file;
                IActionSequenceResource resource = this.getResource(connAction.getCatalogResource().getName());
                catalog = resource.getAddress();
                if (resource.getSourceType() == 1) {
                    catalog = PentahoSystem.getApplicationContext().getSolutionPath(catalog);
                }
                if (resource.getSourceType() == 2 && catalog.indexOf("solution:") != 0) {
                    if (!catalog.startsWith("http:")) {
                        catalog = "solution:" + catalog;
                    }
                } else if ((resource.getSourceType() == 1 || resource.getSourceType() == 3) && (file = new File(catalog)).exists()) {
                    catalog = file.toURI().toString();
                }
            }
            if (catalog == null) {
                this.warn(Messages.getString("MDXBaseComponent.ERROR_0007_CATALOG_NOT_DEFINED", this.getActionName()));
            } else if (mdxConnectionProps != null) {
                mdxConnectionProps.put("catalog", catalog);
            }
            String userId = connAction.getUserId().getStringValue();
            String password = connAction.getPassword().getStringValue();
            if (mdxConnectionProps != null) {
                localConnection = PentahoConnectionFactory.getConnection((String)"MDX", (Properties)mdxConnectionProps, (IPentahoSession)this.getSession(), (ILogger)this);
            } else {
                if (mdxConnectionStr != null) {
                    localConnection = PentahoConnectionFactory.getConnection((String)"MDX", (String)mdxConnectionStr, (IPentahoSession)this.getSession(), (ILogger)this);
                } else {
                    String connectStr = null;
                    if (jdbcStr != null) {
                        connectStr = jdbcStr + "; Catalog=" + catalog;
                    } else if (jndiStr != null) {
                        IDatasourceService datasourceService = (IDatasourceService)PentahoSystem.getObjectFactory().get(IDatasourceService.class, null);
                        if (datasourceService.getDataSource(jndiStr) == null) {
                            this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0005_INVALID_CONNECTION"));
                            return null;
                        }
                        connectStr = "dataSource=" + jndiStr + "; Catalog=" + catalog;
                        MondrianCatalog mc = MondrianCatalogHelper.getInstance().getCatalog(catalog, this.getSession());
                        try {
                            connectStr = connectStr + ";" + mc.getDataSourceInfo();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (role != null) {
                        connectStr = connectStr + "; Role=" + role;
                    }
                    Properties props = new Properties();
                    props.setProperty("connection", connectStr);
                    props.setProperty("provider", location);
                    if (userId != null) {
                        props.setProperty("userName", userId);
                    }
                    if (password != null) {
                        props.setProperty("password", password);
                    }
                    localConnection = PentahoConnectionFactory.getConnection((String)"MDX", (Properties)props, (IPentahoSession)this.getSession(), (ILogger)this);
                }
                if (localConnection == null) {
                    this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0005_INVALID_CONNECTION"));
                    return null;
                }
            }
            if (localConnection instanceof MDXConnection) {
                MDXConnection mdxConn = (MDXConnection)localConnection;
                if (connAction != null && connAction.getExtendedColumnNames() != ActionInputConstant.NULL_INPUT) {
                    mdxConn.setUseExtendedColumnNames(connAction.getExtendedColumnNames().getBooleanValue().booleanValue());
                }
            }
            return localConnection;
        }
        catch (Exception e) {
            this.error(Messages.getErrorString("MDXBaseComponent.ERROR_0006_EXECUTE_FAILED", this.getActionName()), e);
            return null;
        }
    }

    public boolean init() {
        return true;
    }
}

