/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.mondrian;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.PentahoMessenger;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.action.mondrian.InvalidDocumentException;
import org.pentaho.platform.plugin.action.mondrian.MissingParameterException;

public class AnalysisSaver
extends PentahoMessenger {
    private static final long serialVersionUID = 6290291421129174060L;
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_STRING = "string";
    private static final String TITLE_NODE_NAME = "title";
    public static final String SUFFIX = ".xaction";
    public static final String PROPERTIES_SUFFIX = ".properties";
    private static Log logger = null;

    public Log getLogger() {
        return logger;
    }

    public static int saveAnalysis(IPentahoSession session, HashMap props, String path, String fileName, boolean overwrite) {
        if ("true".equals(PentahoSystem.getSystemSetting((String)"kiosk-mode", (String)"false"))) {
            throw new RuntimeException(Messages.getErrorString("ANALYSISSAVER.ERROR_0006_SAVE_IS_DISABLED"));
        }
        int result = 0;
        try {
            logger = LogFactory.getLog(AnalysisSaver.class);
            String baseUrl = PentahoSystem.getApplicationContext().getSolutionPath("");
            ISolutionRepository solutionRepository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)session);
            String originalActionReference = (String)props.get("actionreference");
            if (originalActionReference == null) {
                throw new MissingParameterException(Messages.getErrorString("ANALYSISSAVER.ERROR_0001_MISSING_ACTION_REFERENCE"));
            }
            Document document = solutionRepository.getResourceAsDocument(originalActionReference, 8);
            document = AnalysisSaver.updateDocument(document, props);
            fileName = fileName.endsWith(SUFFIX) ? fileName : fileName + SUFFIX;
            result = solutionRepository.publish(baseUrl, path, fileName, document.asXML().getBytes(document.getXMLEncoding()), overwrite);
            ActionInfo actionInfo = ActionInfo.parseActionString((String)originalActionReference);
            String originalPath = actionInfo.getSolutionName() + "/" + actionInfo.getPath();
            String originalFileName = actionInfo.getActionName();
            originalFileName = originalFileName.substring(0, originalFileName.lastIndexOf(SUFFIX));
            ISolutionFile[] parentFiles = solutionRepository.getSolutionFile(originalPath, 1).listFiles();
            String baseFileName = fileName.substring(0, fileName.lastIndexOf(SUFFIX));
            for (ISolutionFile aSolutionFile : parentFiles) {
                if (aSolutionFile.isDirectory() || !aSolutionFile.getFileName().startsWith(originalFileName) || !aSolutionFile.getFileName().toLowerCase().endsWith(PROPERTIES_SUFFIX)) continue;
                String newFileName = aSolutionFile.getFileName().replaceFirst(originalFileName, baseFileName);
                result &= solutionRepository.publish(baseUrl, path, newFileName, aSolutionFile.getData(), overwrite);
            }
            solutionRepository.resetRepository();
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("ANALYSISSAVER.ERROR_0000_UNKNOWN"), (Throwable)e);
            result = 2;
        }
        return result;
    }

    private static Document updateDocument(Document document, HashMap props) {
        try {
            Element componentDefinition = null;
            Element actionOutput = null;
            Element actionSequenceOutput = null;
            Node actionSequence = document.selectSingleNode("/action-sequence");
            if (actionSequence == null) {
                throw new InvalidDocumentException(Messages.getErrorString("ANALYSISSAVER.ERROR_0004_INVALID_ORIGIN_DOCUMENT"));
            }
            Element asElement = (Element)actionSequence;
            Node title = null;
            String propertyTitle = (String)props.get(TITLE_NODE_NAME);
            title = asElement.selectSingleNode(TITLE_NODE_NAME);
            if (title == null && propertyTitle != null) {
                title = asElement.addElement(TITLE_NODE_NAME);
            }
            if (title != null && propertyTitle != null) {
                title.setText("");
                ((Element)title).addCDATA(propertyTitle);
            }
            if ((componentDefinition = (Element)document.selectSingleNode("//action-definition[component-name='PivotViewComponent']/component-definition")) == null) {
                throw new InvalidDocumentException(Messages.getErrorString("ANALYSISSAVER.ERROR_0005_INVALID_NO_PIVOT_ACTION"));
            }
            AnalysisSaver.updateComponent(componentDefinition, props);
            actionOutput = (Element)document.selectSingleNode("//action-definition[component-name='PivotViewComponent']/action-outputs");
            AnalysisSaver.updateOutput(actionOutput, props);
            actionSequenceOutput = (Element)document.selectSingleNode("//action-sequence/outputs");
            AnalysisSaver.updateOutput(actionSequenceOutput, props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    private static void updateComponent(Element componentDefinition, HashMap props) {
        for (Object key : props.keySet()) {
            Node node = componentDefinition.selectSingleNode(key.toString());
            if (node == null) {
                node = componentDefinition.addElement(key.toString());
            }
            if ("options".equals(node.getName())) {
                List optionsList = (List)props.get(key);
                Iterator optsIter = optionsList.iterator();
                while (optsIter.hasNext()) {
                    String anOption = optsIter.next().toString();
                    Node anOptionNode = node.selectSingleNode(anOption);
                    if (anOptionNode != null) continue;
                    ((Element)node).addElement(anOption);
                }
                continue;
            }
            Object value = props.get(key);
            if (value == null) continue;
            node.setText("");
            ((Element)node).addCDATA(value.toString());
        }
    }

    private static void updateOutput(Element outputNode, HashMap props) {
        for (Object key : props.keySet()) {
            Node node = outputNode.selectSingleNode(key.toString());
            if (node != null) continue;
            outputNode.addElement(key.toString()).addAttribute(ATTRIBUTE_TYPE, "options".equals(key.toString()) ? "list" : ATTRIBUTE_STRING);
        }
    }
}

