/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.mondrian;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import mondrian.olap.MondrianProperties;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.util.logging.Logger;

public class MondrianSystemListener
implements IPentahoSystemListener {
    public boolean startup(IPentahoSession session) {
        try {
            System.setProperty("pentaho.olap.xmladatasources", "system/olap/datasources.xml");
        }
        catch (Exception ex) {
            Logger.error((String)MondrianSystemListener.class.getName(), (String)Messages.getErrorString("MondrianSystemListener.ERROR_0001_PROPERTY_SET_FAILED"), (Throwable)ex);
        }
        this.loadMondrianProperties(session);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMondrianProperties(IPentahoSession session) {
        String mondrianPropsFilename = "system" + File.separator + "mondrian" + File.separator + "mondrian.properties";
        InputStream is = null;
        try {
            ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)session);
            if (repository.resourceExists(mondrianPropsFilename, 1)) {
                is = repository.getResourceInputStream(mondrianPropsFilename, false, 1);
                MondrianProperties.instance().load(is);
                Logger.debug((String)MondrianSystemListener.class.getName(), (String)Messages.getString("MondrianSystemListener.PROPERTY_FILE_LOADED", mondrianPropsFilename));
            } else {
                Logger.warn((String)MondrianSystemListener.class.getName(), (String)Messages.getString("MondrianSystemListener.PROPERTY_FILE_NOT_FOUND", mondrianPropsFilename));
            }
        }
        catch (IOException ioe) {
            Logger.error((String)MondrianSystemListener.class.getName(), (String)Messages.getString("MondrianSystemListener.ERROR_0002_PROPERTY_FILE_READ_FAILED", ioe.getMessage()), (Throwable)ioe);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public void shutdown() {
    }
}

