/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.mondrian.catalog;

import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalogComplementInfo;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianDataSource;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianSchema;

public class MondrianCatalog
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String dataSourceInfo;
    private String definition;
    private MondrianDataSource dataSource;
    private MondrianSchema schema;
    private MondrianCatalogComplementInfo mondrianCatalogComplementInfo;
    private String whereCondition;

    public MondrianCatalog(String name, String dataSourceInfo, String definition, MondrianDataSource dataSource, MondrianSchema schema) {
        this(name, dataSourceInfo, definition, dataSource, schema, new MondrianCatalogComplementInfo());
    }

    public MondrianCatalog(String name, String dataSourceInfo, String definition, MondrianDataSource dataSource, MondrianSchema schema, MondrianCatalogComplementInfo mondrianCatalogComplementInfo) {
        this.name = name;
        this.dataSourceInfo = dataSourceInfo;
        this.definition = definition;
        this.dataSource = dataSource;
        this.schema = schema;
        this.mondrianCatalogComplementInfo = mondrianCatalogComplementInfo;
    }

    public String getName() {
        return this.name;
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getDataSourceInfo() {
        return this.dataSourceInfo;
    }

    public MondrianSchema getSchema() {
        return this.schema;
    }

    public MondrianCatalogComplementInfo getMondrianCatalogComplementInfo() {
        return this.mondrianCatalogComplementInfo;
    }

    public MondrianDataSource getEffectiveDataSource() {
        if (null != this.dataSourceInfo) {
            return new MondrianDataSource(this.dataSource, this.dataSourceInfo);
        }
        return this.dataSource;
    }

    public MondrianDataSource getDataSource() {
        return this.dataSource;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("dataSourceInfo", (Object)this.dataSourceInfo).append("definition", (Object)this.definition).append("dataSource", (Object)this.dataSource).append("schema", (Object)this.schema).toString();
    }
}

