/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.mondrian.catalog;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import mondrian.i18n.LocalizingDynamicSchemaProcessor;
import mondrian.olap.MondrianDef;
import mondrian.olap.Util;
import mondrian.rolap.agg.AggregationManager;
import mondrian.util.Pair;
import mondrian.xmla.DataSourcesConfig;
import org.apache.commons.collections.list.SetUniqueList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XMLOutput;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;
import org.pentaho.platform.api.data.DatasourceServiceException;
import org.pentaho.platform.api.data.IDatasourceService;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPermissionMask;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.PentahoEntityResolver;
import org.pentaho.platform.engine.services.solution.SolutionReposHelper;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalogComplementInfo;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalogServiceException;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCube;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianDataSource;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianSchema;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MondrianCatalogHelper
implements IMondrianCatalogService {
    private static final Log logger = LogFactory.getLog(MondrianCatalogHelper.class);
    private String dataSourcesConfig = "file:" + PentahoSystem.getApplicationContext().getSolutionPath("system/olap/datasources.xml");
    private boolean useSchemaNameAsCatalogName = true;
    private Map<String, MondrianCatalogComplementInfo> catalogComplementInfoMap;
    public static String MONDRIAN_CATALOG_CACHE_REGION = "mondrian-catalog-cache";

    private List<MondrianCatalog> getCatalogs(IPentahoSession pentahoSession) {
        Map catalogsMap = (Map)PentahoSystem.getCacheManager((IPentahoSession)pentahoSession).getFromRegionCache(MONDRIAN_CATALOG_CACHE_REGION, (Object)MondrianCatalogHelper.getLocale().toString());
        ArrayList<MondrianCatalog> catalogs = new ArrayList<MondrianCatalog>();
        for (MondrianCatalog o : catalogsMap.values()) {
            if (!(o instanceof MondrianCatalog)) continue;
            catalogs.add(o);
        }
        Collections.sort(catalogs, new Comparator<MondrianCatalog>(){

            @Override
            public int compare(MondrianCatalog o1, MondrianCatalog o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        SetUniqueList uniqueCatalogs = SetUniqueList.decorate(catalogs);
        return uniqueCatalogs;
    }

    private boolean catalogExists(MondrianCatalog catalog, IPentahoSession pentahoSession) {
        MondrianCatalog foundCatalog;
        if (catalog != null && (foundCatalog = MondrianCatalogHelper.getCatalogFromCache(catalog.getName(), pentahoSession)) != null) {
            if (!foundCatalog.getDataSource().getName().equals(catalog.getDataSource().getName())) {
                return false;
            }
            if (this.definitionEquals(foundCatalog.getDefinition(), catalog.getDefinition())) {
                return true;
            }
        }
        return false;
    }

    private static final MondrianCatalog getCatalogFromCache(String context, IPentahoSession pentahoSession) {
        Map catalogs = (Map)PentahoSystem.getCacheManager((IPentahoSession)pentahoSession).getFromRegionCache(MONDRIAN_CATALOG_CACHE_REGION, (Object)MondrianCatalogHelper.getLocale().toString());
        return (MondrianCatalog)catalogs.get(context);
    }

    public static MondrianCatalogHelper getInstance() {
        return (MondrianCatalogHelper)PentahoSystem.get(IMondrianCatalogService.class, (String)"IMondrianCatalogService", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void init(IPentahoSession pentahoSession) {
        IPentahoSession loadCatalogsSession;
        ICacheManager cacheMgr = PentahoSystem.getCacheManager((IPentahoSession)pentahoSession);
        if (cacheMgr.cacheEnabled(MONDRIAN_CATALOG_CACHE_REGION) && cacheMgr.getFromRegionCache(MONDRIAN_CATALOG_CACHE_REGION, (Object)MondrianCatalogHelper.getLocale().toString()) != null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"init");
        }
        if ((loadCatalogsSession = (IPentahoSession)PentahoSystem.get(IPentahoSession.class, (String)"systemStartupSession", null)) == null && pentahoSession != null) {
            loadCatalogsSession = pentahoSession;
        }
        PentahoSessionHolder.setSession((IPentahoSession)loadCatalogsSession);
        try {
            this.loadCatalogsIntoCache(this.makeDataSources(), loadCatalogsSession);
        }
        finally {
            PentahoSessionHolder.setSession((IPentahoSession)pentahoSession);
        }
        AggregationManager.instance().getCacheControl(null, null).flushSchemaCache();
    }

    public synchronized void reInit(IPentahoSession pentahoSession) {
        ICacheManager cacheMgr = PentahoSystem.getCacheManager((IPentahoSession)pentahoSession);
        if (cacheMgr.cacheEnabled(MONDRIAN_CATALOG_CACHE_REGION)) {
            cacheMgr.clearRegionCache(MONDRIAN_CATALOG_CACHE_REGION);
        }
        this.init(pentahoSession);
    }

    private static Locale getLocale() {
        Locale locale = LocaleHelper.getLocale();
        if (locale != null) {
            return locale;
        }
        return Locale.getDefault();
    }

    protected DataSourcesConfig.DataSources makeDataSources() {
        URL dataSourcesConfigUrl;
        block4: {
            dataSourcesConfigUrl = null;
            try {
                if (this.dataSourcesConfig.startsWith("file:")) {
                    dataSourcesConfigUrl = new URL(this.dataSourcesConfig);
                    break block4;
                }
                if (this.dataSourcesConfig.startsWith("classpath:")) {
                    dataSourcesConfigUrl = this.getClass().getResource(this.dataSourcesConfig.substring(10));
                    break block4;
                }
                throw new MondrianCatalogServiceException("dataSourcesConfig is not a valid URL or does not exist", MondrianCatalogServiceException.Reason.GENERAL);
            }
            catch (IOException e) {
                throw new MondrianCatalogServiceException(Messages.getErrorString("MondrianCatalogHelper.ERROR_0001_INVALID_DATASOURCE_CONFIG", this.dataSourcesConfig), e, MondrianCatalogServiceException.Reason.GENERAL);
            }
        }
        return dataSourcesConfigUrl == null ? null : this.parseDataSourcesUrl(dataSourcesConfigUrl);
    }

    protected DataSourcesConfig.DataSources parseDataSourcesUrl(URL dataSourcesConfigUrl) {
        try {
            String dataSourcesConfigString = this.readDataSourcesContent(dataSourcesConfigUrl);
            return this.parseDataSources(dataSourcesConfigString);
        }
        catch (Exception e) {
            throw Util.newError((Throwable)e, (String)Messages.getErrorString("MondrianCatalogHelper.ERROR_0002_FAILED_TO_PARSE_DATASOURCE_CONFIG", dataSourcesConfigUrl.toExternalForm()));
        }
    }

    protected String readDataSourcesContent(URL dataSourcesConfigUrl) throws IOException {
        return Util.readURL((URL)dataSourcesConfigUrl, (Map)Util.toMap((Properties)System.getProperties()));
    }

    protected DataSourcesConfig.DataSources parseDataSources(String dataSourcesConfigString) {
        try {
            if (dataSourcesConfigString == null) {
                logger.warn((Object)Messages.getString("MondrianCatalogHelper.WARN_PARSE_NULL_INPUT"));
                return null;
            }
            String replacedConfigString = Util.replaceProperties((String)dataSourcesConfigString, (Map)Util.toMap((Properties)System.getProperties()));
            if (logger.isDebugEnabled()) {
                String msg = "parseDataSources: dataSources=" + replacedConfigString;
                logger.debug((Object)msg);
            }
            Parser parser = XOMUtil.createDefaultParser();
            DOMWrapper doc = parser.parse(replacedConfigString);
            this.catalogComplementInfoMap = this.makeCatalogComplementInfoMap(doc);
            return new DataSourcesConfig.DataSources(doc);
        }
        catch (XOMException e) {
            throw Util.newError((Throwable)e, (String)Messages.getErrorString("MondrianCatalogHelper.ERROR_0002_FAILED_TO_PARSE_DATASOURCE_CONFIG", dataSourcesConfigString));
        }
    }

    protected Map<String, MondrianCatalogComplementInfo> makeCatalogComplementInfoMap(DOMWrapper doc) {
        HashMap<String, MondrianCatalogComplementInfo> map = new HashMap<String, MondrianCatalogComplementInfo>();
        if (doc.getElementChildren().length > 0) {
            int i;
            DOMWrapper dataSource = doc.getElementChildren()[0];
            DOMWrapper catalogs = null;
            for (i = 0; i < dataSource.getElementChildren().length; ++i) {
                DOMWrapper element = dataSource.getElementChildren()[i];
                if (!element.getTagName().equals("Catalogs")) continue;
                catalogs = element;
                break;
            }
            for (i = 0; i < catalogs.getElementChildren().length; ++i) {
                DOMWrapper catalog = catalogs.getElementChildren()[i];
                if (!"Catalog".equals(catalog.getTagName())) continue;
                MondrianCatalogComplementInfo complementInfo = new MondrianCatalogComplementInfo();
                for (int j = 0; j < catalog.getElementChildren().length; ++j) {
                    DOMWrapper whereNode = catalog.getElementChildren()[j];
                    if (!"WhereCondition".equals(whereNode.getTagName())) continue;
                    complementInfo.addWhereCondition(whereNode.getAttribute("cube"), whereNode.getText());
                }
                map.put(this.getDOMWrapperElementText(catalog, "Definition"), complementInfo);
            }
        }
        return map;
    }

    private String getDOMWrapperElementText(DOMWrapper element, String name) {
        for (int i = 0; i < element.getElementChildren().length; ++i) {
            DOMWrapper child = element.getElementChildren()[i];
            if (!child.getTagName().equals(name)) continue;
            return child.getText();
        }
        return null;
    }

    protected Map<String, MondrianCatalog> makeCatalogMap(List<MondrianCatalog> cats) {
        HashMap<String, MondrianCatalog> map = new HashMap<String, MondrianCatalog>();
        for (MondrianCatalog catalog : cats) {
            map.put(catalog.getName(), catalog);
        }
        return map;
    }

    private boolean definitionEquals(String def1, String def2) {
        if (def1.equals(def2)) {
            return true;
        }
        String tmp = def1.startsWith("solution:/") ? "solution:" + def1.substring(10) : "solution:/" + def1.substring(9);
        return tmp.equals(def2);
    }

    protected String cleanseDataSourceInfo(String dataSourceInfo) {
        if (dataSourceInfo == null) {
            return null;
        }
        Util.PropertyList propertyList = Util.parseConnectString((String)dataSourceInfo);
        if (propertyList.get("EnableXmla") != null) {
            propertyList.remove("EnableXmla");
        }
        return propertyList.toString();
    }

    public String getDataSourcesConfig() {
        return this.dataSourcesConfig;
    }

    public void setDataSourcesConfig(String dataSourcesConfig) {
        this.dataSourcesConfig = dataSourcesConfig;
    }

    @Override
    public List<MondrianCatalog> listCatalogs(IPentahoSession pentahoSession, boolean jndiOnly) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"listCatalogs");
        }
        this.init(pentahoSession);
        return Collections.unmodifiableList(this.filter(this.getCatalogs(pentahoSession), pentahoSession, jndiOnly));
    }

    @Override
    public synchronized void addCatalog(MondrianCatalog catalog, boolean overwrite, IPentahoSession pentahoSession) throws MondrianCatalogServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"addCatalog");
        }
        this.init(pentahoSession);
        if (!this.hasAccess(catalog, CatalogPermission.WRITE, pentahoSession)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"user does not have access; throwing exception");
            }
            throw new MondrianCatalogServiceException(Messages.getErrorString("MondrianCatalogHelper.ERROR_0003_INSUFFICIENT_PERMISSION"), MondrianCatalogServiceException.Reason.ACCESS_DENIED);
        }
        if (this.catalogExists(catalog, pentahoSession) && !overwrite) {
            throw new MondrianCatalogServiceException(Messages.getErrorString("MondrianCatalogHelper.ERROR_0004_ALREADY_EXISTS"), MondrianCatalogServiceException.Reason.ALREADY_EXISTS);
        }
        MondrianCatalog fileLocationCatalogTest = null;
        for (MondrianCatalog currentCatalogCheck : this.getCatalogs(pentahoSession)) {
            if (!currentCatalogCheck.getName().equals(catalog.getName())) continue;
            fileLocationCatalogTest = currentCatalogCheck;
            break;
        }
        if (fileLocationCatalogTest != null && !this.definitionEquals(fileLocationCatalogTest.getDefinition(), catalog.getDefinition())) {
            throw new MondrianCatalogServiceException(Messages.getErrorString("MondrianCatalogHelper.ERROR_0004_ALREADY_EXISTS"), MondrianCatalogServiceException.Reason.XMLA_SCHEMA_NAME_EXISTS);
        }
        DataSourcesConfig.DataSources dataSources = this.makeDataSources();
        MondrianDataSource mDataSource = catalog.getDataSource();
        DataSourcesConfig.DataSource ds = null;
        for (int i = 0; i < dataSources.dataSources.length && ds == null; ++i) {
            DataSourcesConfig.DataSource currentDs = dataSources.dataSources[i];
            if (!mDataSource.getName().equals(currentDs.name)) continue;
            ds = currentDs;
            break;
        }
        if (ds == null) {
            ds = new DataSourcesConfig.DataSource();
            ds.authenticationMode = mDataSource.getAuthenticationMode();
            ds.dataSourceInfo = mDataSource.getDataSourceInfo();
            ds.description = mDataSource.getDescription();
            ds.name = mDataSource.getName();
            ds.providerName = mDataSource.getProviderName();
            ds.providerType = mDataSource.getProviderType();
            ds.url = mDataSource.getUrl();
            dataSources.dataSources = (DataSourcesConfig.DataSource[])ArrayUtils.add((Object[])dataSources.dataSources, (Object)ds);
        }
        DataSourcesConfig.Catalog cat = null;
        if (this.catalogExists(catalog, pentahoSession)) {
            for (DataSourcesConfig.Catalog currentCat : ds.catalogs.catalogs) {
                if (!this.definitionEquals(catalog.getDefinition(), currentCat.definition)) continue;
                cat = currentCat;
                break;
            }
        }
        if (cat == null) {
            cat = new DataSourcesConfig.Catalog();
            if (ds.catalogs == null) {
                ds.catalogs = new DataSourcesConfig.Catalogs();
            }
            if (ds.catalogs.catalogs == null) {
                ds.catalogs.catalogs = new DataSourcesConfig.Catalog[0];
            }
            ds.catalogs.catalogs = (DataSourcesConfig.Catalog[])ArrayUtils.add((Object[])ds.catalogs.catalogs, (Object)cat);
        }
        if (cat.dataSourceInfo != null) {
            Util.PropertyList originalProps = Util.parseConnectString((String)cat.dataSourceInfo);
            Util.PropertyList newProps = Util.parseConnectString((String)catalog.getDataSourceInfo());
            for (Pair prop : newProps) {
                originalProps.put((String)prop.left, (String)prop.right);
            }
            if (newProps.get("EnableXmla") == null || newProps.get("EnableXmla").equalsIgnoreCase("true")) {
                originalProps.remove("EnableXmla");
            }
            cat.dataSourceInfo = originalProps.toString().replaceAll("; ", ";");
        } else {
            cat.dataSourceInfo = catalog.getDataSourceInfo();
        }
        cat.definition = catalog.getDefinition();
        cat.name = catalog.getName();
        this.writeDataSources(dataSources);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("refreshing from dataSourcesConfig (" + this.dataSourcesConfig + ")"));
        }
        this.reInit(pentahoSession);
    }

    protected void writeDataSources(DataSourcesConfig.DataSources dataSources) {
        FileWriter sxml;
        File dataSourcesFile;
        try {
            dataSourcesFile = new File(new URL(this.dataSourcesConfig).getFile());
        }
        catch (IOException e) {
            throw new MondrianCatalogServiceException(Messages.getErrorString("MondrianCatalogHelper.ERROR_0005_RESOURCE_NOT_AVAILABLE"), e, MondrianCatalogServiceException.Reason.GENERAL);
        }
        try {
            sxml = new FileWriter(dataSourcesFile);
        }
        catch (IOException e) {
            throw new MondrianCatalogServiceException(e);
        }
        StringWriter sw = new StringWriter();
        XMLOutput pxml = new XMLOutput((Writer)sw);
        pxml.print("<?xml version=\"1.0\"?>\n");
        dataSources.displayXML(pxml, 0);
        Document doc = null;
        try {
            doc = XmlDom4JHelper.getDocFromString((String)sw.toString(), (EntityResolver)new PentahoEntityResolver());
        }
        catch (XmlParseException e) {
            throw new MondrianCatalogServiceException(e);
        }
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding(doc.getXMLEncoding());
            XMLWriter writer = new XMLWriter((Writer)sxml, format);
            writer.write(doc);
            writer.close();
        }
        catch (IOException e) {
            throw new MondrianCatalogServiceException(e);
        }
        IOUtils.closeQuietly((Writer)sxml);
    }

    @Override
    public MondrianCatalog getCatalog(String context, IPentahoSession pentahoSession) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getCatalog");
        }
        this.init(pentahoSession);
        MondrianCatalog cat = MondrianCatalogHelper.getCatalogFromCache(context, pentahoSession);
        if (null != cat) {
            if (this.hasAccess(cat, CatalogPermission.READ, pentahoSession)) {
                return cat;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("user requested catalog with name \"" + context + "\", but had insufficient privileges; returning null"));
            }
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("user requested catalog with name\"" + context + "\", but catalog doesn't exist"));
        }
        return null;
    }

    protected void loadCatalogsIntoCache(DataSourcesConfig.DataSources dataSources, IPentahoSession pentahoSession) {
        ICacheManager cacheMgr = PentahoSystem.getCacheManager((IPentahoSession)pentahoSession);
        if (!cacheMgr.cacheEnabled(MONDRIAN_CATALOG_CACHE_REGION)) {
            cacheMgr.addCacheRegion(MONDRIAN_CATALOG_CACHE_REGION);
        }
        if (cacheMgr.getFromRegionCache(MONDRIAN_CATALOG_CACHE_REGION, (Object)MondrianCatalogHelper.getLocale().toString()) == null) {
            cacheMgr.putInRegionCache(MONDRIAN_CATALOG_CACHE_REGION, (Object)MondrianCatalogHelper.getLocale().toString(), new HashMap());
        }
        for (DataSourcesConfig.DataSource dataSource : dataSources.dataSources) {
            ArrayList<String> catalogNames = new ArrayList<String>();
            for (DataSourcesConfig.Catalog catalog : dataSource.catalogs.catalogs) {
                catalogNames.add(catalog.name);
            }
            MondrianDataSource mondrianDataSource = new MondrianDataSource(dataSource.name, dataSource.description, dataSource.url, dataSource.dataSourceInfo, dataSource.providerName, dataSource.providerType, dataSource.authenticationMode, catalogNames);
            Map catalogs = (Map)cacheMgr.getFromRegionCache(MONDRIAN_CATALOG_CACHE_REGION, (Object)MondrianCatalogHelper.getLocale().toString());
            for (DataSourcesConfig.Catalog catalog : dataSource.catalogs.catalogs) {
                if (catalog.definition.startsWith("solution:")) {
                    try {
                        MondrianSchema schema = this.makeSchema(this.docAtUrlToString(catalog.definition, pentahoSession));
                        MondrianCatalog mondrianCatalog = new MondrianCatalog(this.useSchemaNameAsCatalogName ? schema.getName() : catalog.name, catalog.dataSourceInfo, catalog.definition, mondrianDataSource, schema);
                        catalogs.put(mondrianCatalog.getName(), mondrianCatalog);
                        catalogs.put(mondrianCatalog.getDefinition(), mondrianCatalog);
                    }
                    catch (Exception e) {
                        logger.error((Object)Messages.getErrorString("MondrianCatalogHelper.ERROR_0013_FAILED_TO_LOAD_SCHEMA", catalog.definition), (Throwable)e);
                    }
                    continue;
                }
                logger.warn((Object)Messages.getString("MondrianCatalogHelper.WARN_SKIPPING_DATASOURCE_DEF", catalog.definition));
            }
        }
    }

    @Deprecated
    protected List<MondrianCatalog> transformIntoCatalogList(DataSourcesConfig.DataSources dataSources, IPentahoSession pentahoSession) {
        ArrayList<MondrianCatalog> localCatalogs = new ArrayList<MondrianCatalog>();
        for (DataSourcesConfig.DataSource dataSource : dataSources.dataSources) {
            ArrayList<String> catalogNames = new ArrayList<String>();
            for (DataSourcesConfig.Catalog catalog : dataSource.catalogs.catalogs) {
                catalogNames.add(catalog.name);
            }
            MondrianDataSource mondrianDataSource = new MondrianDataSource(dataSource.name, dataSource.description, dataSource.url, dataSource.dataSourceInfo, dataSource.providerName, dataSource.providerType, dataSource.authenticationMode, catalogNames);
            for (DataSourcesConfig.Catalog catalog : dataSource.catalogs.catalogs) {
                if (catalog.definition.startsWith("solution:")) {
                    try {
                        MondrianSchema schema = this.makeSchema(this.docAtUrlToString(catalog.definition, pentahoSession));
                        MondrianCatalogComplementInfo catalogComplementInfo = this.getCatalogComplementInfoMap(catalog.definition);
                        MondrianCatalog mondrianCatalog = new MondrianCatalog(this.useSchemaNameAsCatalogName ? schema.getName() : catalog.name, catalog.dataSourceInfo, catalog.definition, mondrianDataSource, schema, catalogComplementInfo);
                        localCatalogs.add(mondrianCatalog);
                    }
                    catch (Exception e) {
                        logger.error((Object)Messages.getErrorString("MondrianCatalogHelper.ERROR_0013_FAILED_TO_LOAD_SCHEMA", catalog.definition), (Throwable)e);
                    }
                    continue;
                }
                logger.warn((Object)Messages.getString("MondrianCatalogHelper.WARN_SKIPPING_DATASOURCE_DEF", catalog.definition));
            }
        }
        return localCatalogs;
    }

    public MondrianCatalogComplementInfo getCatalogComplementInfoMap(String name) {
        return this.catalogComplementInfoMap.get(name);
    }

    @Override
    public MondrianSchema loadMondrianSchema(String solutionLocation, IPentahoSession pentahoSession) {
        return this.makeSchema(this.docAtUrlToString(solutionLocation, pentahoSession));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String docAtUrlToString(String urlStr, IPentahoSession pentahoSession) {
        String relPath = this.getSolutionRepositoryRelativePath(urlStr, pentahoSession);
        String res = null;
        InputStream in = null;
        try {
            ISolutionRepository repo = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)pentahoSession);
            if (repo == null) {
                throw new IllegalStateException(Messages.getErrorString("MondrianCatalogHelper.ERROR_0014_SOLUTION_REPOSITORY_REQUIRED"));
            }
            in = repo.getResourceInputStream(relPath, true, 1);
            LocalizingDynamicSchemaProcessor schemaProcessor = new LocalizingDynamicSchemaProcessor();
            Util.PropertyList localeInfo = new Util.PropertyList();
            localeInfo.put("Locale", MondrianCatalogHelper.getLocale().toString());
            res = schemaProcessor.filter(null, localeInfo, in);
        }
        catch (FileNotFoundException fnfe) {
            try {
                throw new MondrianCatalogServiceException(Messages.getErrorString("MondrianCatalogHelper.ERROR_0007_FILE_NOT_FOUND"), fnfe);
                catch (Exception e) {
                    throw new MondrianCatalogServiceException(Messages.getErrorString("MondrianCatalogHelper.ERROR_0006_IO_PROBLEM"), e);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return res;
    }

    protected MondrianSchema getSchema(String catalogName, IPentahoSession pentahoSession) {
        MondrianCatalog catalog = MondrianCatalogHelper.getCatalogFromCache(catalogName, pentahoSession);
        if (null == catalog) {
            return null;
        }
        return catalog.getSchema();
    }

    protected MondrianSchema makeSchema(String catalogStr) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("makeSchema (catalogStr=" + catalogStr.substring(0, Math.min(40, catalogStr.length())) + "...)"));
        }
        MondrianSchema schema = null;
        try {
            String name;
            Parser xmlParser = XOMUtil.createDefaultParser();
            DOMWrapper def = xmlParser.parse(catalogStr);
            MondrianDef.Schema schemaFromXml = new MondrianDef.Schema(def);
            String schemaName = schemaFromXml.name;
            ArrayList<MondrianCube> mondrianCubes = new ArrayList<MondrianCube>();
            for (MondrianDef.Cube cube : schemaFromXml.cubes) {
                if (cube.enabled != null && !cube.enabled.booleanValue()) continue;
                name = cube.caption;
                if (StringUtils.isBlank((String)name)) {
                    name = cube.name;
                }
                mondrianCubes.add(new MondrianCube(name, cube.name));
            }
            for (MondrianDef.Cube cube : schemaFromXml.virtualCubes) {
                name = cube.caption;
                if (StringUtils.isBlank((String)name)) {
                    name = cube.name;
                }
                if (cube.enabled != null && !cube.enabled.booleanValue()) continue;
                mondrianCubes.add(new MondrianCube(name, cube.name));
            }
            MondrianDef.Role[] roles = schemaFromXml.roles;
            String[] roleNames = null;
            if (roles != null && roles.length > 0) {
                roleNames = new String[roles.length];
                for (int i = 0; i < roles.length; ++i) {
                    roleNames[i] = roles[i].name;
                }
            }
            schema = new MondrianSchema(schemaName, mondrianCubes, roleNames);
        }
        catch (XOMException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)Messages.getErrorString("MondrianCatalogHelper.ERROR_0008_ERROR_OCCURRED"), (Throwable)e);
            }
            throw Util.newError((Throwable)e, (String)Messages.getErrorString("MondrianCatalogHelper.ERROR_0009_WHILE_PARSING_CATALOG", catalogStr));
        }
        return schema;
    }

    protected List<MondrianCatalog> filter(List<MondrianCatalog> origList, IPentahoSession pentahoSession, boolean jndiOnly) {
        ArrayList<MondrianCatalog> filtered = new ArrayList<MondrianCatalog>();
        for (MondrianCatalog orig : origList) {
            if (!this.hasAccess(orig, CatalogPermission.READ, pentahoSession) || jndiOnly && !orig.getEffectiveDataSource().isJndi()) continue;
            filtered.add(orig);
        }
        return filtered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasAccess(MondrianCatalog cat, final CatalogPermission perm, IPentahoSession pentahoSession) {
        ISolutionFile solutionFile;
        IPermissionMask mappedPerm;
        ISolutionRepository repo;
        block9: {
            repo = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)pentahoSession);
            if (repo == null) {
                throw new IllegalStateException(Messages.getErrorString("MondrianCatalogHelper.ERROR_0014_SOLUTION_REPOSITORY_REQUIRED"));
            }
            if (!repo.supportsAccessControls()) {
                return true;
            }
            mappedPerm = new IPermissionMask(){

                public int getMask() {
                    return perm == CatalogPermission.READ ? 1 : 12;
                }
            };
            String relPath = this.getSolutionRepositoryRelativePath(cat.getDefinition(), pentahoSession);
            solutionFile = null;
            IPentahoSession systemSession = null;
            systemSession = (IPentahoSession)PentahoSystem.get(IPentahoSession.class, (String)"systemStartupSession", null);
            if (systemSession != null) {
                PentahoSessionHolder.setSession((IPentahoSession)systemSession);
                try {
                    ISolutionRepository systemRepo = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)systemSession);
                    if (systemRepo == null) {
                        throw new IllegalStateException(Messages.getErrorString("MondrianCatalogHelper.ERROR_0014_SOLUTION_REPOSITORY_REQUIRED"));
                    }
                    solutionFile = systemRepo.getSolutionFile(relPath, 1);
                    if (solutionFile == null) {
                        throw new MondrianCatalogServiceException(Messages.getErrorString("MondrianCatalogHelper.ERROR_0010_PATH_NOT_FOUND", cat.getDefinition()));
                    }
                    break block9;
                }
                finally {
                    PentahoSessionHolder.setSession((IPentahoSession)pentahoSession);
                }
            }
            solutionFile = repo.getSolutionFile(relPath, 1);
            if (null == solutionFile && null == (solutionFile = repo.getSolutionFile(relPath = relPath.substring(0, relPath.lastIndexOf("/")), 1))) {
                throw new MondrianCatalogServiceException(Messages.getErrorString("MondrianCatalogHelper.ERROR_0010_PATH_NOT_FOUND", cat.getDefinition()));
            }
        }
        repo = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)pentahoSession);
        return repo.hasAccess(solutionFile, mappedPerm.getMask());
    }

    protected String getSolutionRepositoryRelativePath(String path, IPentahoSession pentahoSession) {
        ISolutionRepository repo = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)pentahoSession);
        if (repo == null) {
            throw new IllegalStateException(Messages.getErrorString("MondrianCatalogHelper.ERROR_0014_SOLUTION_REPOSITORY_REQUIRED"));
        }
        SolutionReposHelper.setSolutionRepositoryThreadVariable((ISolutionRepository)repo);
        try {
            FileSystemManager fsManager = VFS.getManager();
            return fsManager.resolveFile(path).getName().getPath();
        }
        catch (FileSystemException e) {
            throw new MondrianCatalogServiceException(Messages.getErrorString("MondrianCatalogHelper.ERROR_0012_FILESYSTEM_PROBLEM"), e);
        }
    }

    public boolean isUseSchemaNameAsCatalogName() {
        return this.useSchemaNameAsCatalogName;
    }

    public void setUseSchemaNameAsCatalogName(boolean useSchemaNameAsCatalogName) {
        this.useSchemaNameAsCatalogName = useSchemaNameAsCatalogName;
    }

    public static int addToCatalog(String baseUrl, boolean enableXmla, String schemaSolutionPath, IPentahoSession session, String jndiName, boolean overwrite) {
        MondrianCatalogHelper mondrianCatalogService = MondrianCatalogHelper.getInstance();
        String dsUrl = baseUrl;
        if (!dsUrl.endsWith("/")) {
            dsUrl = dsUrl + "/";
        }
        dsUrl = dsUrl + "Xmla";
        String dsAuthMode = "Unauthenticated";
        String dsProviderName = "Pentaho";
        String dsProviderType = enableXmla ? "MDP" : "None";
        String catDef = "solution:" + schemaSolutionPath;
        MondrianSchema mondrianSchema = mondrianCatalogService.loadMondrianSchema(catDef, session);
        String catName = mondrianSchema.getName();
        String dsName = "Provider=Mondrian;DataSource=" + mondrianSchema.getName();
        String dsDesc = "Published Mondrian Schema " + mondrianSchema.getName() + " using jndi datasource " + jndiName;
        String[] roleNames = mondrianSchema.getRoleNames();
        try {
            IDatasourceService datasourceService = (IDatasourceService)PentahoSystem.getObjectFactory().get(IDatasourceService.class, null);
            datasourceService.getDSBoundName(jndiName);
        }
        catch (ObjectFactoryException objface) {
            Logger.error((String)"MondrianCatalogHelper", (String)Messages.getErrorString("MondrianCatalogPublisher.ERROR_0006_UNABLE_TO_FACTORY_OBJECT", jndiName), (Throwable)objface);
        }
        catch (DatasourceServiceException dse) {
            Logger.error((String)"MondrianCatalogHelper", (String)Messages.getErrorString("MondrianCatalogPublisher.ERROR_0001_JNDI_NAMING_ERROR", jndiName), (Throwable)dse);
            return -1;
        }
        String catConnectStr = "Provider=mondrian;DataSource=" + jndiName;
        MondrianDataSource ds = new MondrianDataSource(dsName, dsDesc, dsUrl, catConnectStr, dsProviderName, dsProviderType, dsAuthMode, null);
        MondrianCatalog cat = new MondrianCatalog(catName, catConnectStr, catDef, ds, new MondrianSchema(catName, new ArrayList<MondrianCube>(), roleNames));
        try {
            mondrianCatalogService.addCatalog(cat, overwrite, session);
        }
        catch (MondrianCatalogServiceException e) {
            Logger.error((String)"MondrianCatalogHelper", (String)Messages.getErrorString("MondrianCatalogPublisher.ERROR_0002_EXCEPTION_OCCURRED"), (Throwable)e);
            return -1;
        }
        return 0;
    }

    @Override
    public void removeCatalog(String catalogName, IPentahoSession pentahoSession) throws MondrianCatalogServiceException {
        int i;
        MondrianCatalog catalog;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"removeCatalog");
        }
        if ((catalog = this.getCatalog(catalogName, pentahoSession)) == null) {
            throw new MondrianCatalogServiceException(Messages.getErrorString("MondrianCatalogHelper.ERROR_0015_CATALOG_NOT_FOUND", catalogName));
        }
        if (!this.hasAccess(catalog, CatalogPermission.WRITE, pentahoSession)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"user does not have access; throwing exception");
            }
            throw new MondrianCatalogServiceException(Messages.getErrorString("MondrianCatalogHelper.ERROR_0003_INSUFFICIENT_PERMISSION"), MondrianCatalogServiceException.Reason.ACCESS_DENIED);
        }
        if (!catalog.getDefinition().startsWith("solution:")) {
            throw new MondrianCatalogServiceException(Messages.getErrorString("MondrianCatalogHelper.ERROR_0016_REMOVE_SOLUTION_DEFS_ONLY", catalog.getDefinition()));
        }
        String solutionPath = catalog.getDefinition().substring(9);
        ISolutionRepository repo = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)pentahoSession);
        if (repo == null) {
            throw new IllegalStateException(Messages.getErrorString("MondrianCatalogHelper.ERROR_0014_SOLUTION_REPOSITORY_REQUIRED"));
        }
        repo.removeSolutionFile(solutionPath);
        DataSourcesConfig.DataSources dataSources = this.makeDataSources();
        MondrianDataSource mDataSource = catalog.getDataSource();
        DataSourcesConfig.DataSource ds = null;
        for (i = 0; i < dataSources.dataSources.length && ds == null; ++i) {
            DataSourcesConfig.DataSource currentDs = dataSources.dataSources[i];
            if (!mDataSource.getName().equals(currentDs.name)) continue;
            ds = currentDs;
        }
        for (i = 0; i < ds.catalogs.catalogs.length; ++i) {
            if (!ds.catalogs.catalogs[i].name.equals(catalogName)) continue;
            ds.catalogs.catalogs = (DataSourcesConfig.Catalog[])ArrayUtils.remove((Object[])ds.catalogs.catalogs, (int)i);
            break;
        }
        this.writeDataSources(dataSources);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("refreshing from dataSourcesConfig (" + this.dataSourcesConfig + ")"));
        }
        this.reInit(pentahoSession);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum CatalogPermission {
        READ,
        WRITE;

    }
}

