/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.mondrian.catalog;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.Util;
import mondrian.util.Pair;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MondrianDataSource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private String url;
    private String dataSourceInfo;
    private String providerName;
    private String providerType;
    private String authenticationMode;
    private List<String> catalogNames;
    private Map<String, String> propertyList = new HashMap<String, String>();

    public MondrianDataSource(MondrianDataSource copy, String overrideInfo) {
        this(copy.name, copy.description, copy.url, null != overrideInfo ? overrideInfo : copy.dataSourceInfo, copy.providerName, copy.providerType, copy.authenticationMode, copy.catalogNames);
    }

    public MondrianDataSource(String name, String description, String url, String dataSourceInfo, String providerName, String providerType, String authenticationMode, List<String> catalogNames) {
        this.name = name;
        this.description = description;
        this.url = url;
        this.dataSourceInfo = dataSourceInfo;
        this.providerName = providerName;
        this.providerType = providerType;
        this.authenticationMode = authenticationMode;
        this.catalogNames = catalogNames;
        if (dataSourceInfo != null) {
            Util.PropertyList list = Util.parseConnectString((String)dataSourceInfo);
            for (Pair pair : list) {
                this.propertyList.put((String)pair.getKey(), (String)pair.getValue());
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDataSourceInfo() {
        return this.dataSourceInfo;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getProviderType() {
        return this.providerType;
    }

    public String getAuthenticationMode() {
        return this.authenticationMode;
    }

    protected List<String> getCatalogNames() {
        return this.catalogNames;
    }

    public boolean isJndi() {
        return this.propertyList.get("DataSource") != null;
    }

    public String getJndi() {
        return this.propertyList.get("DataSource");
    }

    public String getJdbc() {
        return this.propertyList.get("Jdbc");
    }

    protected boolean isXmla() {
        return !"False".equals(this.propertyList.get("EnableXmla"));
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("description", (Object)this.description).append("url", (Object)this.url).append("dataSourceInfo", (Object)this.dataSourceInfo).append("providerName", (Object)this.providerName).append("providerType", (Object)this.providerType).append("authenticationMode", (Object)this.authenticationMode).append("catalogNames", this.catalogNames).toString();
    }
}

