/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.mondrian.mapper;

import java.util.Arrays;
import org.pentaho.platform.api.engine.IConnectionUserRoleMapper;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianSchema;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;

public abstract class MondrianAbstractPlatformUserRoleMapper
implements IConnectionUserRoleMapper {
    protected abstract String[] mapRoles(String[] var1, String[] var2) throws PentahoAccessControlException;

    protected String[] getMondrianRolesFromCatalog(IPentahoSession userSession, String context) {
        Object[] roleNames;
        MondrianSchema schema;
        MondrianCatalog catalog;
        String[] rtn = null;
        IMondrianCatalogService catalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class);
        if (catalogService != null && (catalog = catalogService.getCatalog(context, userSession)) != null && (schema = catalog.getSchema()) != null && (roleNames = schema.getRoleNames()) != null && roleNames.length > 0) {
            Arrays.sort(roleNames);
            return roleNames;
        }
        return rtn;
    }

    protected String[] getPlatformRolesFromSession(IPentahoSession session) {
        Authentication auth = SecurityHelper.getAuthentication((IPentahoSession)session, (boolean)false);
        Object[] rtn = null;
        GrantedAuthority[] gAuths = auth.getAuthorities();
        if (gAuths != null && gAuths.length > 0) {
            rtn = new String[gAuths.length];
            for (int i = 0; i < gAuths.length; ++i) {
                rtn[i] = gAuths[i].getAuthority();
            }
            Arrays.sort(rtn);
        }
        return rtn;
    }

    public String[] mapConnectionRoles(IPentahoSession userSession, String connectionContext) throws PentahoAccessControlException {
        String[] mondrianRoleNames = this.getMondrianRolesFromCatalog(userSession, connectionContext);
        String[] platformRoleNames = this.getPlatformRolesFromSession(userSession);
        String[] mappedResult = null;
        if (mondrianRoleNames != null && platformRoleNames != null && mondrianRoleNames.length > 0 && platformRoleNames.length > 0) {
            mappedResult = this.mapRoles(mondrianRoleNames, platformRoleNames);
        }
        return mappedResult;
    }

    public Object mapConnectionUser(IPentahoSession userSession, String context) throws PentahoAccessControlException {
        throw new UnsupportedOperationException();
    }
}

