/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.mondrian.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.action.mondrian.mapper.MondrianAbstractPlatformUserRoleMapper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MondrianLookupMapUserRoleListMapper
extends MondrianAbstractPlatformUserRoleMapper
implements InitializingBean {
    private Map<String, String> lookupMap;
    protected boolean failOnEmptyRoleList = true;

    @Override
    protected String[] mapRoles(String[] mondrianRoles, String[] platformRoles) throws PentahoAccessControlException {
        ArrayList<String> mappedRolesList = new ArrayList<String>();
        if (mondrianRoles != null && platformRoles != null) {
            for (int i = 0; i < platformRoles.length; ++i) {
                int foundIdx;
                String aRole = this.lookupMap.get(platformRoles[i]);
                if (aRole == null || (foundIdx = Arrays.binarySearch(mondrianRoles, aRole)) < 0) continue;
                mappedRolesList.add(aRole);
            }
        }
        if (mappedRolesList.size() > 0) {
            return mappedRolesList.toArray(new String[mappedRolesList.size()]);
        }
        if (this.failOnEmptyRoleList) {
            throw new PentahoAccessControlException(Messages.getErrorString("MondrianOneToOneUserRoleListMapper.ERROR_001_NO_CORRESPONDENCE"));
        }
        return null;
    }

    public void setLookupMap(Map<String, String> value) {
        this.lookupMap = value;
    }

    public Map<String, String> getLookupMap() {
        return this.lookupMap;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.lookupMap);
    }

    public void setFailOnEmptyRoleList(boolean failOnEmptyRoleList) {
        this.failOnEmptyRoleList = failOnEmptyRoleList;
    }

    public boolean isFailOnEmptyRoleList() {
        return this.failOnEmptyRoleList;
    }
}

