/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.openflashchart.factory;

import java.util.ArrayList;
import java.util.List;
import ofc4j.model.axis.Axis;
import ofc4j.model.axis.YAxis;
import ofc4j.model.elements.Element;
import ofc4j.model.elements.LineChart;
import org.apache.commons.logging.Log;
import org.dom4j.Node;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.plugin.action.openflashchart.factory.AbstractChartFactory;
import org.pentaho.platform.plugin.action.openflashchart.factory.BarChartFactory;
import org.pentaho.platform.plugin.action.openflashchart.factory.LineChartFactory;

public class BarLineChartFactory
extends BarChartFactory {
    private static final String BAR_SERIES_SERIES_NODE_LOC = "bar-series/series";
    private static final String LINES_RANGE_STROKE_NODE_LOC = "lines-range-stroke";
    private static final String LINES_RANGE_GRID_COLOR_NODE_LOC = "lines-range-grid-color";
    private static final String LINES_RANGE_COLOR_NODE_LOC = "lines-range-color";
    private static final String LINE_SERIES_SERIES_NODE_LOC = "line-series/series";
    private static final String LINES_RANGE_MAXIMUM_NODE_LOC = "lines-range-maximum";
    private static final String LINES_RANGE_MINIMUM_NODE_LOC = "lines-range-minimum";
    private static final String LINE_RANGE_STEPS_NODE_LOC = "line-range-steps";
    LineChartFactory lineChartFactory = new LineChartFactory();

    public void setupStyles() {
        super.setupStyles();
        this.lineChartFactory.setupStyles();
    }

    public void setData(IPentahoResultSet data) {
        super.setData(data);
        data.beforeFirst();
        this.lineChartFactory.setData(data);
    }

    public void setChartNode(Node chartNode) {
        super.setChartNode(chartNode);
        this.lineChartFactory.setChartNode(chartNode);
    }

    public void setLog(Log log) {
        super.setLog(log);
        this.lineChartFactory.setLog(log);
    }

    protected void setupColors() {
        super.setupColors();
        this.lineChartFactory.setupColors();
    }

    public Axis setupRange() {
        Axis axis = super.setupRange();
        this.setupLineRange();
        return axis;
    }

    public AbstractChartFactory.MinMax getRangeMinMax() {
        int rangeMin = 0;
        int rangeMax = 0;
        if (this.isstacked) {
            rangeMin = 0;
            rangeMax = this.getStackedMaxRange();
        } else {
            rangeMin = Integer.MAX_VALUE;
            rangeMax = Integer.MIN_VALUE;
            List nodes = this.chartNode.selectNodes(BAR_SERIES_SERIES_NODE_LOC);
            ArrayList<String> bars = new ArrayList<String>();
            for (Object node : nodes) {
                if (BarLineChartFactory.getValue((Node)node) == null) continue;
                bars.add(BarLineChartFactory.getValue((Node)node));
            }
            for (int c = 0; c < this.getColumnCount(); ++c) {
                String text = this.getColumnHeader(c);
                if (!bars.contains(text)) continue;
                for (int r = 0; r < this.getRowCount(); ++r) {
                    if (rangeMin > ((Number)this.getValueAt(r, c)).intValue()) {
                        rangeMin = ((Number)this.getValueAt(r, c)).intValue();
                    }
                    if (rangeMax >= ((Number)this.getValueAt(r, c)).intValue()) continue;
                    rangeMax = ((Number)this.getValueAt(r, c)).intValue();
                }
            }
        }
        if (rangeMin > 0) {
            rangeMin = 0;
        }
        return new AbstractChartFactory.MinMax(rangeMin, rangeMax);
    }

    public void setupLineRange() {
        int rangeMin = 0;
        int rangeMax = 100;
        int steps = 9;
        String rangeColor = "#000000";
        String rangeGridColor = "#aaaaaa";
        int rangeStroke = 1;
        if ("CategoryDataset".equals(this.datasetType) || "XYZSeriesCollection".equals(this.datasetType)) {
            rangeMin = Integer.MAX_VALUE;
            rangeMax = Integer.MIN_VALUE;
            List nodes = this.chartNode.selectNodes(LINE_SERIES_SERIES_NODE_LOC);
            ArrayList<String> bars = new ArrayList<String>();
            for (Object node : nodes) {
                if (BarLineChartFactory.getValue((Node)node) == null) continue;
                bars.add(BarLineChartFactory.getValue((Node)node));
            }
            for (int c = 0; c < this.getColumnCount(); ++c) {
                String text = this.getColumnHeader(c);
                if (!bars.contains(text)) continue;
                for (int r = 0; r < this.getRowCount(); ++r) {
                    if (rangeMin > ((Number)this.getValueAt(r, c)).intValue()) {
                        rangeMin = ((Number)this.getValueAt(r, c)).intValue();
                    }
                    if (rangeMax >= ((Number)this.getValueAt(r, c)).intValue()) continue;
                    rangeMax = ((Number)this.getValueAt(r, c)).intValue();
                }
            }
        }
        boolean minDefined = false;
        boolean maxDefined = false;
        Node temp = this.chartNode.selectSingleNode(LINES_RANGE_MINIMUM_NODE_LOC);
        if (BarLineChartFactory.getValue(temp) != null) {
            rangeMin = new Integer(BarLineChartFactory.getValue(temp));
            minDefined = true;
        }
        if (BarLineChartFactory.getValue(temp = this.chartNode.selectSingleNode(LINES_RANGE_MAXIMUM_NODE_LOC)) != null) {
            rangeMax = new Integer(BarLineChartFactory.getValue(temp));
            maxDefined = true;
        }
        if (BarLineChartFactory.getValue(temp = this.chartNode.selectSingleNode(LINES_RANGE_COLOR_NODE_LOC)) != null) {
            rangeColor = BarLineChartFactory.getValue(temp);
        }
        if (BarLineChartFactory.getValue(temp = this.chartNode.selectSingleNode(LINES_RANGE_GRID_COLOR_NODE_LOC)) != null) {
            rangeGridColor = BarLineChartFactory.getValue(temp);
        }
        if (BarLineChartFactory.getValue(temp = this.chartNode.selectSingleNode(LINES_RANGE_STROKE_NODE_LOC)) != null) {
            rangeStroke = Integer.parseInt(BarLineChartFactory.getValue(temp));
        }
        if (BarLineChartFactory.getValue(temp = this.chartNode.selectSingleNode(LINE_RANGE_STEPS_NODE_LOC)) != null) {
            steps = new Integer(BarLineChartFactory.getValue(temp));
        }
        int diff = rangeMax - rangeMin;
        int chunksize = diff / steps;
        Integer stepforchart = null;
        if (chunksize > 0) {
            stepforchart = new Integer(chunksize);
        }
        if (!minDefined) {
            rangeMin = rangeMin >= 0 && rangeMin - chunksize < 0 ? 0 : (rangeMin -= chunksize);
        }
        if (!maxDefined) {
            rangeMax = rangeMin + chunksize * (steps + 2);
        }
        YAxis yaxis = new YAxis();
        yaxis.setRange(Integer.valueOf(rangeMin), Integer.valueOf(rangeMax), stepforchart);
        yaxis.setStroke(Integer.valueOf(rangeStroke));
        yaxis.setColour(rangeColor);
        yaxis.setGridColour(rangeGridColor);
        this.chart.setYAxisRight(yaxis);
    }

    public void createElements() {
        if ("CategoryDataset".equals(this.datasetType)) {
            int columnCount = this.getColumnCount();
            for (int col = 0; col < columnCount; ++col) {
                this.elements.add(this.getBarLineChartFromColumn(col));
            }
        }
    }

    public Element getBarLineChartFromColumn(int col) {
        String text = this.getColumnHeader(col);
        List nodes = this.chartNode.selectNodes(BAR_SERIES_SERIES_NODE_LOC);
        ArrayList<String> bars = new ArrayList<String>();
        for (Object node : nodes) {
            if (BarLineChartFactory.getValue((Node)node) == null) continue;
            bars.add(BarLineChartFactory.getValue((Node)node));
        }
        if (!bars.contains(text)) {
            LineChart lc = this.lineChartFactory.getLineChartFromColumn(col);
            lc.setRightYAxis();
            return lc;
        }
        return this.getVerticalBarChartFromColumn(col);
    }
}

