/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.openflashchart.factory;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Node;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.PentahoDataTransmuter;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.StandaloneSession;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.action.openflashchart.factory.AbstractChartFactory;
import org.pentaho.platform.plugin.action.openflashchart.factory.IChartFactory;

public class PentahoOFC4JChartHelper {
    private static final Log logger = LogFactory.getLog(PentahoOFC4JChartHelper.class);
    private static final String CHART_TYPE_NODE_LOC = "chart-type";
    private static final String CHART_TYPE_DEFAULT = "BarChart";
    private static final String PLUGIN_BUNDLE_NAME = "org.pentaho.platform.plugin.action.openflashchart.factory.chartfactories";
    private static final String SOLUTION_PROPS = "system/openflashchart.properties";
    static Map factories = null;

    public static String generateChartJson(Node chartNode, IPentahoResultSet data, boolean byRow, Log log) {
        String chartType = null;
        String factoryClassString = null;
        try {
            Node temp = chartNode.selectSingleNode(CHART_TYPE_NODE_LOC);
            chartType = AbstractChartFactory.getValue(temp) != null ? AbstractChartFactory.getValue(temp) : CHART_TYPE_DEFAULT;
            factoryClassString = (String)PentahoOFC4JChartHelper.getChartFactories().get(chartType);
            if (factoryClassString == null) {
                throw new RuntimeException(Messages.getErrorString("PentahoOFC4JChartHelper.ERROR_0001_FACTORY_INIT", chartType, factoryClassString));
            }
            Class<?> factoryClass = Class.forName(factoryClassString);
            IChartFactory factory = (IChartFactory)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            factory.setChartNode(chartNode);
            factory.setLog(log);
            if (byRow) {
                factory.setData(PentahoDataTransmuter.pivot((IPentahoResultSet)data));
            } else {
                factory.setData(data);
            }
            return factory.convertToJson();
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("PentahoOFC4JChartHelper.ERROR_0001_FACTORY_INIT", chartType, factoryClassString), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected static Map getChartFactories() {
        if (factories == null) {
            factories = Collections.synchronizedMap(PentahoOFC4JChartHelper.createChartFactoryMap());
        }
        return factories;
    }

    private static Map createChartFactoryMap() {
        Properties chartFactories = new Properties();
        try {
            ResourceBundle pluginBundle = ResourceBundle.getBundle(PLUGIN_BUNDLE_NAME);
            if (pluginBundle != null) {
                Enumeration<String> keyEnum = pluginBundle.getKeys();
                String bundleKey = null;
                while (keyEnum.hasMoreElements()) {
                    bundleKey = keyEnum.nextElement();
                    chartFactories.put(bundleKey, pluginBundle.getString(bundleKey));
                }
            }
        }
        catch (Exception ex) {
            logger.warn((Object)Messages.getString("PentahoOFC4JChartHelper.WARN_NO_CHART_FACTORY_PROPERTIES_BUNDLE"));
        }
        if (PentahoSystem.getObjectFactory() == null || !PentahoSystem.getObjectFactory().objectDefined(ISolutionRepository.class.getSimpleName())) {
            return chartFactories;
        }
        ISolutionRepository solutionRepository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)new StandaloneSession("system"));
        try {
            if (solutionRepository.resourceExists(SOLUTION_PROPS, 1)) {
                InputStream is = solutionRepository.getResourceInputStream(SOLUTION_PROPS, false, 1);
                Properties overrideChartFactories = new Properties();
                overrideChartFactories.load(is);
                chartFactories.putAll((Map<?, ?>)overrideChartFactories);
            }
        }
        catch (FileNotFoundException ignored) {
            logger.warn((Object)Messages.getString("PentahoOFC4JChartHelper.WARN_NO_CHART_FACTORY_PROPERTIES"));
        }
        catch (IOException ignored) {
            logger.warn((Object)Messages.getString("PentahoOFC4JChartHelper.WARN_BAD_CHART_FACTORY_PROPERTIES"), (Throwable)ignored);
        }
        return chartFactories;
    }
}

