/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.sql;

import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.IActionDefinition;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.actions.AbstractRelationalDbAction;
import org.pentaho.actionsequence.dom.actions.SqlConnectionAction;
import org.pentaho.commons.connection.IPentahoConnection;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.PentahoDataTransmuter;
import org.pentaho.commons.connection.memory.MemoryMetaData;
import org.pentaho.platform.api.data.IDataComponent;
import org.pentaho.platform.api.data.IPreparedComponent;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IParameterResolver;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.engine.services.connection.PentahoConnectionFactory;
import org.pentaho.platform.engine.services.runtime.TemplateUtil;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.services.connections.sql.SQLConnection;

public abstract class SQLBaseComponent
extends ComponentBase
implements IDataComponent,
IPreparedComponent,
IParameterResolver {
    public static final String PREPARE_PARAMETER_PREFIX = "PREPARE";
    protected String preparedQuery = null;
    protected List preparedParameters = new ArrayList();
    protected boolean connectionOwner = true;
    private IPentahoResultSet rSet;
    protected IPentahoConnection connection;
    private int timeout = -1;
    private int maxRows = -1;
    private boolean readOnly = false;

    public abstract boolean validateSystemSettings();

    public abstract String getResultOutputName();

    public abstract Log getLogger();

    public IPentahoResultSet getResultSet() {
        return this.rSet;
    }

    public boolean validateAction() {
        boolean result = true;
        IActionDefinition actionDefinition = this.getActionDefinition();
        String actionName = this.getActionName();
        if (actionDefinition instanceof AbstractRelationalDbAction) {
            AbstractRelationalDbAction relationalDbAction = (AbstractRelationalDbAction)actionDefinition;
            IActionInput query = relationalDbAction.getQuery();
            IActionInput dbUrl = relationalDbAction.getDbUrl();
            IActionInput jndi = relationalDbAction.getJndi();
            IActionInput sharedConnection = relationalDbAction.getSharedConnection();
            if (query == ActionInputConstant.NULL_INPUT) {
                this.error(Messages.getErrorString("SQLBaseComponent.ERROR_0001_QUERY_NOT_SPECIFIED", actionName));
                result = false;
            }
            if (jndi == ActionInputConstant.NULL_INPUT && dbUrl == ActionInputConstant.NULL_INPUT && sharedConnection == ActionInputConstant.NULL_INPUT) {
                this.error(Messages.getErrorString("SQLBaseComponent.ERROR_0002_CONNECTION_NOT_SPECIFIED", actionName));
                result = false;
            }
        } else if (actionDefinition instanceof SqlConnectionAction) {
            SqlConnectionAction sqlConnectionAction = (SqlConnectionAction)actionDefinition;
            IActionInput dbUrl = sqlConnectionAction.getDbUrl();
            IActionInput jndi = sqlConnectionAction.getJndi();
            if (jndi == ActionInputConstant.NULL_INPUT && dbUrl == ActionInputConstant.NULL_INPUT) {
                this.error(Messages.getErrorString("SQLBaseComponent.ERROR_0002_CONNECTION_NOT_SPECIFIED", actionName));
                result = false;
            }
        } else {
            this.error(Messages.getErrorString("ComponentBase.ERROR_0001_UNKNOWN_ACTION_TYPE", actionDefinition.getElement().asXML()));
            result = false;
        }
        return result;
    }

    public void done() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean executeAction() {
        IActionDefinition actionDefinition = this.getActionDefinition();
        try {
            if (actionDefinition instanceof AbstractRelationalDbAction) {
                IActionOutput actionOutput;
                AbstractRelationalDbAction relationalDbAction = (AbstractRelationalDbAction)actionDefinition;
                IActionInput queryTimeoutInput = relationalDbAction.getQueryTimeout();
                IActionInput maxRowsInput = relationalDbAction.getMaxRows();
                IActionInput readOnlyInput = relationalDbAction.getReadOnly();
                String baseQuery = this.getQuery();
                if (baseQuery == null) {
                    this.error(Messages.getErrorString("SQLBaseComponent.ERROR_0001_QUERY_NOT_SPECIFIED", actionDefinition.getDescription()));
                    return false;
                }
                IPreparedComponent sharedConnection = (IPreparedComponent)relationalDbAction.getSharedConnection().getValue();
                if (readOnlyInput != ActionInputConstant.NULL_INPUT) {
                    this.setReadOnly(readOnlyInput.getBooleanValue());
                }
                if (sharedConnection != null) {
                    this.connectionOwner = false;
                    IPentahoConnection conn = sharedConnection.shareConnection();
                    if (conn == null) {
                        this.error(Messages.getErrorString("IPreparedComponent.ERROR_0002_CONNECTION_NOT_AVAILABLE", this.getActionName()));
                        return false;
                    }
                    if (conn.getDatasourceType() != "SQL") {
                        this.error(Messages.getErrorString("IPreparedComponent.ERROR_0001_INVALID_CONNECTION_TYPE", this.getActionName()));
                        return false;
                    }
                    this.connection = conn;
                } else {
                    this.dispose();
                    this.connection = this.getDatasourceConnection();
                }
                if (this.connection == null) {
                    return false;
                }
                if (relationalDbAction.getOutputPreparedStatement() != null) {
                    this.prepareQuery(baseQuery);
                    actionOutput = relationalDbAction.getOutputPreparedStatement();
                    if (actionOutput == null) return true;
                    actionOutput.setValue((Object)this);
                    return true;
                }
                if (maxRowsInput != ActionInputConstant.NULL_INPUT) {
                    this.setMaxRows(maxRowsInput.getIntValue());
                }
                if (queryTimeoutInput != ActionInputConstant.NULL_INPUT) {
                    this.setQueryTimeout(queryTimeoutInput.getIntValue());
                }
                if (!relationalDbAction.getPerformTransform().getBooleanValue(false)) return this.runQuery(baseQuery, relationalDbAction.getLive().getBooleanValue(false));
                this.runQuery(baseQuery, false);
                this.rSet = PentahoDataTransmuter.crossTab((IPentahoResultSet)this.rSet, (int)(relationalDbAction.getTransformPivotColumn().getIntValue(-1) - 1), (int)(relationalDbAction.getTransformMeasuresColumn().getIntValue(-1) - 1), (int)(relationalDbAction.getTransformSortColumn().getIntValue(0) - 1), (Format)((Format)relationalDbAction.getTransformPivotDataFormat().getValue()), (Format)((Format)relationalDbAction.getTransformSortDataFormat().getValue()), (boolean)relationalDbAction.getTransformOrderOutputColumns().getBooleanValue(false));
                actionOutput = relationalDbAction.getOutputResultSet();
                if (actionOutput == null) return true;
                actionOutput.setValue((Object)this.rSet);
                return true;
            }
            if (!(actionDefinition instanceof SqlConnectionAction)) return false;
            SqlConnectionAction sqlConnectionAction = (SqlConnectionAction)actionDefinition;
            this.dispose();
            this.connection = this.getDatasourceConnection();
            if (this.connection == null) {
                return false;
            }
            IActionOutput actionOutput = sqlConnectionAction.getOutputConnection();
            if (actionOutput == null) return false;
            actionOutput.setValue((Object)this);
            return true;
        }
        catch (Exception e) {
            this.error(Messages.getErrorString("SQLBaseComponent.ERROR_0006_EXECUTE_FAILED", this.getActionName()), e);
        }
        return false;
    }

    protected IPentahoMetaData getMetadata(IPentahoResultSet resultSet, boolean live) {
        if (live) {
            return resultSet.getMetaData();
        }
        Object[][] columnHeaders = resultSet.getMetaData().getColumnHeaders();
        return new MemoryMetaData(columnHeaders, (Object[][])null);
    }

    public IPentahoResultSet executePrepared(Map preparedParams) {
        try {
            if (this.connection == null) {
                this.error(Messages.getErrorString("SQLBaseComponent.ERROR_0007_NO_CONNECTION"));
                return null;
            }
            if (!this.connection.initialized()) {
                this.error(Messages.getErrorString("SQLBaseComponent.ERROR_0007_NO_CONNECTION"));
                return null;
            }
            if (this.preparedQuery == null) {
                this.error(Messages.getErrorString("SQLBaseComponent.ERROR_0001_QUERY_NOT_SPECIFIED", this.getActionName()));
                return null;
            }
            ArrayList copyOfPreparedParameters = new ArrayList(this.preparedParameters);
            String query = TemplateUtil.applyTemplate((String)this.preparedQuery, (IRuntimeContext)this.getRuntimeContext(), (IParameterResolver)new ParamResolver(copyOfPreparedParameters, preparedParams));
            this.dumpQuery(query);
            IPentahoResultSet resultSet = null;
            resultSet = this.preparedParameters.size() > 0 ? this.connection.prepareAndExecuteQuery(query, copyOfPreparedParameters) : this.connection.executeQuery(query);
            if (this.connection instanceof SQLConnection && ((SQLConnection)this.connection).isForcedForwardOnly()) {
                this.warn(Messages.getString("SQLBaseComponent.WARN_FALL_BACK_TO_NONSCROLLABLE"));
            }
            boolean live = true;
            IActionDefinition actionDefinition = this.getActionDefinition();
            if (actionDefinition instanceof AbstractRelationalDbAction) {
                AbstractRelationalDbAction relationalDbAction = (AbstractRelationalDbAction)actionDefinition;
                live = relationalDbAction.getLive().getBooleanValue(false);
            }
            IPentahoResultSet rs = resultSet;
            if (!live) {
                rs = resultSet.memoryCopy();
            }
            this.rSet = rs;
            return rs;
        }
        catch (Exception e) {
            this.error(Messages.getErrorString("SQLBaseComponent.ERROR_0006_EXECUTE_FAILED", this.getActionName()), e);
            return null;
        }
    }

    protected boolean prepareQuery(String rawQuery) {
        try {
            if (this.connection == null) {
                this.error(Messages.getErrorString("SQLBaseComponent.ERROR_0007_NO_CONNECTION"));
                return false;
            }
            if (!this.connection.initialized()) {
                this.error(Messages.getErrorString("SQLBaseComponent.ERROR_0007_NO_CONNECTION"));
                return false;
            }
            this.preparedQuery = rawQuery;
            return true;
        }
        catch (Exception e) {
            this.error(Messages.getErrorString("SQLBaseComponent.ERROR_0006_EXECUTE_FAILED", this.getActionName()), e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runQuery(String rawQuery, boolean live) {
        try {
            if (this.connection == null || !this.connection.initialized()) {
                this.error(Messages.getErrorString("SQLBaseComponent.ERROR_0007_NO_CONNECTION"));
                return false;
            }
            String query = this.applyInputsToFormat(rawQuery);
            SQLConnection sqlConnection = null;
            if (this.connection instanceof SQLConnection) {
                sqlConnection = (SQLConnection)this.connection;
            }
            if (sqlConnection != null) {
                if (this.getQueryTimeout() >= 0) {
                    sqlConnection.setQueryTimeout(this.getQueryTimeout());
                }
                if (this.getMaxRows() >= 0) {
                    sqlConnection.setMaxRows(this.getMaxRows());
                }
                if (this.getReadOnly()) {
                    sqlConnection.setReadOnly(true);
                }
            }
            AbstractRelationalDbAction relationalDbAction = (AbstractRelationalDbAction)this.getActionDefinition();
            IPentahoResultSet resultSet = null;
            boolean isForwardOnly = relationalDbAction.getUseForwardOnlyResultSet().getBooleanValue(false);
            resultSet = this.doQuery(sqlConnection, query, isForwardOnly);
            if (sqlConnection.isForcedForwardOnly()) {
                isForwardOnly = true;
                live = false;
                this.warn(Messages.getString("SQLBaseComponent.WARN_FALL_BACK_TO_NONSCROLLABLE"));
            }
            if (live) {
                this.rSet = resultSet;
                this.preparedParameters.clear();
                if (resultSet != null) {
                    this.getMetadata(resultSet, true);
                    IActionOutput actionOutput = relationalDbAction.getOutputResultSet();
                    if (actionOutput != null) {
                        actionOutput.setValue((Object)resultSet);
                    }
                    return true;
                }
                this.error(Messages.getErrorString("SQLBaseComponent.ERROR_0006_EXECUTE_FAILED", this.getActionName()));
                if (this.connectionOwner) {
                    this.connection.close();
                }
                return false;
            }
            try {
                IPentahoResultSet cachedResultSet;
                this.preparedParameters.clear();
                this.rSet = cachedResultSet = resultSet.memoryCopy();
                IActionOutput actionOutput = relationalDbAction.getOutputResultSet();
                if (actionOutput != null) {
                    actionOutput.setValue((Object)cachedResultSet);
                }
            }
            finally {
                if (this.connectionOwner) {
                    this.connection.close();
                    this.connection = null;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.error(Messages.getErrorString("SQLBaseComponent.ERROR_0006_EXECUTE_FAILED", this.getActionName()), e);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IPentahoResultSet doQuery(SQLConnection sqlConnection, String query, boolean forwardOnlyResultset) throws Exception {
        IPentahoResultSet resultSet = null;
        this.dumpQuery(query);
        if (this.preparedParameters.size() > 0) {
            if (!forwardOnlyResultset) {
                return this.connection.prepareAndExecuteQuery(query, this.preparedParameters);
            }
            if (sqlConnection == null) throw new IllegalStateException(Messages.getErrorString("SQLBaseComponent.ERROR_0008_UNSUPPORTED_CURSOR_TYPE"));
            return sqlConnection.prepareAndExecuteQuery(query, this.preparedParameters, 1003, 1007);
        }
        if (!forwardOnlyResultset) {
            return this.connection.executeQuery(query);
        }
        if (sqlConnection == null) throw new IllegalStateException(Messages.getErrorString("SQLBaseComponent.ERROR_0008_UNSUPPORTED_CURSOR_TYPE"));
        return sqlConnection.executeQuery(query, 1003, 1007);
    }

    public void dispose() {
        this.rSet = null;
        if (this.connectionOwner) {
            if (this.connection != null) {
                this.connection.close();
            }
            this.connection = null;
        }
    }

    public int resolveParameter(String template, String parameter, Matcher parameterMatcher, int copyStart, StringBuffer results) {
        StringTokenizer tokenizer = new StringTokenizer(parameter, ":");
        if (tokenizer.countTokens() == 2) {
            String parameterPrefix = tokenizer.nextToken();
            String inputName = tokenizer.nextToken();
            if (parameterPrefix.equals("PREPARELATER")) {
                if (!this.isDefinedOutput("prepared_component")) {
                    this.error(Messages.getErrorString("IPreparedComponent.ERROR_0003_INVALID_PARAMETER_STATE"));
                    return -1;
                }
                this.preparedParameters.add("prepare-later-placeholder");
                int start = parameterMatcher.start();
                int end = parameterMatcher.end();
                results.append(template.substring(copyStart, start));
                results.append("{PREPARELATER_INTER:" + inputName + "}");
                return end;
            }
            if (parameterPrefix.equals(PREPARE_PARAMETER_PREFIX)) {
                Object parameterValue = TemplateUtil.getSystemInput((String)inputName, (IRuntimeContext)this.getRuntimeContext());
                if (parameterValue == null && this.isDefinedInput(inputName)) {
                    parameterValue = this.getInputValue(inputName);
                }
                if (parameterValue != null) {
                    int start = parameterMatcher.start();
                    int end = parameterMatcher.end();
                    if (start > 0 && end < template.length() && template.charAt(start - 1) == '\'' && template.charAt(end) == '\'') {
                        --start;
                        ++end;
                    }
                    StringBuffer parameterBuffer = new StringBuffer();
                    if (parameterValue instanceof String) {
                        this.preparedParameters.add(parameterValue);
                        parameterBuffer.append('?');
                    } else if (parameterValue instanceof Object[]) {
                        Object[] pObj;
                        for (Object element : pObj = (Object[])parameterValue) {
                            this.preparedParameters.add(element);
                            parameterBuffer.append(parameterBuffer.length() == 0 ? "?" : ",?");
                        }
                    } else if (parameterValue instanceof IPentahoResultSet) {
                        IPentahoResultSet rs = (IPentahoResultSet)parameterValue;
                        IPentahoMetaData md = rs.getMetaData();
                        int columnIdx = -1;
                        columnIdx = md.getColumnCount() == 1 ? 0 : md.getColumnIndex(new String[]{parameter});
                        if (columnIdx < 0) {
                            this.error(Messages.getErrorString("Template.ERROR_0005_COULD_NOT_DETERMINE_COLUMN"));
                            return -1;
                        }
                        int rowCount = rs.getRowCount();
                        Object valueCell = null;
                        for (int i = 0; i < rowCount; ++i) {
                            valueCell = rs.getValueAt(i, columnIdx);
                            this.preparedParameters.add(valueCell);
                            parameterBuffer.append(parameterBuffer.length() == 0 ? "?" : ",?");
                        }
                    } else if (parameterValue instanceof List) {
                        List pObj = (List)parameterValue;
                        for (int i = 0; i < pObj.size(); ++i) {
                            this.preparedParameters.add(pObj.get(i));
                            parameterBuffer.append(parameterBuffer.length() == 0 ? "?" : ",?");
                        }
                    } else {
                        this.preparedParameters.add(parameterValue);
                        parameterBuffer.append('?');
                    }
                    results.append(template.substring(copyStart, start));
                    copyStart = end;
                    results.append(parameterBuffer);
                    return copyStart;
                }
            }
        }
        return -1;
    }

    public IPentahoConnection getDatasourceConnection() {
        int[] timeouts;
        for (int element : timeouts = new int[]{200, 500, 2000}) {
            try {
                IPentahoConnection con = this.getConnection();
                try {
                    con.clearWarnings();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return con;
            }
            catch (Exception ex) {
                this.waitFor(element);
            }
        }
        IPentahoConnection con = this.getConnection();
        try {
            con.clearWarnings();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return con;
    }

    protected void waitFor(int millis) {
        try {
            this.debug(Messages.getString("SQLBaseComponent.DEBUG_WAITING_FOR_CONNECTION", Integer.toString(millis)));
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IPentahoConnection shareConnection() {
        return this.connection;
    }

    protected IPentahoConnection getConnection() {
        return this.getConnection(null);
    }

    protected IPentahoConnection getConnection(IPentahoConnection defaultConnection) {
        IPentahoConnection localConnection = null;
        try {
            String jndiName = null;
            String driver = null;
            String userId = null;
            String password = null;
            String connectionInfo = null;
            if (this.getActionDefinition() instanceof SqlConnectionAction) {
                SqlConnectionAction sqlConnectionAction = (SqlConnectionAction)this.getActionDefinition();
                jndiName = sqlConnectionAction.getJndi().getStringValue();
                driver = sqlConnectionAction.getDriver().getStringValue();
                userId = sqlConnectionAction.getUserId().getStringValue();
                password = sqlConnectionAction.getPassword().getStringValue();
                connectionInfo = sqlConnectionAction.getDbUrl().getStringValue();
            } else if (this.getActionDefinition() instanceof AbstractRelationalDbAction) {
                AbstractRelationalDbAction relationalDbAction = (AbstractRelationalDbAction)this.getActionDefinition();
                jndiName = relationalDbAction.getJndi().getStringValue();
                driver = relationalDbAction.getDriver().getStringValue();
                userId = relationalDbAction.getUserId().getStringValue();
                password = relationalDbAction.getPassword().getStringValue();
                connectionInfo = relationalDbAction.getDbUrl().getStringValue();
            }
            if (jndiName != null) {
                localConnection = PentahoConnectionFactory.getConnection((String)"SQL", (String)jndiName, (IPentahoSession)this.getSession(), (ILogger)this);
            }
            if (localConnection == null && (driver != null || connectionInfo != null)) {
                localConnection = PentahoConnectionFactory.getConnection((String)"SQL", (String)driver, connectionInfo, (String)userId, password, (IPentahoSession)this.getSession(), (ILogger)this);
            }
            if (localConnection == null) {
                if (defaultConnection == null) {
                    this.error(Messages.getErrorString("SQLBaseComponent.ERROR_0005_INVALID_CONNECTION"));
                    return null;
                }
                localConnection = defaultConnection;
            }
            return localConnection;
        }
        catch (Exception e) {
            this.error(Messages.getErrorString("SQLBaseComponent.ERROR_0006_EXECUTE_FAILED", this.getActionName()), e);
            return null;
        }
    }

    public boolean init() {
        return true;
    }

    public int getQueryTimeout() {
        return this.timeout;
    }

    public void setQueryTimeout(int timeInSec) {
        this.timeout = timeInSec;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int value) {
        this.maxRows = value;
    }

    public String getQuery() {
        this.preparedParameters.clear();
        return ((AbstractRelationalDbAction)this.getActionDefinition()).getQuery().getStringValue();
    }

    public void setReadOnly(boolean value) {
        this.readOnly = value;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    private void dumpQuery(String query) {
        if (this.timeout == 0) {
            this.debug(Messages.getString("SQLBaseComponent.DEBUG_RUNNING_QUERY", query));
        } else {
            this.debug(Messages.getString("SQLBaseComponent.DEBUG_RUNNING_QUERY_TIMEOUT", query, "" + this.timeout));
        }
    }

    private class ParamResolver
    implements IParameterResolver {
        List paramList;
        Map lookupMap;

        public ParamResolver(List list, Map map) {
            this.lookupMap = map;
            this.paramList = list;
        }

        public int resolveParameter(String template, String parameter, Matcher parameterMatcher, int copyStart, StringBuffer results) {
            StringTokenizer tokenizer = new StringTokenizer(parameter, ":");
            if (tokenizer.countTokens() == 2) {
                String parameterPrefix = tokenizer.nextToken();
                String inputName = tokenizer.nextToken();
                if (parameterPrefix.equals("PREPARELATER_INTER")) {
                    String parameterValue = TemplateUtil.getSystemInput((String)inputName, (IRuntimeContext)SQLBaseComponent.this.getRuntimeContext());
                    if (parameterValue == null && this.lookupMap != null && this.lookupMap.containsKey(inputName)) {
                        parameterValue = this.lookupMap.get(inputName);
                    }
                    if (parameterValue != null) {
                        int start = parameterMatcher.start();
                        int end = parameterMatcher.end();
                        if (start > 0 && end < template.length() && template.charAt(start - 1) == '\'' && template.charAt(end) == '\'') {
                            --start;
                            ++end;
                        }
                        StringBuffer parameterBuffer = new StringBuffer();
                        int index = this.paramList.indexOf("prepare-later-placeholder");
                        this.paramList.remove(index);
                        if (parameterValue instanceof String) {
                            this.paramList.add(index, parameterValue);
                            parameterBuffer.append('?');
                        } else if (parameterValue instanceof Object[]) {
                            Object[] pObj;
                            for (Object element : pObj = (Object[])parameterValue) {
                                this.paramList.add(index++, element);
                                parameterBuffer.append(parameterBuffer.length() == 0 ? "?" : ",?");
                            }
                        } else if (parameterValue instanceof IPentahoResultSet) {
                            IPentahoResultSet rs = (IPentahoResultSet)parameterValue;
                            IPentahoMetaData md = rs.getMetaData();
                            int columnIdx = -1;
                            columnIdx = md.getColumnCount() == 1 ? 0 : md.getColumnIndex(new String[]{parameter});
                            if (columnIdx < 0) {
                                SQLBaseComponent.this.error(Messages.getErrorString("Template.ERROR_0005_COULD_NOT_DETERMINE_COLUMN"));
                                return -1;
                            }
                            int rowCount = rs.getRowCount();
                            Object valueCell = null;
                            for (int i = 0; i < rowCount; ++i) {
                                valueCell = rs.getValueAt(i, columnIdx);
                                this.paramList.add(index++, valueCell);
                                parameterBuffer.append(parameterBuffer.length() == 0 ? "?" : ",?");
                            }
                        } else if (parameterValue instanceof List) {
                            List pObj = (List)((Object)parameterValue);
                            for (int i = 0; i < pObj.size(); ++i) {
                                this.paramList.add(index++, pObj.get(i));
                                parameterBuffer.append(parameterBuffer.length() == 0 ? "?" : ",?");
                            }
                        } else {
                            this.paramList.add(index, parameterValue);
                            parameterBuffer.append('?');
                        }
                        results.append(template.substring(copyStart, start));
                        copyStart = end;
                        results.append(parameterBuffer);
                        return copyStart;
                    }
                }
            }
            return -1;
        }
    }
}

