/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.xmla;

import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.memory.MemoryMetaData;
import org.pentaho.commons.connection.memory.MemoryResultSet;
import org.pentaho.platform.api.data.IDataComponent;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.action.xmla.XMLAException;

public abstract class XMLABaseComponent
extends ComponentBase
implements IDataComponent {
    private static final long serialVersionUID = 8405489984774339891L;
    private static final String MDD_URI = "urn:schemas-microsoft-com:xml-analysis:mddataset";
    private static final String ROWS_URI = "urn:schemas-microsoft-com:xml-analysis:rowset";
    private static final String XMLA_URI = "urn:schemas-microsoft-com:xml-analysis";
    private static final String EXECUTE_ACTION = "\"urn:schemas-microsoft-com:xml-analysis:Execute\"";
    private static final String ENCODING_STYLE = "http://schemas.xmlsoap.org/soap/encoding/";
    private static final String URI = "uri";
    private static final String USER = "user-id";
    private static final String PASSWORD = "password";
    private static final String CATALOG = "catalog";
    private static final String QUERY = "query";
    private static final int AXIS_COLUMNS = 0;
    private static final int AXIS_ROWS = 1;
    private IPentahoResultSet rSet;
    private SOAPConnectionFactory scf = null;
    private MessageFactory mf = null;
    private URL url = null;
    private int provider = 0;
    private String dataSource = null;
    public static final int PROVIDER_MICROSOFT = 1;
    public static final int PROVIDER_SAP = 2;
    public static final int PROVIDER_MONDRIAN = 3;
    public static final int PROVIDER_ESSBASE = 4;

    public abstract boolean validateSystemSettings();

    public abstract String getResultOutputName();

    public abstract Log getLogger();

    public IPentahoResultSet getResultSet() {
        return this.rSet;
    }

    protected boolean validateAction() {
        try {
            if (!this.isDefinedInput(URI)) {
                this.error(Messages.getErrorString("XMLABaseComponent.ERROR_0001_CONNECTION_NOT_SPECIFIED", this.getActionName()));
                return false;
            }
            if (!this.isDefinedInput(USER)) {
                this.error(Messages.getErrorString("XMLABaseComponent.ERROR_0002_USER_NOT_SPECIFIED", this.getActionName()));
                return false;
            }
            if (!this.isDefinedInput(PASSWORD)) {
                this.error(Messages.getErrorString("XMLABaseComponent.ERROR_0003_PASSWORD_NOT_SPECIFIED", this.getActionName()));
                return false;
            }
            if (!this.isDefinedInput(CATALOG)) {
                this.error(Messages.getErrorString("XMLABaseComponent.ERROR_0004_CATALOG_NOT_SPECIFIED", this.getActionName()));
                return false;
            }
            if (!this.isDefinedInput(QUERY)) {
                this.error(Messages.getErrorString("XMLABaseComponent.ERROR_0005_QUERY_NOT_SPECIFIED", this.getActionName()));
                return false;
            }
            String outputName = this.getResultOutputName();
            if (outputName != null && !this.getOutputNames().contains(outputName)) {
                this.error(Messages.getErrorString("XMLABaseComponent.ERROR_0006_OUTPUT_NOT_SPECIFIED", this.getActionName()));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.error(Messages.getErrorString("XMLABaseComponent.ERROR_0007_VALIDATION_FAILED", this.getActionName()), e);
            return false;
        }
    }

    public void done() {
    }

    protected boolean executeAction() {
        try {
            this.scf = SOAPConnectionFactory.newInstance();
            this.mf = MessageFactory.newInstance();
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        String uri = this.getInputStringValue(URI);
        String user = this.getInputStringValue(USER);
        String password = this.getInputStringValue(PASSWORD);
        String catalog = this.getInputStringValue(CATALOG);
        String query = this.getInputStringValue(QUERY);
        this.buildURl(uri, user, password);
        try {
            this.setProviderAndDataSource(this.discoverDS());
            return this.executeQuery(query, catalog);
        }
        catch (XMLAException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void buildURl(String uri, String user, String password) {
        try {
            this.url = new URL(uri);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (user != null && user.length() > 0) {
            String newUri = this.url.getProtocol() + "://" + user;
            if (password != null && password.length() > 0) {
                newUri = newUri + ":" + password;
            }
            newUri = newUri + "@" + this.url.getHost() + ":" + this.url.getPort() + this.url.getPath();
            try {
                this.url = new URL(newUri);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean executeQuery(String query, String catalog) throws XMLAException {
        Object[][] columnHeaders = null;
        Object[][] rowHeaders = null;
        Object[][] data = null;
        int columnCount = 0;
        int rowCount = 0;
        SOAPConnection connection = null;
        SOAPMessage reply = null;
        try {
            connection = this.scf.createConnection();
            SOAPMessage msg = this.mf.createMessage();
            MimeHeaders mh = msg.getMimeHeaders();
            mh.setHeader("SOAPAction", EXECUTE_ACTION);
            SOAPPart soapPart = msg.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            envelope.setEncodingStyle(ENCODING_STYLE);
            SOAPBody body = envelope.getBody();
            Name nEx = envelope.createName("Execute", "", XMLA_URI);
            SOAPElement eEx = body.addChildElement(nEx);
            eEx.setEncodingStyle(ENCODING_STYLE);
            Name nCom = envelope.createName("Command", "", XMLA_URI);
            SOAPElement eCommand = eEx.addChildElement(nCom);
            Name nSta = envelope.createName("Statement", "", XMLA_URI);
            SOAPElement eStatement = eCommand.addChildElement(nSta);
            eStatement.addTextNode(query);
            HashMap<String, String> paraList = new HashMap<String, String>();
            paraList.put("DataSourceInfo", this.dataSource);
            paraList.put("Catalog", catalog);
            paraList.put("Format", "Multidimensional");
            paraList.put("AxisFormat", "TupleFormat");
            this.addParameterList(envelope, eEx, "Properties", "PropertyList", paraList);
            msg.saveChanges();
            this.debug("Request for Execute");
            this.logSoapMsg(msg);
            reply = connection.call(msg, (Object)this.url);
            this.debug("Reply from Execute");
            this.logSoapMsg(reply);
            this.errorCheck(reply);
            SOAPElement eRoot = this.findExecRoot(reply);
            Name name = envelope.createName("Axes", "", MDD_URI);
            SOAPElement eAxes = this.selectSingleNode(eRoot, name);
            if (eAxes == null) {
                throw new XMLAException("Excecute result has no Axes element");
            }
            name = envelope.createName("Axis", "", MDD_URI);
            Iterator itAxis = eAxes.getChildElements(name);
            int iOrdinal = 0;
            while (itAxis.hasNext()) {
                SOAPElement eAxis = (SOAPElement)itAxis.next();
                String axisName = eAxis.getAttributeValue(name = envelope.createName("name"));
                if (axisName.equals("SlicerAxis")) continue;
                int axisOrdinal = iOrdinal++;
                name = envelope.createName("Tuples", "", MDD_URI);
                SOAPElement eTuples = this.selectSingleNode(eAxis, name);
                if (eTuples == null) continue;
                name = envelope.createName("Tuple", "", MDD_URI);
                Iterator itTuple = eTuples.getChildElements(name);
                int positionOrdinal = 0;
                while (itTuple.hasNext()) {
                    SOAPElement eTuple = (SOAPElement)itTuple.next();
                    if (axisOrdinal == 0 && columnHeaders == null) {
                        columnCount = this.getChildCount(envelope, eTuples, "Tuple");
                        columnHeaders = new Object[this.getChildCount(envelope, eTuple, "Member")][columnCount];
                    } else if (axisOrdinal == 1 && rowHeaders == null) {
                        rowCount = this.getChildCount(envelope, eTuples, "Tuple");
                        rowHeaders = new Object[rowCount][this.getChildCount(envelope, eTuple, "Member")];
                    }
                    int index = 0;
                    name = envelope.createName("Member", "", MDD_URI);
                    Iterator itMember = eTuple.getChildElements(name);
                    while (itMember.hasNext()) {
                        SOAPElement eMem = (SOAPElement)itMember.next();
                        String caption = null;
                        Iterator it = eMem.getChildElements();
                        while (it.hasNext()) {
                            SOAPElement el;
                            String enam;
                            Node n = (Node)it.next();
                            if (!(n instanceof SOAPElement) || !(enam = (el = (SOAPElement)n).getElementName().getLocalName()).equals("Caption")) continue;
                            caption = el.getValue();
                        }
                        if (axisOrdinal == 0) {
                            columnHeaders[index][positionOrdinal] = caption;
                        } else if (axisOrdinal == 1) {
                            rowHeaders[positionOrdinal][index] = caption;
                        }
                        ++index;
                    }
                    ++positionOrdinal;
                }
            }
            data = new Object[rowCount][columnCount];
            name = envelope.createName("CellData", "", MDD_URI);
            SOAPElement eCellData = this.selectSingleNode(eRoot, name);
            name = envelope.createName("Cell", "", MDD_URI);
            Iterator itSoapCell = eCellData.getChildElements(name);
            while (itSoapCell.hasNext()) {
                SOAPElement eCell = (SOAPElement)itSoapCell.next();
                name = envelope.createName("CellOrdinal", "", "");
                String cellOrdinal = eCell.getAttributeValue(name);
                int ordinal = Integer.parseInt(cellOrdinal);
                name = envelope.createName("Value", "", MDD_URI);
                String value = this.selectSingleNode(eCell, name).getValue();
                int rowLoc = ordinal / columnCount;
                int columnLoc = ordinal % columnCount;
                data[rowLoc][columnLoc] = value;
            }
            MemoryResultSet resultSet = new MemoryResultSet();
            MemoryMetaData metaData = new MemoryMetaData(columnHeaders, rowHeaders);
            resultSet.setMetaData((IPentahoMetaData)metaData);
            for (Object[] element : data) {
                resultSet.addRow(element);
            }
            this.rSet = resultSet;
            if (resultSet != null) {
                if (this.getResultOutputName() != null) {
                    this.setOutputValue(this.getResultOutputName(), resultSet);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SOAPException se) {
            throw new XMLAException(se);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SOAPException e) {
                    this.error("?", e);
                }
            }
        }
    }

    private int getChildCount(SOAPEnvelope envelope, SOAPElement element, String childName) throws SOAPException {
        Name name = envelope.createName(childName, "", MDD_URI);
        Iterator iter = element.getChildElements(name);
        int value = 0;
        while (iter.hasNext()) {
            ++value;
            iter.next();
        }
        return value;
    }

    private void setProviderAndDataSource(Map resMap) throws XMLAException {
        if (resMap == null || resMap.size() == 0) {
            this.error(Messages.getString("XMLABaseComponent.ERROR_0008_NO_RESOURCE_MAP"));
            throw new XMLAException(Messages.getString("XMLABaseComponent.ERROR_0008_NO_RESOURCE_MAP"));
        }
        String pstr = (String)resMap.get("ProviderName");
        if (pstr == null) {
            throw new XMLAException(Messages.getString("XMLABaseComponent.ERROR_0009_NO_PROVIDER_NAME"));
        }
        this.provider = this.determineProvider("Provider=" + pstr);
        this.debug(Messages.getString("XMLABaseComponent.DEBUG_0001_PROVIDER_ID") + this.provider);
        this.debug(Messages.getString("XMLABaseComponent.DEBUG_0002_DATASOURCE_NAME") + String.valueOf(resMap.get("DataSourceName")));
        this.debug(Messages.getString("XMLABaseComponent.DEBUG_0003_DATASOURCE_INFO") + String.valueOf(resMap.get("DataSourceInfo")));
        this.dataSource = (String)resMap.get("DataSourceInfo");
        if (this.dataSource == null || this.dataSource.length() < 1) {
            this.dataSource = (String)resMap.get("DataSourceName");
        }
        if (this.dataSource == null) {
            throw new XMLAException(Messages.getString("XMLABaseComponent.ERROR_0010_NO_DATASOURCE_NAME"));
        }
        this.debug(Messages.getString("XMLABaseComponent.DEBUG_0004_DISCOVER_DATASOURCE_SET") + this.dataSource);
    }

    public Map discoverDS() throws XMLAException {
        HashMap rHash = new HashMap();
        HashMap<String, String> pHash = new HashMap<String, String>();
        pHash.put("Content", "Data");
        final HashMap resultMap = new HashMap();
        Rowhandler rh = new Rowhandler(){

            public void handleRow(SOAPElement eRow, SOAPEnvelope envelope) {
                Iterator it = eRow.getChildElements();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement e = (SOAPElement)o;
                    String name = e.getElementName().getLocalName();
                    String value = e.getValue();
                    resultMap.put(name, value);
                }
            }
        };
        this.discover("DISCOVER_DATASOURCES", this.url, rHash, pHash, rh);
        this.debug(Messages.getString("XMLABaseComponent.DEBUG_0005_DISCOVER_DATASOURCE_FOUND") + resultMap.size());
        return resultMap;
    }

    private void discover(String request, URL discoverUrl, Map restrictions, Map properties, Rowhandler rh) throws XMLAException {
        try {
            SOAPConnection connection = this.scf.createConnection();
            SOAPMessage msg = this.mf.createMessage();
            MimeHeaders mh = msg.getMimeHeaders();
            mh.setHeader("SOAPAction", "\"urn:schemas-microsoft-com:xml-analysis:Discover\"");
            SOAPPart soapPart = msg.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            envelope.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            envelope.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
            SOAPBody body = envelope.getBody();
            Name nDiscover = envelope.createName("Discover", "", XMLA_URI);
            SOAPElement eDiscover = body.addChildElement(nDiscover);
            eDiscover.setEncodingStyle(ENCODING_STYLE);
            Name nPara = envelope.createName("RequestType", "", XMLA_URI);
            SOAPElement eRequestType = eDiscover.addChildElement(nPara);
            eRequestType.addTextNode(request);
            if (restrictions != null) {
                this.addParameterList(envelope, eDiscover, "Restrictions", "RestrictionList", restrictions);
            }
            this.addParameterList(envelope, eDiscover, "Properties", "PropertyList", properties);
            msg.saveChanges();
            this.debug(Messages.getString("XMLABaseComponent.DEBUG_0006_DISCOVER_REQUEST") + request);
            this.logSoapMsg(msg);
            SOAPMessage reply = connection.call(msg, (Object)discoverUrl);
            this.debug(Messages.getString("XMLABaseComponent.DEBUG_0007_DISCOVER_RESPONSE") + request);
            this.logSoapMsg(reply);
            this.errorCheck(reply);
            SOAPElement eRoot = this.findDiscoverRoot(reply);
            Name nRow = envelope.createName("row", "", ROWS_URI);
            Iterator itRow = eRoot.getChildElements(nRow);
            while (itRow.hasNext()) {
                SOAPElement eRow = (SOAPElement)itRow.next();
                rh.handleRow(eRow, envelope);
            }
            connection.close();
        }
        catch (UnsupportedOperationException e) {
            throw new XMLAException(e);
        }
        catch (SOAPException e) {
            throw new XMLAException(e);
        }
    }

    private void addParameterList(SOAPEnvelope envelope, SOAPElement eParent, String typeName, String listName, Map params) throws SOAPException {
        Name nPara = envelope.createName(typeName, "", XMLA_URI);
        SOAPElement eType = eParent.addChildElement(nPara);
        nPara = envelope.createName(listName, "", XMLA_URI);
        SOAPElement eList = eType.addChildElement(nPara);
        if (params == null) {
            return;
        }
        for (String tag : params.keySet()) {
            String value = (String)params.get(tag);
            nPara = envelope.createName(tag, "", XMLA_URI);
            SOAPElement eTag = eList.addChildElement(nPara);
            eTag.addTextNode(value);
        }
    }

    private SOAPElement findExecRoot(SOAPMessage reply) throws SOAPException, XMLAException {
        Name name;
        SOAPPart sp = reply.getSOAPPart();
        SOAPEnvelope envelope = sp.getEnvelope();
        SOAPBody body = envelope.getBody();
        SOAPElement eResponse = this.selectSingleNode((SOAPElement)body, name = envelope.createName("ExecuteResponse", "m", XMLA_URI));
        if (eResponse == null) {
            throw new XMLAException(Messages.getString("XMLABaseComponent.ERROR_0011_NO_EXECUTE_RESPONSE_ELEMENT"));
        }
        name = envelope.createName("return", "m", XMLA_URI);
        SOAPElement eReturn = this.selectSingleNode(eResponse, name);
        SOAPElement eRoot = this.selectSingleNode(eReturn, name = envelope.createName("root", "", MDD_URI));
        if (eRoot == null) {
            throw new XMLAException(Messages.getString("XMLABaseComponent.ERROR_0012_NO_RESPONSE_ROOT_ELEMENT"));
        }
        return eRoot;
    }

    private SOAPElement findDiscoverRoot(SOAPMessage reply) throws SOAPException, XMLAException {
        SOAPElement eReturn;
        SOAPPart sp = reply.getSOAPPart();
        SOAPEnvelope envelope = sp.getEnvelope();
        SOAPBody body = envelope.getBody();
        SOAPElement eResponse = null;
        if (this.provider == 0) {
            Iterator itBody = body.getChildElements();
            while (itBody.hasNext()) {
                Name name;
                Node n = (Node)itBody.next();
                if (!(n instanceof SOAPElement) || !(name = ((SOAPElement)n).getElementName()).getLocalName().equals("DiscoverResponse")) continue;
                eResponse = (SOAPElement)n;
                this.provider = this.getProviderFromDiscoverResponse(envelope, eResponse);
                break;
            }
            if (eResponse == null) {
                throw new XMLAException(Messages.getString("XMLABaseComponent.ERROR_0013_NO_DISCOVER_RESPONSE"));
            }
        } else {
            Name childName;
            if (this.provider == 1 || this.provider == 4) {
                childName = envelope.createName("DiscoverResponse", "m", XMLA_URI);
            } else if (this.provider == 2 || this.provider == 3) {
                childName = envelope.createName("DiscoverResponse", "", XMLA_URI);
            } else {
                throw new IllegalArgumentException(Messages.getString("XMLABaseComponent.ERROR_0014_NO_PROVIDER_SPEC"));
            }
            eResponse = this.selectSingleNode((SOAPElement)body, childName);
            if (eResponse == null) {
                throw new XMLAException(Messages.getString("XMLABaseComponent.ERROR_0015_NO_DISCOVER_RESPONSE_ELEMENT"));
            }
        }
        if ((eReturn = this.getDiscoverReturn(envelope, eResponse)) == null) {
            throw new XMLAException(Messages.getString("XMLABaseComponent.ERROR_0016_NO_RESULT_RETURN_ELEMENT"));
        }
        SOAPElement eRoot = this.getDiscoverRoot(envelope, eReturn);
        if (eRoot == null) {
            throw new XMLAException(Messages.getString("XMLABaseComponent.ERROR_0017_NO_RESULT_ROOT_ELEMENT"));
        }
        return eRoot;
    }

    private int getProviderFromDiscoverResponse(SOAPEnvelope envelope, SOAPElement e) throws XMLAException, SOAPException {
        Name name = e.getElementName();
        if (!name.getLocalName().equals("DiscoverResponse")) {
            throw new XMLAException(Messages.getString("XMLABaseComponent.ERROR_0018_NOT_A_DISCOVER_RESPONSE") + name.getLocalName());
        }
        SOAPElement walker = this.getDiscoverReturn(envelope, e);
        if (walker == null) {
            throw new XMLAException(Messages.getString("XMLABaseComponent.ERROR_0019_NO_RESULT_DISCOVER_RESPONSE"));
        }
        if ((walker = this.getDiscoverRoot(envelope, walker)) == null) {
            throw new XMLAException(Messages.getString("XMLABaseComponent.ERROR_0020_NO_RESULT_DISCOVER_RETURN_ROOT"));
        }
        if ((walker = this.getDiscoverRow(envelope, walker)) == null) {
            throw new XMLAException(Messages.getString("XMLABaseComponent.ERROR_0021_NO_DISCOVER_RESPONSE_ROW"));
        }
        String value = null;
        Iterator it = walker.getChildElements();
        while (it.hasNext()) {
            SOAPElement e2;
            String nameString;
            Object o = it.next();
            if (!(o instanceof SOAPElement) || !(nameString = (e2 = (SOAPElement)o).getElementName().getLocalName()).equals("ProviderName")) continue;
            value = e2.getValue();
            this.debug(Messages.getString("XMLABaseComponent.DEBUG_0008_FOUND_PROVIDER") + value);
            break;
        }
        if (value == null || value.trim().length() == 0) {
            throw new XMLAException(Messages.getString("XMLABaseComponent.ERROR_0022_NO_PROVIDER_NAME_ELEMENT"));
        }
        return this.determineProvider("Provider=" + value);
    }

    private int determineProvider(String dataSourceString) throws XMLAException {
        this.debug(Messages.getString("XMLABaseComponent.DEBUG_0009_DETERMINE_PROVIDER") + dataSourceString);
        if (dataSourceString == null) {
            throw new XMLAException(Messages.getString("XMLABaseComponent.ERROR_0023_NO_DATASOURCE_GIVEN"));
        }
        String upperDSString = dataSourceString.toUpperCase();
        if (!upperDSString.startsWith("PROVIDER=")) {
            throw new XMLAException(Messages.getString("XMLABaseComponent.ERROR_0024_MALFORMED_DATASOURCE"));
        }
        if (upperDSString.startsWith("PROVIDER=SAP")) {
            this.debug(Messages.getString("XMLABaseComponent.DEBUG_0009_SAP_PROVIDER"));
            return 2;
        }
        if (upperDSString.startsWith("PROVIDER=MONDRIAN")) {
            this.debug(Messages.getString("XMLABaseComponent.DEBUG_0010_MONDRIAN_PROVIDER"));
            return 3;
        }
        if (upperDSString.startsWith("PROVIDER=MS")) {
            this.debug(Messages.getString("XMLABaseComponent.DEBUG_0011_MICROSOFT_PROVIDER"));
            return 1;
        }
        if (upperDSString.startsWith("PROVIDER=MICROSOFT")) {
            this.debug(Messages.getString("XMLABaseComponent.DEBUG_0011_MICROSOFT_PROVIDER"));
            return 1;
        }
        if (upperDSString.startsWith("PROVIDER=ESSBASE")) {
            this.debug(Messages.getString("XMLABaseComponent.DEBUG_0012_ESSBASE_PROVIDER"));
            return 4;
        }
        this.error(Messages.getString("XMLABaseComponent.ERROR_0023_CANNOT_DETERMINE_PROVIDER") + dataSourceString);
        throw new XMLAException(Messages.getString("XMLABaseComponent.ERROR_0024_UNSUPPORTED_PROVIDER"));
    }

    private SOAPElement getDiscoverReturn(SOAPEnvelope envelope, SOAPElement e) throws XMLAException, SOAPException {
        Name nReturn = this.provider == 1 || this.provider == 4 ? envelope.createName("return", "m", XMLA_URI) : envelope.createName("return", "", XMLA_URI);
        SOAPElement eReturn = this.selectSingleNode(e, nReturn);
        if (eReturn == null && (eReturn = this.selectSingleNode(e, nReturn = envelope.createName("return", "", ""))) == null) {
            throw new XMLAException(Messages.getString("XMLABaseComponent.ERROR_0025_NO_RETURN_DISCOVER_ELEMENT"));
        }
        return eReturn;
    }

    private SOAPElement getDiscoverRoot(SOAPEnvelope envelope, SOAPElement e) throws XMLAException, SOAPException {
        Name nRoot = envelope.createName("root", "", ROWS_URI);
        SOAPElement eRoot = this.selectSingleNode(e, nRoot);
        if (eRoot == null) {
            throw new XMLAException(Messages.getString("XMLABaseComponent.ERROR_0026_NO_ROOT_DISCOVER_ELEMENT"));
        }
        return eRoot;
    }

    private SOAPElement getDiscoverRow(SOAPEnvelope envelope, SOAPElement e) throws XMLAException, SOAPException {
        Name nRow = envelope.createName("row", "", ROWS_URI);
        SOAPElement eRow = this.selectSingleNode(e, nRow);
        if (eRow == null) {
            throw new XMLAException(Messages.getString("XMLABaseComponent.ERROR_0027_NO_DISCOVER_ROW_ELEMENT"));
        }
        return eRow;
    }

    private void errorCheck(SOAPMessage reply) throws SOAPException, XMLAException {
        String[] strings = new String[4];
        if (this.soapFault(reply, strings)) {
            String faultString = "Soap Fault code=" + strings[0] + " fault string=" + strings[1] + " fault actor=" + strings[2];
            if (strings[3] != null) {
                faultString = faultString + "\ndetail:" + strings[3];
            }
            throw new XMLAException(faultString);
        }
    }

    private boolean soapFault(SOAPMessage reply, String[] faults) throws SOAPException {
        SOAPPart sp = reply.getSOAPPart();
        SOAPEnvelope envelope = sp.getEnvelope();
        SOAPBody body = envelope.getBody();
        if (!body.hasFault()) {
            return false;
        }
        SOAPFault fault = body.getFault();
        faults[0] = fault.getFaultCode();
        faults[1] = fault.getFaultString();
        faults[2] = fault.getFaultActor();
        Detail detail = fault.getDetail();
        if (detail == null) {
            return true;
        }
        String detailMsg = "";
        Iterator it = detail.getDetailEntries();
        while (it.hasNext()) {
            DetailEntry det = (DetailEntry)it.next();
            Iterator ita = det.getAllAttributes();
            boolean cont = false;
            while (ita.hasNext()) {
                Name name = (Name)ita.next();
                if (cont) {
                    detailMsg = detailMsg + "; ";
                }
                detailMsg = detailMsg + name.getLocalName();
                detailMsg = detailMsg + " = ";
                detailMsg = detailMsg + det.getAttributeValue(name);
                cont = true;
            }
        }
        faults[3] = detailMsg;
        return true;
    }

    private SOAPElement selectSingleNode(SOAPElement contextNode, Name childName) {
        Iterator it = contextNode.getChildElements(childName);
        if (it.hasNext()) {
            return (SOAPElement)it.next();
        }
        return null;
    }

    private void logSoapMsg(SOAPMessage msg) {
        try {
            StringWriter writer = new StringWriter();
            TransformerFactory tFact = TransformerFactory.newInstance();
            Transformer transformer = tFact.newTransformer();
            Source src = msg.getSOAPPart().getContent();
            StreamResult result = new StreamResult(writer);
            transformer.transform(src, result);
            this.debug(((Object)writer).toString());
        }
        catch (Exception e) {
            this.error("?", e);
        }
    }

    public void dispose() {
    }

    public boolean init() {
        return true;
    }

    static interface Rowhandler {
        public void handleRow(SOAPElement var1, SOAPEnvelope var2);
    }
}

