/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.cdf.CdfSettings;
import org.pentaho.cdf.InvalidCdfOperationException;
import org.pentaho.cdf.Messages;
import org.pentaho.cdf.NavigateComponent;
import org.pentaho.cdf.ServiceCallAction;
import org.pentaho.cdf.comments.CommentsEngine;
import org.pentaho.cdf.export.Export;
import org.pentaho.cdf.export.ExportCSV;
import org.pentaho.cdf.export.ExportExcel;
import org.pentaho.cdf.localization.MessageBundlesHelper;
import org.pentaho.cdf.storage.StorageEngine;
import org.pentaho.cdf.utils.CdfAuditHelper;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IMimeTypeListener;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.api.engine.IUITemplater;
import org.pentaho.platform.api.engine.IUserDetailsRoleListService;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.actionsequence.ActionResource;
import org.pentaho.platform.engine.services.solution.BaseContentGenerator;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.web.MimeHelper;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import pt.webdetails.packager.Packager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CdfContentGenerator
extends BaseContentGenerator {
    private static final long serialVersionUID = 5608691656289862706L;
    private static final Log logger = LogFactory.getLog(CdfContentGenerator.class);
    public static final String PLUGIN_NAME = "pentaho-cdf";
    private static final String MIMETYPE = "text/html";
    public static final String SOLUTION_DIR = "cdf";
    private static final String RENDER_HTML = "/RenderHTML";
    private static final String RENDER_XCDF = "/RenderXCDF";
    private static final String JSON_SOLUTION = "/JSONSolution";
    private static final String GET_CDF_RESOURCE = "/GetCDFResource";
    private static final String EXPORT = "/Export";
    private static final String SETTINGS = "/Settings";
    private static final String CALLACTION = "/CallAction";
    private static final String COMMENTS = "/Comments";
    private static final String STORAGE = "/Storage";
    private static final String GETHEADERS = "/GetHeaders";
    private static final String CONTEXT = "/Context";
    private static final String MIME_HTML = "text/html";
    private static final String MIME_CSS = "text/css";
    private static final String MIME_JS = "text/javascript";
    private static final String MIME_PLAIN = "text/plain";
    private static final String MIME_CSV = "text/csv";
    private static final String MIME_XLS = "application/vnd.ms-excel";
    private static final String RELATIVE_URL_TAG = "@RELATIVE_URL@";
    public String RELATIVE_URL;
    private Packager packager;
    public static String ENCODING = "UTF-8";

    public CdfContentGenerator() {
        try {
            this.init();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to initialize CDF");
        }
    }

    public void createContent() throws Exception {
        logger.info((Object)("CDF content generator took over: " + Long.toString(new Date().getTime())));
        try {
            String payload;
            String method;
            OutputStream out;
            IContentItem contentItem;
            if (this.parameterProviders.get("path") != null && ((IParameterProvider)this.parameterProviders.get("path")).getParameter("httprequest") != null && ((HttpServletRequest)((IParameterProvider)this.parameterProviders.get("path")).getParameter("httprequest")).getContextPath() != null) {
                this.RELATIVE_URL = ((HttpServletRequest)((IParameterProvider)this.parameterProviders.get("path")).getParameter("httprequest")).getContextPath();
            } else {
                Object context;
                Method getContextPath;
                this.RELATIVE_URL = CdfContentGenerator.getBaseUrl();
                if (("".equals(this.RELATIVE_URL) || this.RELATIVE_URL.matches("^http://.*")) && (getContextPath = (context = PentahoSystem.getApplicationContext().getContext()).getClass().getMethod("getContextPath", null)) != null) {
                    this.RELATIVE_URL = getContextPath.invoke(context, null).toString();
                }
            }
            if (this.RELATIVE_URL.endsWith("/")) {
                this.RELATIVE_URL = this.RELATIVE_URL.substring(0, this.RELATIVE_URL.length() - 1);
            }
            if (this.callbacks != null && this.callbacks.size() > 0 && HashMap.class.isInstance(this.callbacks.get(0))) {
                HashMap iface = (HashMap)this.callbacks.get(0);
                IParameterProvider pathParams = (IParameterProvider)this.parameterProviders.get("path");
                contentItem = this.outputHandler.getOutputContentItem("response", "content", "", this.instanceId, "text/html");
                out = (OutputStream)iface.get("output");
                method = "/" + (String)iface.get("method");
                payload = (String)iface.get("payload");
                this.userSession = this.userSession != null ? this.userSession : (IPentahoSession)iface.get("usersession");
            } else {
                IParameterProvider pathParams = (IParameterProvider)this.parameterProviders.get("path");
                contentItem = this.outputHandler.getOutputContentItem("response", "content", "", this.instanceId, "text/html");
                out = contentItem.getOutputStream(null);
                method = pathParams.getStringParameter("path", null);
                payload = "";
            }
            if (this.outputHandler == null) {
                this.error(Messages.getErrorString("CdfContentGenerator.ERROR_0001_NO_OUTPUT_HANDLER"));
                throw new InvalidParameterException(Messages.getString("CdfContentGenerator.ERROR_0001_NO_OUTPUT_HANDLER"));
            }
            if (contentItem == null) {
                this.error(Messages.getErrorString("CdfContentGenerator.ERROR_0002_NO_CONTENT_ITEM"));
                throw new InvalidParameterException(Messages.getString("CdfContentGenerator.ERROR_0002_NO_CONTENT_ITEM"));
            }
            if (out == null) {
                this.error(Messages.getErrorString("CdfContentGenerator.ERROR_0003_NO_OUTPUT_STREAM"));
                throw new InvalidParameterException(Messages.getString("CdfContentGenerator.ERROR_0003_NO_OUTPUT_STREAM"));
            }
            this.findMethod(method, contentItem, out, payload);
        }
        catch (Exception e) {
            logger.error((Object)"Error creating cdf content: ", (Throwable)e);
        }
    }

    private void findMethod(String urlPath, IContentItem contentItem, OutputStream out, String payload) throws Exception {
        IParameterProvider requestParams = (IParameterProvider)this.parameterProviders.get("request");
        if (urlPath.equals(RENDER_XCDF)) {
            this.renderXcdf(out, requestParams);
        } else if (urlPath.equals(JSON_SOLUTION)) {
            this.jsonSolution(out, requestParams);
        } else if (urlPath.equals(GET_CDF_RESOURCE)) {
            this.getCDFResource(urlPath, contentItem, out, requestParams);
        } else if (urlPath.equals(RENDER_HTML)) {
            this.renderHtml(out, requestParams);
        } else if (urlPath.equals(EXPORT)) {
            this.exportFile(requestParams, out);
        } else if (urlPath.equals(SETTINGS)) {
            this.cdfSettings(requestParams, out);
        } else if (urlPath.equals(CALLACTION)) {
            this.callAction(requestParams, out);
        } else if (urlPath.equals(COMMENTS)) {
            this.processComments(requestParams, out);
        } else if (urlPath.equals(STORAGE)) {
            this.processStorage(requestParams, out);
        } else if (urlPath.equals(CONTEXT)) {
            this.generateContext(requestParams, out);
        } else if (urlPath.equals(GETHEADERS)) {
            if (!payload.equals("")) {
                this.getHeaders(payload, requestParams, out);
            } else {
                this.getHeaders(requestParams, out);
            }
        } else {
            this.returnResource(urlPath, contentItem, out);
        }
    }

    private void generateContext(IParameterProvider requestParams, OutputStream out) throws Exception {
        String userName;
        JSONObject context = new JSONObject();
        Calendar cal = Calendar.getInstance();
        context.put("serverLocalDate", cal.getTimeInMillis());
        context.put("serverUTCDate", cal.getTimeInMillis() + (long)cal.getTimeZone().getRawOffset());
        context.put("user", (Object)this.userSession.getName());
        context.put("locale", (Object)this.userSession.getLocale());
        context.put("solution", requestParams.getParameter("solution"));
        context.put("path", requestParams.getParameter("path"));
        context.put("file", requestParams.getParameter("file"));
        IUserDetailsRoleListService service = (IUserDetailsRoleListService)PentahoSystem.get(IUserDetailsRoleListService.class);
        if (service == null) {
            service = PentahoSystem.getUserDetailsRoleListService();
        }
        if (!(userName = this.userSession.getName()).equals("anonymousUser")) {
            context.put("roles", (Collection)service.getRolesForUser(userName));
        }
        JSONObject params = new JSONObject();
        Iterator it = requestParams.getParameterNames();
        while (it.hasNext()) {
            String p = (String)it.next();
            if (p.indexOf("param") != 0) continue;
            params.put(p.substring(5), requestParams.getParameter(p));
        }
        context.put("params", (Object)params);
        StringBuilder s = new StringBuilder();
        s.append("\n<script language=\"javascript\" type=\"text/javascript\">\n");
        s.append("  Dashboards.context = ");
        s.append(context.toString(2) + "\n");
        s.append("</script>\n");
        out.write(s.toString().getBytes(ENCODING));
    }

    private void generateStorage(IParameterProvider requestParams, OutputStream out) throws Exception {
        StringBuilder s = new StringBuilder();
        s.append("\n<script language=\"javascript\" type=\"text/javascript\">\n");
        s.append("  Dashboards.storage = ");
        s.append(StorageEngine.getInstance().read(requestParams, this.userSession) + "\n");
        s.append("</script>\n");
        out.write(s.toString().getBytes(ENCODING));
    }

    private void renderXcdf(OutputStream out, IParameterProvider requestParams) throws Exception {
        long start = System.currentTimeMillis();
        UUID uuid = CdfAuditHelper.startAudit(requestParams.getParameter("action").toString(), this.getObjectName(), this.userSession, (ILogger)this);
        try {
            IMimeTypeListener mimeTypeListener = this.outputHandler.getMimeTypeListener();
            if (mimeTypeListener != null) {
                mimeTypeListener.setMimeType("text/html");
            }
            String solution = requestParams.getStringParameter("solution", null);
            String path = requestParams.getStringParameter("path", null);
            String template = requestParams.getStringParameter("template", null);
            String action = requestParams.getStringParameter("action", null);
            this.renderXCDFDashboard(requestParams, out, solution, path, action, template);
            long end = System.currentTimeMillis();
            CdfAuditHelper.endAudit(requestParams.getParameter("action").toString(), this.getObjectName(), this.userSession, (ILogger)this, start, uuid, end);
        }
        catch (Exception e) {
            long end = System.currentTimeMillis();
            CdfAuditHelper.endAudit(requestParams.getParameter("action").toString(), this.getObjectName(), this.userSession, (ILogger)this, start, uuid, end);
            throw e;
        }
    }

    private void jsonSolution(OutputStream out, IParameterProvider requestParams) throws JSONException, ParserConfigurationException {
        if (requestParams == null) {
            this.error(Messages.getErrorString("CdfContentGenerator.ERROR_0004_NO_REQUEST_PARAMS"));
            throw new InvalidParameterException(Messages.getString("CdfContentGenerator.ERROR_0017_NO_REQUEST_PARAMS"));
        }
        String solution = requestParams.getStringParameter("solution", null);
        String path = requestParams.getStringParameter("path", null);
        String mode = requestParams.getStringParameter("mode", null);
        String contextPath = ((HttpServletRequest)((IParameterProvider)this.parameterProviders.get("path")).getParameter("httprequest")).getContextPath();
        NavigateComponent nav = new NavigateComponent(this.userSession, contextPath);
        String json = nav.getNavigationElements(mode, solution, path);
        PrintWriter pw = new PrintWriter(out);
        String callback = requestParams.getStringParameter("callback", null);
        if (callback != null) {
            pw.println(callback + "(" + json + ");");
        } else {
            pw.println(json);
        }
        pw.flush();
    }

    private void getCDFResource(String urlPath, IContentItem contentItem, OutputStream out, IParameterProvider requestParams) throws Exception {
        if (requestParams == null) {
            this.error(Messages.getErrorString("CdfContentGenerator.ERROR_0004_NO_REQUEST_PARAMS"));
            throw new InvalidParameterException(Messages.getString("CdfContentGenerator.ERROR_0017_NO_REQUEST_PARAMS"));
        }
        String resource = requestParams.getStringParameter("resource", null);
        contentItem.setMimeType(MimeHelper.getMimeTypeFromFileName((String)resource));
        HttpServletResponse response = (HttpServletResponse)((IParameterProvider)this.parameterProviders.get("path")).getParameter("httpresponse");
        try {
            this.getSolutionFile(resource, out, (ILogger)this);
        }
        catch (SecurityException e) {
            response.sendError(403);
        }
    }

    private void renderHtml(OutputStream out, IParameterProvider requestParams) throws Exception {
        IMimeTypeListener mimeTypeListener = this.outputHandler.getMimeTypeListener();
        if (mimeTypeListener != null) {
            mimeTypeListener.setMimeType("text/html");
        }
        String solution = requestParams.getStringParameter("solution", null);
        String template = requestParams.getStringParameter("template", null);
        String path = requestParams.getStringParameter("path", null);
        String templateName = requestParams.getStringParameter("dashboard", null);
        String messageBaseFilename = requestParams.getStringParameter("messages", null);
        this.renderHtmlDashboard(requestParams, out, solution, path, templateName == null ? "template.html" : templateName, template, messageBaseFilename);
    }

    private void returnResource(String urlPath, IContentItem contentItem, OutputStream out) throws Exception {
        IParameterProvider pathParams = (IParameterProvider)this.parameterProviders.get("path");
        contentItem.setMimeType(MimeHelper.getMimeTypeFromFileName((String)urlPath));
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        String maxAge = resLoader.getPluginSetting(CdfContentGenerator.class, "settings/max-age");
        HttpServletResponse response = (HttpServletResponse)pathParams.getParameter("httpresponse");
        if (maxAge != null && response != null) {
            response.setHeader("Cache-Control", "max-age=" + maxAge);
        }
        this.getContent(urlPath, out, (ILogger)this);
    }

    public void renderXCDFDashboard(IParameterProvider requestParams, OutputStream out, String solution, String path, String action, String template) throws Exception {
        String fullPath = ActionInfo.buildSolutionPath((String)solution, (String)path, (String)action);
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.userSession);
        if (repository.getSolutionFile(fullPath, 1) == null) {
            out.write("Access Denied".getBytes(ENCODING));
            return;
        }
        String templateName = null;
        String messagesBaseFilename = null;
        if (repository.resourceExists(fullPath)) {
            ActionResource resource = new ActionResource("", 1, "text/xml", fullPath);
            String dashboardMetadata = repository.getResourceAsString((IActionSequenceResource)resource, 1);
            Document doc = DocumentHelper.parseText((String)dashboardMetadata);
            templateName = XmlDom4JHelper.getNodeText((String)"/cdf/template", (Node)doc, (String)"");
            if (doc.selectSingleNode("/cdf/messages") != null) {
                messagesBaseFilename = XmlDom4JHelper.getNodeText((String)"/cdf/messages", (Node)doc);
            }
            if (doc.selectSingleNode("/cdf/style") != null) {
                template = XmlDom4JHelper.getNodeText((String)"/cdf/style", (Node)doc);
            }
        }
        this.renderHtmlDashboard(requestParams, out, solution, path, templateName, template, messagesBaseFilename);
    }

    public void renderHtmlDashboard(IParameterProvider requestParams, OutputStream out, String solution, String path, String templateName, String template, String dashboardsMessagesBaseFilename) throws Exception {
        ActionResource resource;
        template = template == null || template.equals("") ? "" : "-" + template;
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.userSession);
        String fullTemplatePath = null;
        if (templateName != null) {
            fullTemplatePath = templateName.startsWith("/") || templateName.startsWith("\\") ? templateName : ActionInfo.buildSolutionPath((String)solution, (String)path, (String)templateName);
        }
        if (repository.getSolutionFile((IActionSequenceResource)(resource = fullTemplatePath != null && repository.resourceExists(fullTemplatePath) ? new ActionResource("", 1, "text/xml", fullTemplatePath) : new ActionResource("", 1, "text/xml", "system/pentaho-cdf/default-dashboard-template.html")), 1) == null) {
            out.write("Access Denied".getBytes(ENCODING));
            return;
        }
        String intro = "";
        String footer = "";
        String dashboardTemplate = "template-dashboard" + template + ".html";
        IUITemplater templater = (IUITemplater)PentahoSystem.get(IUITemplater.class, (IPentahoSession)this.userSession);
        ArrayList<String> i18nTagsList = new ArrayList<String>();
        if (templater != null) {
            String solutionPath = "cdf/templates/" + dashboardTemplate;
            if (!repository.resourceExists(solutionPath)) {
                solutionPath = "system/pentaho-cdf/" + dashboardTemplate;
            }
            ActionResource templateResource = new ActionResource("", 1, "text/xml", solutionPath);
            String templateContent = repository.getResourceAsString((IActionSequenceResource)templateResource, 1);
            templateContent = this.updateUserLanguageKey(templateContent);
            String[] sections = templater.breakTemplateString(templateContent = this.processi18nTags(templateContent, i18nTagsList), "", this.userSession);
            if (sections != null && sections.length > 0) {
                intro = sections[0];
            }
            if (sections != null && sections.length > 1) {
                footer = sections[1];
            }
        } else {
            intro = Messages.getErrorString("CdfContentGenerator.ERROR_0005_BAD_TEMPLATE_OBJECT");
        }
        InputStream is = repository.getResourceInputStream((IActionSequenceResource)resource, true, 1);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.forName(LocaleHelper.getSystemEncoding())));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            line = this.processi18nTags(line, i18nTagsList);
            sb.append(line + "\n");
        }
        is.close();
        String dashboardContent = sb.toString();
        String messageSetPath = null;
        MessageBundlesHelper mbh = new MessageBundlesHelper(solution, path, dashboardsMessagesBaseFilename);
        mbh.saveI18NMessageFilesToCache();
        messageSetPath = mbh.getMessageFilesCacheUrl() + "/";
        if (dashboardsMessagesBaseFilename == null) {
            dashboardsMessagesBaseFilename = "Messages";
        }
        intro = intro.replaceAll("\\{load\\}", "onload=\"load()\"");
        intro = intro.replaceAll("\\{body-tag-unload\\}", "");
        intro = intro.replaceAll("#\\{GLOBAL_MESSAGE_SET_NAME\\}", dashboardsMessagesBaseFilename);
        intro = intro.replaceAll("#\\{GLOBAL_MESSAGE_SET_PATH\\}", messageSetPath);
        intro = intro.replaceAll("#\\{GLOBAL_MESSAGE_SET\\}", this.buildMessageSetCode(i18nTagsList));
        int headIndex = intro.indexOf("<head>");
        int length = intro.length();
        out.write(intro.substring(0, headIndex + 6).getBytes(ENCODING));
        this.getHeaders(dashboardContent, requestParams, out);
        out.write(intro.substring(headIndex + 7, length - 1).getBytes(ENCODING));
        this.generateContext(requestParams, out);
        this.generateStorage(requestParams, out);
        out.write("<div id=\"dashboardContent\">".getBytes(ENCODING));
        out.write(dashboardContent.getBytes(ENCODING));
        out.write("</div>".getBytes(ENCODING));
        out.write(footer.getBytes(ENCODING));
        this.setResponseHeaders("text/html", 0, null);
    }

    private String buildMessageSetCode(ArrayList<String> tagsList) {
        StringBuffer messageCodeSet = new StringBuffer();
        for (String tag : tagsList) {
            messageCodeSet.append("\\$('#").append(this.updateSelectorName(tag)).append("').html(jQuery.i18n.prop('").append(tag).append("'));\n");
        }
        return messageCodeSet.toString();
    }

    private String processi18nTags(String content, ArrayList<String> tagsList) {
        String tagPattern = "CDF.i18n\\(\"";
        String[] test = content.split(tagPattern);
        if (test.length == 1) {
            return content;
        }
        StringBuffer resBuffer = new StringBuffer();
        resBuffer.append(test[0]);
        for (int i = 1; i < test.length; ++i) {
            resBuffer.append("<span id=\"");
            if (i == 0) continue;
            String tagValue = test[i].substring(0, test[i].indexOf("\")"));
            tagsList.add(tagValue);
            resBuffer.append(this.updateSelectorName(tagValue));
            resBuffer.append("\"></span>");
            resBuffer.append(test[i].substring(test[i].indexOf("\")") + 2, test[i].length()));
        }
        return resBuffer.toString();
    }

    private String updateSelectorName(String name) {
        return name.replace(".", "_");
    }

    private String updateUserLanguageKey(String intro) {
        Locale locale = LocaleHelper.getLocale();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Current Pentaho user locale: " + locale.getLanguage()));
        }
        intro = intro.replaceAll("#\\{LANGUAGE_CODE\\}", locale.getLanguage());
        return intro;
    }

    private void exportFile(IParameterProvider requestParams, OutputStream output) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ServiceCallAction serviceCallAction = ServiceCallAction.getInstance();
            if (serviceCallAction.execute(requestParams, this.userSession, out)) {
                Export export;
                String exportType = requestParams.getStringParameter("exportType", "excel");
                if (exportType.equals("csv")) {
                    export = new ExportCSV(output);
                    this.setResponseHeaders(MIME_CSV, 0, "export" + export.getExtension());
                } else {
                    export = new ExportExcel(output);
                    this.setResponseHeaders(MIME_XLS, 0, "export" + export.getExtension());
                }
                export.exportFile(new JSONObject(out.toString()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void cdfSettings(IParameterProvider requestParams, OutputStream out) {
        String method = requestParams.getStringParameter("method", null);
        String key = requestParams.getStringParameter("key", null);
        if (method.equals("set")) {
            CdfSettings.getInstance().setValue(key, requestParams.getParameter("value"), this.userSession);
        } else {
            Object value = CdfSettings.getInstance().getValue(key, this.userSession);
            PrintWriter pw = new PrintWriter(out);
            pw.println(value != null ? value.toString() : "");
            pw.flush();
        }
    }

    private void callAction(IParameterProvider requestParams, OutputStream out) {
        ServiceCallAction serviceCallAction = ServiceCallAction.getInstance();
        serviceCallAction.execute(requestParams, this.userSession, out);
    }

    private void processComments(IParameterProvider requestParams, OutputStream out) throws JSONException {
        String result;
        try {
            CommentsEngine commentsEngine = CommentsEngine.getInstance();
            result = commentsEngine.process(requestParams, this.userSession);
        }
        catch (InvalidCdfOperationException ex) {
            String errMessage = ex.getCause().getClass().getName() + " - " + ex.getMessage();
            logger.error((Object)("Error processing comment: " + errMessage));
            JSONObject json = new JSONObject();
            json.put("error", (Object)errMessage);
            result = json.toString(2);
        }
        PrintWriter pw = new PrintWriter(out);
        pw.println(result);
        pw.flush();
    }

    private void processStorage(IParameterProvider requestParams, OutputStream out) throws JSONException {
        String result;
        try {
            StorageEngine storagesEngine = StorageEngine.getInstance();
            result = storagesEngine.process(requestParams, this.userSession);
        }
        catch (InvalidCdfOperationException ex) {
            String errMessage = ex.getCause().getClass().getName() + " - " + ex.getMessage();
            logger.error((Object)("Error processing storage: " + errMessage));
            JSONObject json = new JSONObject();
            json.put("error", (Object)errMessage);
            result = json.toString(2);
        }
        PrintWriter pw = new PrintWriter(out);
        pw.println(result);
        pw.flush();
    }

    public Log getLogger() {
        return null;
    }

    public String concatFiles(String includeString, Hashtable filesAdded, Hashtable files) {
        String newLine = System.getProperty("line.separator");
        Enumeration keys = files.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String[] includeFiles = (String[])files.get(key);
            for (int i = 0; i < includeFiles.length; ++i) {
                if (filesAdded.containsKey(includeFiles[i])) continue;
                filesAdded.put(includeFiles[i], Character.valueOf('1'));
                includeString = key.equals("script") ? includeString + "<script language=\"javascript\" type=\"text/javascript\" src=\"" + includeFiles[i].replaceAll(RELATIVE_URL_TAG, this.RELATIVE_URL) + "\"></script>" + newLine : includeString + "<link rel=\"stylesheet\" href=\"" + includeFiles[i].replaceAll(RELATIVE_URL_TAG, this.RELATIVE_URL) + "\" type=\"text/css\" />";
            }
        }
        return includeString;
    }

    public boolean matchComponent(int keyIndex, String key, String content) {
        for (int i = keyIndex - 1; i > 0; --i) {
            if (content.charAt(i) == ':' || content.charAt(i) == '\"' || ("" + content.charAt(i)).trim().equals("")) continue;
            if (i - 3 <= 0 || !content.substring(i - 3, i + 1).equals("type")) break;
            return true;
        }
        if ((keyIndex = content.indexOf(key, keyIndex + key.length())) != -1) {
            return this.matchComponent(keyIndex, key, content);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getContent(String fileName, OutputStream out, ILogger logger) throws Exception {
        String path = PentahoSystem.getApplicationContext().getSolutionPath("system/pentaho-cdf" + fileName);
        File file = new File(path);
        FileInputStream in = FileUtils.openInputStream((File)file);
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSolutionFile(String resourcePath, OutputStream out, ILogger logger) throws Exception {
        String extension;
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        String formats = resLoader.getPluginSetting(((Object)((Object)this)).getClass(), "settings/resources/downloadable-formats");
        List<String> allowedFormats = Arrays.asList(StringUtils.split((String)formats, (char)','));
        if (allowedFormats.indexOf(extension = resourcePath.replaceAll(".*\\.(.*)", "$1")) < 0) {
            throw new SecurityException("Not allowed");
        }
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.userSession);
        InputStream in = repository.getResourceInputStream(resourcePath, true, 1);
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private void setResponseHeaders(String mimeType, int cacheDuration, String attachmentName) {
        HttpServletResponse response = (HttpServletResponse)((IParameterProvider)this.parameterProviders.get("path")).getParameter("httpresponse");
        response.setHeader("Content-Type", mimeType);
        if (attachmentName != null) {
            response.setHeader("content-disposition", "attachment; filename=" + attachmentName);
        }
        if (cacheDuration > 0) {
            response.setHeader("Cache-Control", "max-age=" + cacheDuration);
        } else {
            response.setHeader("Cache-Control", "max-age=0, no-store");
        }
    }

    private void getHeaders(IParameterProvider requestParams, OutputStream out) throws Exception {
        String dashboard = requestParams.getStringParameter("dashboardContent", "");
        this.getHeaders(dashboard, requestParams, out);
    }

    private void getHeaders(String dashboardContent, IParameterProvider requestParams, OutputStream out) throws Exception {
        String absRoot;
        File file;
        String suffix;
        String dashboardType = requestParams.getStringParameter("dashboardType", "blueprint");
        String scheme = requestParams.getStringParameter("scheme", "http");
        logger.info((Object)("opening resources file: " + Long.toString(new Date().getTime())));
        if (dashboardType.equals("mobile")) {
            suffix = "-mobile";
            file = new File(PentahoSystem.getApplicationContext().getSolutionPath("system/pentaho-cdf/resources-mobile.txt"));
        } else if (dashboardType.equals("blueprint")) {
            suffix = "";
            file = new File(PentahoSystem.getApplicationContext().getSolutionPath("system/pentaho-cdf/resources-blueprint.txt"));
        } else {
            suffix = "";
            file = new File(PentahoSystem.getApplicationContext().getSolutionPath("system/pentaho-cdf/resources-blueprint.txt"));
        }
        HashMap<String, String> includes = new HashMap<String, String>();
        Properties resources = new Properties();
        resources.load(new FileInputStream(file));
        ArrayList<String> miniscripts = new ArrayList<String>();
        ArrayList<String> ministyles = new ArrayList<String>();
        ArrayList<String> scripts = new ArrayList<String>();
        ArrayList<String> styles = new ArrayList<String>();
        miniscripts.addAll(Arrays.asList(resources.getProperty("commonLibrariesScript", "").split(",")));
        ministyles.addAll(Arrays.asList(resources.getProperty("commonLibrariesLink", "").split(",")));
        scripts.addAll(this.getExtraScripts(dashboardContent, resources));
        styles.addAll(this.getExtraStyles(dashboardContent, resources));
        styles.addAll(Arrays.asList(resources.getProperty("style", "").split(",")));
        StringBuilder scriptsBuilders = new StringBuilder();
        StringBuilder stylesBuilders = new StringBuilder();
        String string = absRoot = requestParams.hasParameter("root") ? scheme + "://" + requestParams.getParameter("root").toString() : "";
        if (requestParams.hasParameter("debug") && requestParams.getParameter("debug").toString().equals("true")) {
            for (String header : miniscripts) {
                scriptsBuilders.append("<script type=\"text/javascript\" src=\"" + header.replaceAll(RELATIVE_URL_TAG, absRoot + this.RELATIVE_URL) + "\"></script>\n");
            }
            for (String header : ministyles) {
                stylesBuilders.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + header.replaceAll(RELATIVE_URL_TAG, absRoot + this.RELATIVE_URL) + "\"/>\n");
            }
        } else {
            logger.info((Object)("starting minification: " + Long.toString(new Date().getTime())));
            String stylesHash = this.packager.minifyPackage("styles" + suffix);
            String scriptsHash = this.packager.minifyPackage("scripts" + suffix);
            stylesBuilders.append("<link href=\"" + absRoot + this.RELATIVE_URL + "/content/pentaho-cdf/js/styles" + suffix + ".css?version=" + stylesHash + "\" rel=\"stylesheet\" type=\"text/css\" />");
            scriptsBuilders.append("<script type=\"text/javascript\" src=\"" + absRoot + this.RELATIVE_URL + "/content/pentaho-cdf/js/scripts" + suffix + ".js?version=" + scriptsHash + "\"></script>");
            logger.info((Object)("finished minification: " + Long.toString(new Date().getTime())));
        }
        for (String header : scripts) {
            scriptsBuilders.append("<script type=\"text/javascript\" src=\"" + header.replaceAll(RELATIVE_URL_TAG, absRoot + this.RELATIVE_URL) + "\"></script>\n");
        }
        for (String header : styles) {
            stylesBuilders.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + header.replaceAll(RELATIVE_URL_TAG, absRoot + this.RELATIVE_URL) + "\"/>\n");
        }
        stylesBuilders.append("<!--[if lte IE 8]><link rel=\"stylesheet\" href=\"" + absRoot + this.RELATIVE_URL + "/content/pentaho-cdf/js/blueprint/ie.css\" type=\"text/css\" media=\"screen, projection\"><![endif]-->");
        StringBuilder stuff = new StringBuilder();
        includes.put("scripts", scriptsBuilders.toString());
        includes.put("styles", stylesBuilders.toString());
        for (String key : includes.keySet()) {
            stuff.append((String)includes.get(key));
        }
        out.write(stuff.toString().getBytes("UTF8"));
    }

    private ArrayList<String> getExtraScripts(String dashboardContentOrig, Properties resources) {
        String dashboardContent = dashboardContentOrig.toLowerCase();
        ArrayList<String> scripts = new ArrayList<String>();
        boolean all = dashboardContent == null || StringUtils.isEmpty((String)dashboardContent);
        Enumeration<?> resourceKeys = resources.propertyNames();
        while (resourceKeys.hasMoreElements()) {
            String scriptkey = (String)resourceKeys.nextElement();
            if (scriptkey.indexOf("Script") == -1 || scriptkey.indexOf("commonLibraries") != -1) continue;
            String key = scriptkey.replaceAll("Script$", "");
            int keyIndex = all ? 0 : dashboardContent.indexOf(key.toLowerCase());
            if (keyIndex == -1 || !all && !this.matchComponent(keyIndex, key.toLowerCase(), dashboardContent) || all && scriptkey.indexOf("mapScript") != -1) continue;
            scripts.addAll(Arrays.asList(resources.getProperty(scriptkey).split(",")));
        }
        return scripts;
    }

    private ArrayList<String> getExtraStyles(String dashboardContentOrig, Properties resources) {
        String dashboardContent = dashboardContentOrig.toLowerCase();
        ArrayList<String> styles = new ArrayList<String>();
        boolean all = dashboardContent == null || StringUtils.isEmpty((String)dashboardContent);
        if (dashboardContent != null && !StringUtils.isEmpty((String)dashboardContent)) {
            Enumeration<?> resourceKeys = resources.propertyNames();
            while (resourceKeys.hasMoreElements()) {
                String scriptkey = (String)resourceKeys.nextElement();
                if (scriptkey.indexOf("Link") == -1 || scriptkey.indexOf("commonLibraries") != -1) continue;
                String key = scriptkey.replaceAll("Link$", "");
                int keyIndex = all ? 0 : dashboardContent.indexOf(key.toLowerCase());
                if (keyIndex == -1 || !this.matchComponent(keyIndex, key.toLowerCase(), dashboardContent)) continue;
                styles.addAll(Arrays.asList(resources.getProperty(scriptkey).split(",")));
            }
        }
        return styles;
    }

    private void init() throws Exception {
        String fname;
        int i;
        String rootdir = PentahoSystem.getApplicationContext().getSolutionPath("system/pentaho-cdf");
        File blueprintFile = new File(rootdir + "/resources-blueprint.txt");
        File mobileFile = new File(rootdir + "/resources-mobile.txt");
        Properties blueprintResources = new Properties();
        blueprintResources.load(new FileInputStream(blueprintFile));
        Properties mobileResources = new Properties();
        mobileResources.load(new FileInputStream(mobileFile));
        ArrayList<String> scriptsList = new ArrayList<String>();
        ArrayList<String> stylesList = new ArrayList<String>();
        this.packager = Packager.getInstance();
        boolean scriptsAvailable = this.packager.isPackageRegistered("scripts");
        boolean stylesAvailable = this.packager.isPackageRegistered("styles");
        boolean mobileScriptsAvailable = this.packager.isPackageRegistered("scripts-mobile");
        boolean mobileStylesAvailable = this.packager.isPackageRegistered("styles-mobile");
        if (!scriptsAvailable) {
            scriptsList.clear();
            scriptsList.addAll(Arrays.asList(blueprintResources.get("commonLibrariesScript").toString().split(",")));
            for (i = 0; i < scriptsList.size(); ++i) {
                fname = (String)scriptsList.get(i);
                scriptsList.set(i, fname.replaceAll("@RELATIVE_URL@/content/pentaho-cdf", ""));
            }
            this.packager.registerPackage("scripts", Packager.Filetype.JS, rootdir, rootdir + "/js/scripts.js", scriptsList.toArray(new String[scriptsList.size()]));
        }
        if (!stylesAvailable) {
            stylesList.clear();
            stylesList.addAll(Arrays.asList(blueprintResources.get("commonLibrariesLink").toString().split(",")));
            for (i = 0; i < stylesList.size(); ++i) {
                fname = (String)stylesList.get(i);
                stylesList.set(i, fname.replaceAll("@RELATIVE_URL@/content/pentaho-cdf", ""));
            }
            this.packager.registerPackage("styles", Packager.Filetype.CSS, rootdir, rootdir + "/js/styles.css", stylesList.toArray(new String[stylesList.size()]));
        }
        if (!mobileScriptsAvailable) {
            scriptsList.clear();
            scriptsList.addAll(Arrays.asList(mobileResources.get("commonLibrariesScript").toString().split(",")));
            for (i = 0; i < scriptsList.size(); ++i) {
                fname = (String)scriptsList.get(i);
                scriptsList.set(i, fname.replaceAll("@RELATIVE_URL@/content/pentaho-cdf", ""));
            }
            this.packager.registerPackage("scripts-mobile", Packager.Filetype.JS, rootdir, rootdir + "/js/scripts-mobile.js", scriptsList.toArray(new String[scriptsList.size()]));
        }
        if (!mobileStylesAvailable) {
            stylesList.clear();
            stylesList.addAll(Arrays.asList(mobileResources.get("commonLibrariesLink").toString().split(",")));
            for (i = 0; i < stylesList.size(); ++i) {
                fname = (String)stylesList.get(i);
                stylesList.set(i, fname.replaceAll("@RELATIVE_URL@/content/pentaho-cdf", ""));
            }
            this.packager.registerPackage("styles-mobile", Packager.Filetype.CSS, rootdir, rootdir + "/js/styles-mobile.css", stylesList.toArray(new String[stylesList.size()]));
        }
    }

    private static String getBaseUrl() {
        String baseUrl;
        try {
            URI uri = new URI(PentahoSystem.getApplicationContext().getBaseUrl());
            baseUrl = uri.getPath();
            if (!baseUrl.endsWith("/")) {
                baseUrl = baseUrl + "/";
            }
        }
        catch (URISyntaxException ex) {
            logger.fatal((Object)("Error building BaseURL from " + PentahoSystem.getApplicationContext().getBaseUrl()), (Throwable)ex);
            baseUrl = "";
        }
        return baseUrl;
    }
}

