/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.servlet.ServletBase;

public class GetCDFResource
extends ServletBase {
    private static final long serialVersionUID = 8251622066287622726L;
    private static final Log logger = LogFactory.getLog(GetCDFResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IPentahoSession session = this.getPentahoSession(request);
        String resource = request.getParameter("resource");
        if (resource == null || StringUtil.doesPathContainParentPathSegment((String)resource)) {
            this.error(Messages.getErrorString((String)"GetResource.ERROR_0001_RESOURCE_PARAMETER_MISSING"));
            response.setStatus(503);
            return;
        }
        String resourcePath = null;
        resourcePath = resource;
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)session);
        InputStream in = repository.getResourceInputStream(resourcePath, true, 1);
        if (in == null) {
            this.error(Messages.getErrorString((String)"GetResource.ERROR_0003_RESOURCE_MISSING", (String)resourcePath));
            response.setStatus(503);
            return;
        }
        String mimeType = this.getServletContext().getMimeType(resourcePath);
        if (null == mimeType || mimeType.length() <= 0) {
            response.setContentType("image/png");
        } else {
            response.setContentType(mimeType);
        }
        response.setCharacterEncoding(LocaleHelper.getSystemEncoding());
        response.setHeader("expires", "0");
        ServletOutputStream out = response.getOutputStream();
        try {
            byte[] buf = new byte[1024];
            int count = 0;
            int totalBytes = 0;
            while ((count = in.read(buf)) >= 0) {
                out.write(buf, 0, count);
                totalBytes += count;
            }
            response.setContentLength(totalBytes);
        }
        finally {
            in.close();
            out.close();
        }
    }

    public Log getLogger() {
        return logger;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

