/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.StandaloneSession;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.messages.MessageUtil;

public class Messages {
    private static final Map<Locale, ResourceBundle> locales = Collections.synchronizedMap(new HashMap());

    private static ResourceBundle getBundle() {
        Locale locale = LocaleHelper.getLocale();
        ResourceBundle bundle = locales.get(locale);
        if (bundle == null) {
            StandaloneSession session = new StandaloneSession("dashboards messages");
            try {
                InputStream in = ((ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)session)).getResourceInputStream("system/pentaho-cdf/messages.properties", true, 1);
                bundle = new PropertyResourceBundle(in);
                locales.put(locale, bundle);
            }
            catch (Exception e) {
                Logger.error((String)Messages.class.getName(), (String)"Could not get localization bundle", (Throwable)e);
            }
        }
        return bundle;
    }

    public static String getEncodedString(String rawValue) {
        if (rawValue == null) {
            return "";
        }
        StringBuffer value = new StringBuffer();
        for (int n = 0; n < rawValue.length(); ++n) {
            char charValue = rawValue.charAt(n);
            if (charValue >= '\u0080') {
                value.append("&#x");
                value.append(Integer.toString(charValue, 16));
                value.append(";");
                continue;
            }
            value.append(charValue);
        }
        return value.toString();
    }

    public static String getXslString(String key) {
        String rawValue = Messages.getString(key);
        return Messages.getEncodedString(rawValue);
    }

    public static String getString(String key) {
        try {
            return Messages.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public static String getString(String key, String param1) {
        return MessageUtil.getString((ResourceBundle)Messages.getBundle(), (String)key, (String[])new String[]{param1});
    }

    public static String getString(String key, String param1, String param2) {
        return MessageUtil.getString((ResourceBundle)Messages.getBundle(), (String)key, (String[])new String[]{param1, param2});
    }

    public static String getString(String key, String param1, String param2, String param3) {
        return MessageUtil.getString((ResourceBundle)Messages.getBundle(), (String)key, (String[])new String[]{param1, param2, param3});
    }

    public static String getString(String key, String param1, String param2, String param3, String param4) {
        return MessageUtil.getString((ResourceBundle)Messages.getBundle(), (String)key, (String[])new String[]{param1, param2, param3, param4});
    }

    public static String getErrorString(String key) {
        return MessageUtil.formatErrorMessage((String)key, (String)Messages.getString(key));
    }

    public static String getErrorString(String key, String param1) {
        return MessageUtil.getErrorString((ResourceBundle)Messages.getBundle(), (String)key, (String[])new String[]{param1});
    }

    public static String getErrorString(String key, String param1, String param2) {
        return MessageUtil.getErrorString((ResourceBundle)Messages.getBundle(), (String)key, (String[])new String[]{param1, param2});
    }

    public static String getErrorString(String key, String param1, String param2, String param3) {
        return MessageUtil.getErrorString((ResourceBundle)Messages.getBundle(), (String)key, (String[])new String[]{param1, param2, param3});
    }
}

