/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf;

import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DOMReader;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.cdf.PluginCatalogEngine;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.api.repository.ISolutionRepositoryService;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class NavigateComponent
extends PentahoBase {
    private static final String NAVIGATOR = "navigator";
    private static final String CONTENTLIST = "contentList";
    private static final String SOLUTIONTREE = "solutionTree";
    private static final String TYPE_DIR = "FOLDER";
    private static final String TYPE_XACTION = "XACTION";
    private static final String TYPE_URL = "URL";
    private static final String TYPE_XCDF = "XCDF";
    private static final String TYPE_WCDF = "WCDF";
    private static final String TYPE_PRPT = "PRPT";
    private static final String CACHE_NAVIGATOR = "CDF_NAVIGATOR_JSON";
    private static final String CACHE_SOLUTIONTREE = "CDF_SOLUTIONTREE_JSON";
    private static final String CACHE_REPOSITORY_DOCUMENT = "CDF_REPOSITORY_DOCUMENT";
    protected static final Log logger = LogFactory.getLog(NavigateComponent.class);
    ISolutionRepository solutionRepository = null;
    IPentahoSession userSession;
    ICacheManager cacheManager;
    boolean cachingAvailable;
    String contextPath;

    public NavigateComponent(IPentahoSession userSession, String contextPath) {
        this.solutionRepository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)userSession);
        this.userSession = userSession;
        this.cacheManager = PentahoSystem.getCacheManager((IPentahoSession)userSession);
        this.cachingAvailable = this.cacheManager != null && this.cacheManager.cacheEnabled();
        this.contextPath = contextPath;
    }

    public String getNavigationElements(String mode, String solution, String path) throws JSONException, ParserConfigurationException {
        if (mode.equals(NAVIGATOR)) {
            return this.getNavigatorJSON(solution, path);
        }
        if (mode.equals(CONTENTLIST)) {
            return this.getContentListJSON(solution, path);
        }
        if (mode.equals(SOLUTIONTREE)) {
            return this.getSolutionTreeJSON();
        }
        logger.warn((Object)("Invalid mode: " + mode));
        return "";
    }

    public Log getLogger() {
        return logger;
    }

    private Document getRepositoryDocument(IPentahoSession userSession) throws ParserConfigurationException {
        Document repositoryDocument;
        if (this.cachingAvailable && (repositoryDocument = (Document)this.cacheManager.getFromSessionCache(userSession, CACHE_REPOSITORY_DOCUMENT)) != null) {
            this.getLogger().debug((Object)"Repository Document found in cache");
            return repositoryDocument;
        }
        DOMReader reader = new DOMReader();
        repositoryDocument = reader.read(((ISolutionRepositoryService)PentahoSystem.get(ISolutionRepositoryService.class, (IPentahoSession)userSession)).getSolutionRepositoryDoc(userSession, new String[0]));
        this.cacheManager.putInSessionCache(userSession, CACHE_REPOSITORY_DOCUMENT, (Object)repositoryDocument);
        return repositoryDocument;
    }

    private String getNavigatorJSON(String solution, String path) {
        String jsonString = null;
        if (this.cachingAvailable && (jsonString = (String)this.cacheManager.getFromSessionCache(this.userSession, CACHE_NAVIGATOR)) != null) {
            this.debug("Navigator found in cache");
        } else {
            try {
                Document navDoc = this.getRepositoryDocument(this.userSession);
                JSONObject json = new JSONObject();
                Element tree = navDoc.getRootElement();
                JSONArray array = this.processTree((Node)tree, "/", false);
                json.put("solution", array.get(0));
                jsonString = json.toString(2);
                this.cacheManager.putInSessionCache(this.userSession, CACHE_NAVIGATOR, (Object)jsonString);
            }
            catch (Exception e) {
                System.out.println("Error: " + e.getClass().getName() + " - " + e.getMessage());
                this.warn("Error: " + e.getClass().getName() + " - " + e.getMessage());
            }
        }
        return jsonString;
    }

    private String getSolutionTreeJSON() {
        String jsonString = null;
        if (this.cachingAvailable && (jsonString = (String)this.cacheManager.getFromSessionCache(this.userSession, CACHE_SOLUTIONTREE)) != null) {
            this.debug("SolutionTree found in cache");
        } else {
            try {
                Document navDoc = this.getRepositoryDocument(this.userSession);
                JSONObject json = new JSONObject();
                Element tree = navDoc.getRootElement();
                JSONArray array = this.processTree((Node)tree, "/", true);
                json.put("solution", array.get(0));
                jsonString = json.toString(2);
                this.cacheManager.putInSessionCache(this.userSession, CACHE_SOLUTIONTREE, (Object)jsonString);
            }
            catch (Exception e) {
                System.out.println("Error: " + e.getClass().getName() + " - " + e.getMessage());
                this.warn("Error: " + e.getClass().getName() + " - " + e.getMessage());
            }
        }
        return jsonString;
    }

    private JSONArray processTree(Node tree, String parentPath, boolean includeAllFiles) {
        String xPathDir = "./file[@isDirectory='true']";
        JSONArray array = null;
        try {
            String[] parentPathArray;
            List nodes = tree.selectNodes("./file[@isDirectory='true']");
            if (!nodes.isEmpty()) {
                array = new JSONArray();
            }
            String solutionName = (parentPathArray = parentPath.split("/")).length > 2 ? parentPathArray[2] : "";
            String solutionPath = parentPathArray.length > 3 ? parentPath.substring(parentPath.indexOf(solutionName) + solutionName.length() + 1, parentPath.length()) + "/" : "";
            for (Object node1 : nodes) {
                Node node = (Node)node1;
                JSONObject json = new JSONObject();
                JSONArray children = null;
                Object files = null;
                String name = node.valueOf("@name");
                if (parentPathArray.length > 0) {
                    String localizedName = node.valueOf("@localized-name");
                    String description = node.valueOf("@description");
                    boolean visible = node.valueOf("@visible").equals("true");
                    boolean isDirectory = node.valueOf("@isDirectory").equals("true");
                    String path = solutionName.length() == 0 ? "" : solutionPath + name;
                    String solution = solutionName.length() == 0 ? name : solutionName;
                    json.put("id", (Object)(parentPath + "/" + name));
                    json.put("name", (Object)name);
                    json.put("solution", (Object)solution);
                    json.put("path", (Object)path);
                    json.put("type", (Object)TYPE_DIR);
                    json.put("visible", visible);
                    json.put("title", (Object)(visible ? localizedName : "Hidden"));
                    json.put("description", (Object)description);
                    if (visible && isDirectory) {
                        children = this.processTree(node, parentPath + "/" + name, includeAllFiles);
                        json.put("files", (Object)new JSONArray());
                        List fileNodes = includeAllFiles ? node.selectNodes("./file[@isDirectory='false']") : node.selectNodes("./file[@isDirectory='false'][ends-with(string(@name),'.xcdf') or ends-with(string(@name),'.wcdf')]");
                        for (Node fileNode : fileNodes) {
                            this.processFileNode(json, fileNode, "files");
                        }
                    }
                } else {
                    json.put("id", (Object)tree.valueOf("@path"));
                    json.put("name", (Object)solutionName);
                    json.put("path", (Object)solutionPath);
                    json.put("visible", true);
                    json.put("title", (Object)"Solution");
                    children = this.processTree(tree, tree.valueOf("@path"), includeAllFiles);
                }
                if (children != null) {
                    json.put("folders", (Object)children);
                }
                array.put((Object)json);
            }
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getClass().getName() + " - " + e.getMessage());
            this.warn("Error: " + e.getClass().getName() + " - " + e.getMessage());
        }
        return array;
    }

    private void processFileNode(JSONObject json, Node fileNode, String placeholder) throws JSONException {
        Hashtable<String, String> readAbility = PluginCatalogEngine.getInstance().getPlugins();
        String link = "";
        String _solution = json.getString("solution");
        String _path = json.getString("path");
        String relativeUrl = this.contextPath;
        String name = fileNode.valueOf("@name");
        String type = name.substring(name.lastIndexOf(".") + 1, name.length());
        if (relativeUrl.endsWith("/")) {
            relativeUrl = relativeUrl.substring(0, relativeUrl.length() - 1);
        }
        String path = type.equals(TYPE_DIR) ? (_path.length() > 0 ? _path + "/" + name : name) : _path;
        String url = null;
        url = type != null && type.equals(TYPE_URL) ? (!(fileNode.valueOf("@url").startsWith("http") || fileNode.valueOf("@url").startsWith(relativeUrl) || fileNode.valueOf("@url").startsWith("/")) ? "/" + fileNode.valueOf("@url") : fileNode.valueOf("@url")) : null;
        String lowType = type.toLowerCase();
        if (readAbility.containsKey(lowType)) {
            String s = "/" + readAbility.get(lowType);
            s = s.replace("{solution}", _solution);
            s = s.replace("{path}", path);
            s = s.replace("{name}", name);
            s = s.replaceAll("&amp;", "&");
            link = link + s;
            JSONObject file = new JSONObject();
            file.put("file", (Object)name);
            file.put("solution", json.get("solution"));
            file.put("path", json.get("path"));
            file.put("type", (Object)type);
            file.put("visible", fileNode.valueOf("@visible").equals("true"));
            file.put("title", (Object)fileNode.valueOf("@localized-name"));
            file.put("description", (Object)fileNode.valueOf("@description"));
            file.put("link", (Object)link);
            json.append(placeholder, (Object)file);
            return;
        }
    }

    private String getContentListJSON(String _solution, String _path) {
        String jsonString = null;
        JSONArray array = null;
        try {
            JSONObject json = new JSONObject();
            Document navDoc = this.getRepositoryDocument(this.userSession);
            Element tree = navDoc.getRootElement();
            String xPathDir = "./file[@name='" + _solution + "']";
            List nodes = tree.selectNodes(xPathDir);
            if (!nodes.isEmpty() && nodes.size() == 1) {
                Node node = this.getDirectoryNode((Node)nodes.get(0), _path);
                json.put("name", (Object)node.valueOf("@name"));
                json.put("id", (Object)(_solution + "/" + _path));
                json.put("solution", (Object)_solution);
                json.put("path", (Object)_path);
                json.put("type", (Object)TYPE_DIR);
                json.put("visible", false);
                json.put("title", (Object)"Hidden");
                array = new JSONArray();
                json.put("content", (Object)array);
                nodes = node.selectNodes("./file");
                for (Object fileNode : nodes) {
                    this.processFileNode(json, (Node)fileNode, "content");
                }
            }
            jsonString = json.toString(2);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getClass().getName() + " - " + e.getMessage());
            this.warn("Error: " + e.getClass().getName() + " - " + e.getMessage());
        }
        return jsonString;
    }

    private Node getDirectoryNode(Node node, String _path) {
        String[] pathArray = _path.split("/");
        if (pathArray.length > 0) {
            String path = pathArray[0];
            String xPathDir = "./file[@name='" + path + "']";
            List nodes = node.selectNodes(xPathDir);
            if (!nodes.isEmpty() && nodes.size() == 1) {
                node = (Node)nodes.get(0);
                if (!_path.equals(path)) {
                    node = this.getDirectoryNode(node, _path.substring(_path.indexOf(path) + path.length() + 1, _path.length()));
                }
            } else {
                return node;
            }
        }
        return node;
    }
}

