/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginCatalogEngine {
    public static final String PLUGIN_DIR = PentahoSystem.getApplicationContext().getSolutionPath("system/");
    public String path;
    private static PluginCatalogEngine _engine;
    private Hashtable<String, String> pluginPool;

    public PluginCatalogEngine() {
        this.path = PLUGIN_DIR;
        this.catalogPlugins(PLUGIN_DIR);
    }

    public PluginCatalogEngine(String path) {
        this.path = path;
        this.catalogPlugins(path);
    }

    public static PluginCatalogEngine getInstance() {
        if (_engine == null) {
            _engine = new PluginCatalogEngine();
        }
        return _engine;
    }

    public void refresh() {
        this.catalogPlugins(this.path);
    }

    public Hashtable<String, String> getPlugins() {
        return this.pluginPool;
    }

    private void catalogPlugins(String path) {
        String[] listPlugins;
        File systemFolder = new File(path);
        this.pluginPool = new Hashtable();
        this.pluginPool.put("xaction", "ViewAction?solution={solution}&path={path}&action={name}");
        FilenameFilter subFolders = new FilenameFilter(){

            public boolean accept(File systemFolder, String name) {
                File plugin = new File(systemFolder.getPath() + "/" + name + "/plugin.xml");
                return plugin.exists() && plugin.canRead();
            }
        };
        for (String plugin : listPlugins = systemFolder.list(subFolders)) {
            String pluginFolder = PLUGIN_DIR + plugin + "/plugin.xml";
            try {
                Document xml = XmlDom4JHelper.getDocFromFile((String)pluginFolder, null);
                List list = xml.selectNodes("//content-type[@type]");
                String readType = null;
                for (Node node : list) {
                    readType = XmlDom4JHelper.getNodeText((String)"@type", (Node)node);
                }
                if (readType == null) continue;
                String rawUrl = xml.selectSingleNode("//operation/id[text()='RUN']/../command").getText();
                this.pluginPool.put(readType, rawUrl);
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

