/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.engine.core.system.PentahoSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceManager {
    public static ResourceManager instance;
    public static final String PLUGIN_DIR;
    private static final HashSet<String> CACHEABLE_EXTENSIONS;
    private static final HashMap<String, String> cacheContainer;
    private boolean isCacheEnabled = true;

    public ResourceManager() {
        CACHEABLE_EXTENSIONS.add("html");
        CACHEABLE_EXTENSIONS.add("json");
        CACHEABLE_EXTENSIONS.add("cdfde");
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        this.isCacheEnabled = Boolean.parseBoolean(resLoader.getPluginSetting(this.getClass(), "pentaho-cdf-dd/enable-cache"));
    }

    public static ResourceManager getInstance() {
        if (instance == null) {
            instance = new ResourceManager();
        }
        return instance;
    }

    public String getResourceAsString(String path, HashMap<String, String> tokens) throws IOException {
        int c;
        String extension = this.getResourceExtension(path);
        String cacheKey = this.buildCacheKey(path, tokens);
        if (this.isCacheEnabled && CACHEABLE_EXTENSIONS.contains(extension) && cacheContainer.containsKey(cacheKey)) {
            return cacheContainer.get(cacheKey);
        }
        FileInputStream in = new FileInputStream(PLUGIN_DIR + path);
        StringBuilder resource = new StringBuilder();
        while ((c = ((InputStream)in).read()) != -1) {
            resource.append((char)c);
        }
        ((InputStream)in).close();
        if (tokens != null) {
            for (String key : tokens.keySet()) {
                int index = resource.indexOf(key);
                if (index == -1) continue;
                resource.replace(index, index + key.length(), tokens.get(key));
            }
        }
        String output = resource.toString();
        if (this.isCacheEnabled && CACHEABLE_EXTENSIONS.contains(extension)) {
            cacheContainer.put(cacheKey, output);
        }
        return output;
    }

    public String getResourceAsString(String path) throws IOException {
        return this.getResourceAsString(path, null);
    }

    private String buildCacheKey(String path, HashMap<String, String> tokens) {
        StringBuilder keyBuilder = new StringBuilder(path);
        if (tokens != null) {
            for (String key : tokens.keySet()) {
                keyBuilder.append(key.hashCode());
                keyBuilder.append(tokens.get(key).hashCode());
            }
        }
        return keyBuilder.toString();
    }

    private String getResourceExtension(String path) {
        return path.substring(path.lastIndexOf(46) + 1);
    }

    public void cleanCache() {
        cacheContainer.clear();
    }

    static {
        PLUGIN_DIR = PentahoSystem.getApplicationContext().getSolutionPath("system/pentaho-cdf/");
        CACHEABLE_EXTENSIONS = new HashSet();
        cacheContainer = new HashMap();
    }
}

