/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class Utils {
    private static Log logger = LogFactory.getLog(Utils.class);
    private static String baseUrl = null;

    public static String getBaseUrl() {
        if (baseUrl == null) {
            try {
                URI uri = new URI(PentahoSystem.getApplicationContext().getBaseUrl());
                baseUrl = uri.getPath();
                if (!baseUrl.endsWith("/")) {
                    baseUrl = baseUrl + "/";
                }
            }
            catch (URISyntaxException ex) {
                logger.fatal((Object)("Error building BaseURL from " + PentahoSystem.getApplicationContext().getBaseUrl()), (Throwable)ex);
            }
        }
        return baseUrl;
    }

    public static void main(String[] args) {
        try {
            URI uri = new URI("http://127.0.0.1:8080/pentaho/");
            System.out.println(uri.getPath());
            uri = new URI("/pentaho/");
            System.out.println(uri.getPath());
            uri = new URI("http://127.0.0.1:8080/pentaho");
            System.out.println(uri.getPath());
            uri = new URI("/pentaho");
            System.out.println(uri.getPath());
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static String getSolutionPath() {
        return StringUtils.replace((String)PentahoSystem.getApplicationContext().getSolutionPath(""), (String)"\\", (String)"/");
    }

    public static String getSolutionPath(String path) {
        return Utils.joinPath(Utils.getSolutionPath(), path);
    }

    public static String joinPath(String ... paths) {
        return StringUtils.defaultString((String)StringUtils.join((Object[])paths, (String)"/")).replaceAll("/+", "/");
    }

    public static boolean pathStartsWith(String fileName, String pathStart) {
        if (pathStart == null) {
            return true;
        }
        if (fileName == null) {
            return false;
        }
        return FilenameUtils.getPath((String)fileName).startsWith(pathStart);
    }
}

