/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.comments;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.cdf.InvalidCdfOperationException;
import org.pentaho.cdf.Messages;
import org.pentaho.cdf.PluginHibernateException;
import org.pentaho.cdf.comments.CommentEntry;
import org.pentaho.cdf.utils.PluginHibernateUtil;
import org.pentaho.cdf.utils.Util;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class CommentsEngine {
    private static final Log logger = LogFactory.getLog(CommentsEngine.class);
    private static CommentsEngine _instance;
    private static final int DELETE_OPERATION = 0;
    private static final int ARCHIVE_OPERATION = 1;
    private static final SimpleDateFormat format;

    public static CommentsEngine getInstance() {
        if (_instance == null) {
            _instance = new CommentsEngine();
        }
        return _instance;
    }

    public CommentsEngine() {
        try {
            logger.info((Object)"Creating CommentsEngine instance");
            this.initialize();
        }
        catch (PluginHibernateException ex) {
            logger.fatal((Object)("Could not create CommentsEngine: " + Util.getExceptionDescription(ex)));
            return;
        }
    }

    public String process(IParameterProvider requestParams, IPentahoSession userSession) throws InvalidCdfOperationException {
        String actionParam = requestParams.getStringParameter("action", "");
        Class[] params = new Class[]{IParameterProvider.class, IPentahoSession.class};
        try {
            Method mthd = this.getClass().getMethod(actionParam, params);
            JSONObject json = (JSONObject)mthd.invoke((Object)this, requestParams, userSession);
            return json.toString(2);
        }
        catch (JSONException ex) {
            logger.error((Object)("JSONException while building return information: " + this.getExceptionDescription((Exception)((Object)ex))));
            throw new InvalidCdfOperationException((Exception)((Object)ex));
        }
        catch (NoSuchMethodException ex) {
            logger.error((Object)("NoSuchMethodException : " + actionParam + " - " + this.getExceptionDescription(ex)));
            throw new InvalidCdfOperationException(ex);
        }
        catch (Exception ex) {
            logger.error((Object)(Messages.getErrorString("DashboardDesignerContentGenerator.ERROR_001_INVALID_METHOD_EXCEPTION") + " : " + actionParam));
            throw new InvalidCdfOperationException(ex);
        }
    }

    public JSONObject add(IParameterProvider requestParams, IPentahoSession userSession) throws JSONException, InvalidCdfOperationException, PluginHibernateException {
        String page = requestParams.getStringParameter("page", "");
        String comment = requestParams.getStringParameter("comment", "");
        String user = userSession.getName();
        if (page == null || page.equals("") || comment == null || comment.equals("")) {
            logger.error((Object)"Parameters 'page' and 'comment' are not optional");
            throw new InvalidCdfOperationException("Page cannot be null");
        }
        logger.debug((Object)"Adding comment");
        CommentEntry commentEntry = new CommentEntry(page, user, comment);
        Session session = this.getSession();
        session.beginTransaction();
        session.save((Object)commentEntry);
        session.flush();
        session.getTransaction().commit();
        JSONObject json = new JSONObject();
        json.put("result", (Object)this.commentToJson(commentEntry, userSession));
        return json;
    }

    public JSONObject list(IParameterProvider requestParams, IPentahoSession userSession) throws JSONException, InvalidCdfOperationException, PluginHibernateException {
        logger.debug((Object)"Listing messages");
        String page = requestParams.getStringParameter("page", "");
        String user = userSession.getName();
        int firstResult = Integer.parseInt(requestParams.getStringParameter("firstResult", "0"));
        int maxResults = Integer.parseInt(requestParams.getStringParameter("maxResults", "20"));
        if (page == null || page.equals("")) {
            logger.error((Object)"Parameters 'page' and 'comment' are not optional");
            throw new InvalidCdfOperationException("Page cannot be null");
        }
        logger.debug((Object)"Adding comment");
        Session session = this.getSession();
        Query query = session.getNamedQuery("org.pentaho.cdf.comments.CommentEntry.getCommentsByPage").setString("page", page);
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResults);
        List comments = query.list();
        JSONArray jsonArray = new JSONArray();
        for (CommentEntry comment : comments) {
            JSONObject commentJson = this.commentToJson(comment, userSession);
            jsonArray.put((Object)commentJson);
        }
        JSONObject json = new JSONObject();
        json.put("result", (Object)jsonArray);
        return json;
    }

    public JSONObject delete(IParameterProvider requestParams, IPentahoSession userSession) throws JSONException, InvalidCdfOperationException, PluginHibernateException {
        int commentId = Integer.parseInt(requestParams.getStringParameter("commentId", ""));
        logger.debug((Object)("Deleting comment " + commentId));
        return this.changeCommentStatus(0, commentId, userSession);
    }

    public JSONObject archive(IParameterProvider requestParams, IPentahoSession userSession) throws JSONException, InvalidCdfOperationException, PluginHibernateException {
        int commentId = Integer.parseInt(requestParams.getStringParameter("commentId", ""));
        logger.debug((Object)("Archiving comment " + commentId));
        return this.changeCommentStatus(1, commentId, userSession);
    }

    private JSONObject changeCommentStatus(int operationType, int commentId, IPentahoSession userSession) throws JSONException, PluginHibernateException {
        Session session = this.getSession();
        session.beginTransaction();
        CommentEntry comment = (CommentEntry)session.load(CommentEntry.class, (Serializable)Integer.valueOf(commentId));
        if (operationType == 1) {
            comment.setArchived(true);
        } else if (operationType == 0) {
            comment.setDeleted(true);
        }
        session.save((Object)comment);
        session.getTransaction().commit();
        JSONObject json = new JSONObject();
        json.put("result", (Object)this.commentToJson(comment, userSession));
        return json;
    }

    private JSONObject commentToJson(CommentEntry comment, IPentahoSession userSession) throws JSONException {
        JSONObject commentJson = new JSONObject();
        commentJson.put("id", comment.getCommentId());
        commentJson.put("user", (Object)comment.getUser());
        commentJson.put("page", (Object)comment.getPage());
        commentJson.put("createdOn", (Object)format.format(comment.getCreatedDate()));
        commentJson.put("elapsedMinutes", comment.getMinutesSinceCreation());
        commentJson.put("comment", (Object)comment.getComment());
        commentJson.put("isMe", comment.getUser().equals(userSession.getName()));
        return commentJson;
    }

    private Session getSession() throws PluginHibernateException {
        return PluginHibernateUtil.getSession();
    }

    private void initialize() throws PluginHibernateException {
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        InputStream in = resLoader.getResourceAsStream(CommentsEngine.class, "resources/hibernate/Comments.hbm.xml");
        PluginHibernateUtil.closeSession();
        PluginHibernateUtil.getConfiguration().addInputStream(in);
        PluginHibernateUtil.rebuildSessionFactory();
    }

    private String getExceptionDescription(Exception ex) {
        return ex.getCause().getClass().getName() + " - " + ex.getMessage();
    }

    static {
        format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    }
}

