/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.export;

import java.io.IOException;
import java.io.OutputStream;
import jxl.Workbook;
import jxl.biff.DisplayFormat;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.pentaho.cdf.Messages;
import org.pentaho.cdf.export.Export;
import org.pentaho.cdf.export.IExport;

public class ExportExcel
extends Export
implements IExport {
    WritableCellFormat cs;
    WritableCellFormat hcs;
    WritableCellFormat rcs;
    WritableCellFormat csn;
    public static final String extensionFile = ".xls";

    public ExportExcel(OutputStream out) throws IOException {
        super(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String[][] resultSet) {
        WritableWorkbook wb = null;
        try {
            wb = Workbook.createWorkbook((OutputStream)this.outputStream);
            WritableSheet sheet = wb.createSheet("Sheet", 0);
            this.setCellsStyles();
            if (resultSet.length > 0) {
                boolean swapRows = resultSet[0].length > 256;
                block19: for (int i = 0; i < resultSet.length; ++i) {
                    String[] vs = resultSet[i];
                    for (int j = 0; j < vs.length; ++j) {
                        WritableCellFormat cf = i == 0 ? this.hcs : (j != 0 ? this.cs : (i % 2 != 0 ? this.hcs : this.rcs));
                        String value = vs[j];
                        if (value == null) continue block19;
                        if (this.isDouble(value)) {
                            Number number = new Number(swapRows ? i : j, swapRows ? j : i, Double.parseDouble(value), (CellFormat)this.csn);
                            sheet.addCell((WritableCell)number);
                            continue;
                        }
                        Label label = new Label(swapRows ? i : j, swapRows ? j : i, value, (CellFormat)cf);
                        sheet.addCell((WritableCell)label);
                    }
                }
            }
            wb.write();
        }
        catch (IOException e) {
            logger.error((Object)Messages.getErrorString("CdfExportExcel.ERROR_0001_OPENING_CLOSING_EXCEL"));
        }
        catch (WriteException e) {
            logger.error((Object)Messages.getErrorString("CdfExportExcel.ERROR_0002_WRITING_EXCEL"));
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("CdfExportExcel.ERROR_0003_BUILDING_EXCEL"));
        }
        finally {
            try {
                wb.close();
            }
            catch (Exception e) {
                logger.error((Object)Messages.getErrorString("CdfExportExcel.ERROR_0001_OPENING_CLOSING_EXCEL"));
            }
        }
    }

    private void setCellsStyles() throws WriteException {
        this.cs = new WritableCellFormat();
        this.cs.setBorder(Border.ALL, BorderLineStyle.THIN);
        this.cs.setShrinkToFit(true);
        this.csn = new WritableCellFormat((DisplayFormat)new NumberFormat("###,###,###.###"));
        this.csn.setBorder(Border.ALL, BorderLineStyle.THIN);
        this.csn.setShrinkToFit(true);
        this.hcs = new WritableCellFormat();
        this.hcs.setBorder(Border.ALL, BorderLineStyle.THIN);
        this.hcs.setBackground(Colour.GRAY_50);
        this.hcs.setShrinkToFit(true);
        this.rcs = new WritableCellFormat();
        this.rcs.setBorder(Border.ALL, BorderLineStyle.THIN);
        this.rcs.setBackground(Colour.GRAY_25);
        this.rcs.setShrinkToFit(true);
    }

    public String getExtension() {
        return extensionFile;
    }
}

