/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.localization;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Locale;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.messages.LocaleHelper;

public class MessageBundlesHelper {
    private String baseUrl;
    private String globalBaseMessageFile;
    private String targetDashboardCacheDir;
    private String targetDashboardBaseMsgFile;
    private String sourceDashboardBaseMsgFile;
    private static final String PENTAHO_CDF_GLOBAL_LANGUAGES_DIR = "pentaho-cdf/resources/languages";
    private static final String PENTAHO_CDF_DIR = "pentaho-cdf/";
    private String languagesCacheUrl;

    public MessageBundlesHelper(String dashboardSolution, String dashboardPath, String dashboardsMessagesBaseFilename) {
        this.init("Messages", dashboardSolution, dashboardPath, dashboardsMessagesBaseFilename);
    }

    public void saveI18NMessageFilesToCache() throws IOException {
        this.createCacheDirIfNotExists(this.targetDashboardCacheDir);
        this.copyStdGlobalMessageFileToCache();
        if (this.sourceDashboardBaseMsgFile != null) {
            this.appendMessageFiles(this.sourceDashboardBaseMsgFile, this.globalBaseMessageFile, this.targetDashboardBaseMsgFile);
        } else {
            this.appendMessageFiles(this.globalBaseMessageFile, this.targetDashboardBaseMsgFile);
        }
    }

    public String getMessageFilesCacheUrl() {
        return this.languagesCacheUrl.replace(File.separator, "/");
    }

    protected void init(String baseGlobalMessageSetFilename, String dashboardSolution, String dashboardPath, String dashboardsMessagesBaseFilename) {
        this.baseUrl = PentahoSystem.getApplicationContext().getSolutionPath("");
        this.globalBaseMessageFile = this.baseUrl + ActionInfo.buildSolutionPath((String)"system", (String)PENTAHO_CDF_GLOBAL_LANGUAGES_DIR, (String)baseGlobalMessageSetFilename);
        this.languagesCacheUrl = "tmp/.cache" + File.separator + dashboardSolution + dashboardPath;
        this.targetDashboardCacheDir = this.baseUrl + File.separator + ActionInfo.buildSolutionPath((String)"system", (String)(PENTAHO_CDF_DIR + this.languagesCacheUrl), (String)"");
        this.targetDashboardBaseMsgFile = this.baseUrl + File.separator + ActionInfo.buildSolutionPath((String)"system", (String)(PENTAHO_CDF_DIR + this.languagesCacheUrl), (String)(dashboardsMessagesBaseFilename != null ? dashboardsMessagesBaseFilename : baseGlobalMessageSetFilename));
        if (dashboardsMessagesBaseFilename != null) {
            this.sourceDashboardBaseMsgFile = this.baseUrl + File.separator + ActionInfo.buildSolutionPath((String)dashboardSolution, (String)dashboardPath, (String)dashboardsMessagesBaseFilename);
        }
    }

    protected void createCacheDirIfNotExists(String targetDashboardCacheDir) {
        File fBaseMsgTargetDir = new File(targetDashboardCacheDir);
        if (!fBaseMsgTargetDir.exists()) {
            fBaseMsgTargetDir.mkdirs();
        }
    }

    protected void appendMessageFiles(String globalBaseMessageFile, String targetDashboardBaseMsgFile) throws IOException {
        this.appendMessageFiles(null, globalBaseMessageFile, targetDashboardBaseMsgFile);
    }

    protected void appendMessageFiles(String sourceDashboardBaseMsgFile, String globalBaseMessageFile, String targetDashboardBaseMsgFile) throws IOException {
        Locale locale = LocaleHelper.getLocale();
        targetDashboardBaseMsgFile = targetDashboardBaseMsgFile + "_" + locale.getLanguage();
        File fBaseMsgGlobal = new File(globalBaseMessageFile + "_" + locale.getLanguage() + ".properties");
        File fBaseMsgTarget = new File(targetDashboardBaseMsgFile + ".properties");
        if (!fBaseMsgTarget.exists()) {
            File fBaseMsgDashboard;
            String theLine;
            fBaseMsgTarget.createNewFile();
            BufferedWriter bwBaseMsgTarget = new BufferedWriter(new FileWriter(fBaseMsgTarget, true));
            if (!fBaseMsgGlobal.exists()) {
                fBaseMsgGlobal = new File(globalBaseMessageFile + ".properties");
            }
            BufferedReader brBaseMsgGlobal = new BufferedReader(new FileReader(fBaseMsgGlobal));
            while ((theLine = brBaseMsgGlobal.readLine()) != null) {
                bwBaseMsgTarget.write(theLine + "\n");
            }
            brBaseMsgGlobal.close();
            if (sourceDashboardBaseMsgFile != null && (fBaseMsgDashboard = new File((sourceDashboardBaseMsgFile = sourceDashboardBaseMsgFile + "_" + locale.getLanguage()) + ".properties")).exists()) {
                BufferedReader brBaseMsgDashboard = new BufferedReader(new FileReader(fBaseMsgDashboard));
                while ((theLine = brBaseMsgDashboard.readLine()) != null) {
                    bwBaseMsgTarget.write(theLine + "\n");
                }
                brBaseMsgDashboard.close();
            }
            bwBaseMsgTarget.close();
        }
    }

    protected void copyStdGlobalMessageFileToCache() throws IOException {
        int c;
        String standardGlobalMessageFilename = "Messages.properties";
        String fromFile = this.baseUrl + ActionInfo.buildSolutionPath((String)"system", (String)PENTAHO_CDF_GLOBAL_LANGUAGES_DIR, (String)standardGlobalMessageFilename);
        String toFile = this.targetDashboardCacheDir + "/" + standardGlobalMessageFilename;
        File outputFile = new File(toFile);
        if (outputFile.exists()) {
            return;
        }
        outputFile.createNewFile();
        File inputFile = new File(fromFile);
        FileReader in = new FileReader(inputFile);
        FileWriter out = new FileWriter(outputFile);
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
    }
}

