/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.storage;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.cdf.InvalidCdfOperationException;
import org.pentaho.cdf.Messages;
import org.pentaho.cdf.PluginHibernateException;
import org.pentaho.cdf.storage.StorageEntry;
import org.pentaho.cdf.utils.PluginHibernateUtil;
import org.pentaho.cdf.utils.Util;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class StorageEngine {
    private static final Log logger = LogFactory.getLog(StorageEngine.class);
    private static StorageEngine _instance;
    private static final SimpleDateFormat format;

    public static synchronized StorageEngine getInstance() {
        if (_instance == null) {
            _instance = new StorageEngine();
        }
        return _instance;
    }

    public StorageEngine() {
        try {
            logger.info((Object)"Creating CommentsEngine instance");
            this.initialize();
        }
        catch (PluginHibernateException ex) {
            logger.fatal((Object)("Could not create CommentsEngine: " + Util.getExceptionDescription(ex)));
            return;
        }
    }

    public String process(IParameterProvider requestParams, IPentahoSession userSession) throws InvalidCdfOperationException {
        String actionParam = requestParams.getStringParameter("action", "");
        Class[] params = new Class[]{IParameterProvider.class, IPentahoSession.class};
        try {
            Method mthd = this.getClass().getMethod(actionParam, params);
            return (String)mthd.invoke((Object)this, requestParams, userSession);
        }
        catch (NoSuchMethodException ex) {
            logger.error((Object)("NoSuchMethodException : " + actionParam + " - " + this.getExceptionDescription(ex)));
            throw new InvalidCdfOperationException(ex);
        }
        catch (Exception ex) {
            logger.error((Object)(Messages.getErrorString("DashboardDesignerContentGenerator.ERROR_001_INVALID_METHOD_EXCEPTION") + " : " + actionParam));
            throw new InvalidCdfOperationException(ex);
        }
    }

    public String store(IParameterProvider requestParams, IPentahoSession userSession) throws JSONException, InvalidCdfOperationException, PluginHibernateException {
        String user = userSession.getName();
        if (user.equals("anonymousUser")) {
            JSONObject json = new JSONObject();
            json.put("result", (Object)Boolean.FALSE);
            return json.toString(2);
        }
        String storageValue = requestParams.getStringParameter("storageValue", "");
        if (storageValue == null) {
            logger.error((Object)"Parameter 'storageValue' Can't be null");
            throw new InvalidCdfOperationException("Parameter 'storageValue' Can't be null");
        }
        logger.debug((Object)"Storing user entry");
        Session session = this.getSession();
        session.beginTransaction();
        Query query = session.getNamedQuery("org.pentaho.cdf.storage.StorageEntry.getStorageForUser").setString("user", user);
        StorageEntry storageEntry = (StorageEntry)query.uniqueResult();
        if (storageEntry == null) {
            storageEntry = new StorageEntry();
            storageEntry.setUser(user);
        }
        storageEntry.setStorageValue(storageValue);
        storageEntry.setLastUpdatedDate(Calendar.getInstance().getTime());
        session.save((Object)storageEntry);
        session.flush();
        session.getTransaction().commit();
        session.close();
        JSONObject json = new JSONObject();
        json.put("result", (Object)Boolean.TRUE);
        return json.toString(2);
    }

    public String read(IParameterProvider requestParams, IPentahoSession userSession) throws JSONException, InvalidCdfOperationException, PluginHibernateException {
        logger.debug((Object)"Reading storage");
        String user = userSession.getName();
        if (user.equals("anonymousUser")) {
            return "{}";
        }
        Session session = this.getSession();
        Query query = session.getNamedQuery("org.pentaho.cdf.storage.StorageEntry.getStorageForUser").setString("user", user);
        StorageEntry storageEntry = (StorageEntry)query.uniqueResult();
        String result = storageEntry != null ? storageEntry.getStorageValue() : "{}";
        session.close();
        return result;
    }

    public String delete(IParameterProvider requestParams, IPentahoSession userSession) throws JSONException, InvalidCdfOperationException, PluginHibernateException {
        String user = userSession.getName();
        if (user.equals("anonymousUser")) {
            JSONObject json = new JSONObject();
            json.put("result", (Object)Boolean.FALSE);
            return json.toString(2);
        }
        logger.debug((Object)("Deleting storage for user " + user));
        Session session = this.getSession();
        session.beginTransaction();
        Query query = session.getNamedQuery("org.pentaho.cdf.storage.StorageEntry.getStorageForUser").setString("user", user);
        StorageEntry storageEntry = (StorageEntry)query.uniqueResult();
        if (storageEntry != null) {
            session.delete((Object)storageEntry);
        }
        session.flush();
        session.getTransaction().commit();
        session.close();
        JSONObject json = new JSONObject();
        json.put("result", (Object)Boolean.TRUE);
        return json.toString(2);
    }

    private synchronized Session getSession() throws PluginHibernateException {
        return PluginHibernateUtil.getSession();
    }

    private void initialize() throws PluginHibernateException {
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        InputStream in = resLoader.getResourceAsStream(StorageEngine.class, "resources/hibernate/Storage.hbm.xml");
        PluginHibernateUtil.closeSession();
        PluginHibernateUtil.getConfiguration().addInputStream(in);
        PluginHibernateUtil.rebuildSessionFactory();
    }

    private String getExceptionDescription(Exception ex) {
        return ex.getCause().getClass().getName() + " - " + ex.getMessage();
    }

    static {
        format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    }
}

