/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.packager;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Vector;
import pt.webdetails.packager.Selector;

public class CSSMin {
    protected static boolean bDebug = false;

    public static void main(String[] args) {
        PrintStream out;
        if (args.length < 1) {
            System.out.println("Usage: ");
            System.out.println("CSSMin [Input file] [Output file] [DEBUG]");
            System.out.println("If no output file is specified, stdout will be used.");
            return;
        }
        boolean bl = bDebug = args.length > 2;
        if (args.length > 1) {
            try {
                out = new PrintStream(args[1]);
            }
            catch (Exception e) {
                System.err.println("Error outputting to " + args[1] + "; redirecting to stdout");
                out = System.out;
            }
        } else {
            out = System.out;
        }
        CSSMin.formatFile(args[0], out);
    }

    public static void formatFile(String f, PrintStream out) {
        try {
            CSSMin.formatFile((Reader)new FileReader(f), out);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static void formatFile(Reader input, OutputStream out) {
        CSSMin.formatFile(input, new PrintStream(out));
    }

    public static void formatFile(Reader input, PrintStream out) {
        try {
            int k;
            String s;
            BufferedReader br = new BufferedReader(input);
            StringBuffer sb = new StringBuffer();
            if (bDebug) {
                System.err.println("Removing extraneous whitespace...");
            }
            while ((s = br.readLine()) != null) {
                if (s.trim().equals("")) continue;
                sb.append(s.replaceAll("[\t\n\r]", "").replaceAll("  ", " "));
            }
            if (bDebug) {
                System.err.println("Removing comments...");
            }
            int n = 0;
            while ((n = sb.indexOf("/*", n)) != -1) {
                if (sb.charAt(n + 2) == '*') {
                    n += 2;
                    continue;
                }
                k = sb.indexOf("*/", n + 2);
                if (k == -1) {
                    throw new Exception("Unterminated comment. Aborting.");
                }
                sb.delete(n, k + 2);
            }
            if (bDebug) {
                System.err.println("Parsing and processing selectors...");
            }
            Vector<Selector> selectors = new Vector<Selector>();
            n = 0;
            while ((k = sb.indexOf("}", n)) != -1) {
                try {
                    selectors.addElement(new Selector(sb.substring(n, k + 1)));
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
                n = k + 1;
            }
            for (Selector selector : selectors) {
                out.print(selector.toString());
            }
            out.print("\r\n");
            out.close();
            if (bDebug) {
                System.err.println("Process completed successfully.");
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

