/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.packager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import pt.webdetails.packager.Concatenate;
import pt.webdetails.packager.JSMin;
import pt.webdetails.packager.Packager;

class FileSet {
    private boolean dirty;
    private String latestVersion;
    private ArrayList<File> files;
    private File location;
    private Packager.Filetype filetype;
    private String rootdir;

    public void addFile(String file) {
        this.addFile(new File(file));
    }

    public void addFile(File file) {
        if (this.files.indexOf(file) == -1) {
            this.dirty = true;
            this.files.add(file);
        }
    }

    public FileSet(String location, Packager.Filetype type, File[] fileSet, String rootdir) throws IOException, NoSuchAlgorithmException {
        this.files = new ArrayList();
        this.files.addAll(Arrays.asList(fileSet));
        this.location = new File(location);
        this.filetype = type;
        this.latestVersion = "";
        this.dirty = true;
        this.rootdir = rootdir;
    }

    public FileSet() throws IOException, NoSuchAlgorithmException {
        this.dirty = true;
        this.files = new ArrayList();
        this.latestVersion = null;
        this.location = null;
    }

    private String minify() throws IOException, NoSuchAlgorithmException {
        try {
            FileWriter output = new FileWriter(this.location);
            switch (this.filetype) {
                case JS: {
                    InputStream concatenatedStream = Concatenate.concat(this.files.toArray(new File[this.files.size()]));
                    InputStreamReader freader = new InputStreamReader(concatenatedStream, "UTF8");
                    JSMin jsmin = new JSMin(concatenatedStream, new FileOutputStream(this.location));
                    jsmin.jsmin();
                    break;
                }
                case CSS: {
                    int input;
                    InputStream concatenatedStream = Concatenate.concat(this.files.toArray(new File[this.files.size()]), this.rootdir);
                    InputStreamReader freader = new InputStreamReader(concatenatedStream, "UTF8");
                    FileWriter wout = new FileWriter(this.location);
                    while ((input = ((Reader)freader).read()) != -1) {
                        wout.write(input);
                    }
                    wout.close();
                }
            }
            FileInputStream script = new FileInputStream(this.location);
            byte[] fileContent = new byte[(int)this.location.length()];
            script.read(fileContent);
            this.dirty = false;
            this.latestVersion = this.byteToHex(MessageDigest.getInstance("MD5").digest(fileContent));
            return this.latestVersion;
        }
        catch (Exception ex) {
            Logger.getLogger(FileSet.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private String byteToHex(byte[] bytes) {
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String byteValue = Integer.toHexString(0xFF & bytes[i]);
            hexString.append(byteValue.length() == 2 ? byteValue : "0" + byteValue);
        }
        return hexString.toString();
    }

    public String update() throws IOException, NoSuchAlgorithmException {
        return this.update(false);
    }

    public String update(boolean force) throws IOException, NoSuchAlgorithmException {
        if (!this.dirty && !force) {
            for (File file : this.files) {
                if (this.location.exists() && file.lastModified() <= this.location.lastModified()) continue;
                this.dirty = true;
                break;
            }
        }
        return this.dirty || force ? this.minify() : this.latestVersion;
    }
}

