/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.packager;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.packager.FileSet;

public class Packager {
    static Log logger = LogFactory.getLog(Packager.class);
    private static Packager _instance;
    private HashMap<String, FileSet> fileSets = new HashMap();

    private Packager() {
    }

    public static synchronized Packager getInstance() {
        if (_instance == null) {
            _instance = new Packager();
        }
        return _instance;
    }

    public void registerPackage(Filetype type, String root, String filename, String[] files) {
        this.registerPackage(filename, type, root, filename, files);
    }

    public void registerPackage(String name, Filetype type, String root, String filename, String[] files) {
        ArrayList<File> fileHandles = new ArrayList<File>();
        for (String file : files) {
            fileHandles.add(new File((root + "/" + file).replaceAll("/+", "/")));
        }
        this.registerPackage(name, type, root, filename, fileHandles.toArray(new File[fileHandles.size()]));
    }

    public void registerPackage(String name, Filetype type, String root, String output, File[] files) {
        if (this.fileSets.containsKey(name)) {
            Logger.getLogger(Packager.class.getName()).log(Level.WARNING, name + " is overriding an existing file package!");
        }
        try {
            FileSet fileSet = new FileSet(output, type, files, root);
            this.fileSets.put(name, fileSet);
        }
        catch (IOException ex) {
            Logger.getLogger(Packager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(Packager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean isPackageRegistered(String pkg) {
        return this.fileSets.containsKey(pkg);
    }

    public String minifyPackage(String pkg) {
        try {
            return this.fileSets.get(pkg).update();
        }
        catch (IOException ex) {
            Logger.getLogger(Packager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(Packager.class.getName()).log(Level.SEVERE, null, ex);
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Filetype {
        CSS,
        JS;

    }
}

