/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.packager;

import java.util.ArrayList;
import java.util.Arrays;
import pt.webdetails.packager.CSSMin;
import pt.webdetails.packager.Property;

class Selector {
    private Property[] properties;
    private String selector;

    public Selector(String selector) throws Exception {
        String[] parts = selector.split("\\{");
        if (parts.length < 2) {
            throw new Exception("Warning: Incomplete selector: " + selector);
        }
        this.selector = parts[0].trim();
        String contents = parts[1].trim();
        if (CSSMin.bDebug) {
            System.err.println("Parsing selector: " + this.selector);
            System.err.println("\t" + contents);
        }
        if (contents.charAt(contents.length() - 1) != '}') {
            throw new Exception("Unterminated selector: " + selector);
        }
        if (contents.length() == 1) {
            throw new Exception("Empty selector body: " + selector);
        }
        contents = contents.substring(0, contents.length() - 2);
        this.properties = this.parseProperties(contents);
        this.sortProperties(this.properties);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.selector).append("{");
        for (Property p : this.properties) {
            sb.append(p.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    private Property[] parseProperties(String contents) {
        ArrayList<String> parts = new ArrayList<String>();
        boolean bCanSplit = true;
        int j = 0;
        for (int i = 0; i < contents.length(); ++i) {
            if (!bCanSplit) {
                bCanSplit = contents.charAt(i) == '\"';
                continue;
            }
            if (contents.charAt(i) == '\"') {
                bCanSplit = false;
                continue;
            }
            if (contents.charAt(i) != ';') continue;
            parts.add(contents.substring(j, i));
            j = i + 1;
        }
        parts.add(contents.substring(j, contents.length()));
        ArrayList<Property> resultsList = new ArrayList<Property>();
        for (int i = 0; i < parts.size(); ++i) {
            try {
                resultsList.add(new Property((String)parts.get(i)));
                continue;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return resultsList.toArray(new Property[resultsList.size()]);
    }

    private void sortProperties(Property[] properties) {
        Arrays.sort(properties);
    }
}

