/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.impl.util.PropertiesUtil;
import org.apache.pig.tools.grunt.GruntParser;
import org.apache.pig.tools.parameters.ParameterSubstitutionPreprocessor;
import org.apache.pig.tools.pigscript.parser.ParseException;
import org.pentaho.hadoop.shim.ShimVersion;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.common.ShimUtils;
import org.pentaho.hadoop.shim.spi.PigShim;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonPigShim
implements PigShim {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public ShimVersion getVersion() {
        return new ShimVersion(1, 0);
    }

    public boolean isLocalExecutionSupported() {
        return true;
    }

    public void configure(Properties properties, Configuration configuration) {
        PropertiesUtil.loadDefaultProperties((Properties)properties);
        if (configuration != null) {
            properties.putAll((Map<?, ?>)ConfigurationUtil.toProperties((org.apache.hadoop.conf.Configuration)ShimUtils.asConfiguration(configuration)));
        }
    }

    public String substituteParameters(URL pigScript, List<String> paramList) throws IOException, org.apache.pig.tools.parameters.ParseException {
        InputStream inStream = pigScript.openStream();
        StringWriter writer = new StringWriter();
        ParameterSubstitutionPreprocessor psp = new ParameterSubstitutionPreprocessor(50);
        psp.genSubstitutedFile(new BufferedReader(new InputStreamReader(inStream)), (Writer)writer, paramList.size() > 0 ? paramList.toArray(EMPTY_STRING_ARRAY) : null, null);
        return writer.toString();
    }

    protected ExecType getExecType(PigShim.ExecutionMode mode) {
        switch (mode) {
            case LOCAL: {
                return ExecType.LOCAL;
            }
            case MAPREDUCE: {
                return ExecType.MAPREDUCE;
            }
        }
        throw new IllegalStateException("unknown execution mode: " + mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeScript(String pigScript, PigShim.ExecutionMode mode, Properties properties) throws IOException, ParseException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            PigServer pigServer = new PigServer(this.getExecType(mode), properties);
            GruntParser grunt = new GruntParser((Reader)new StringReader(pigScript));
            grunt.setInteractive(false);
            grunt.setParams(pigServer);
            int[] nArray = grunt.parseStopOnError(false);
            return nArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

