/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.geo;

import java.util.Properties;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.geo.GeoContextConfigProvider;

public class GeoContextPropertiesProvider
implements GeoContextConfigProvider {
    private Properties props;

    public GeoContextPropertiesProvider(Properties props) {
        this.props = props;
    }

    public String getDimensionName() throws ModelerException {
        return this.props.getProperty("geo.dimension.name");
    }

    public String getRoles() throws ModelerException {
        return this.props.getProperty("geo.roles");
    }

    public String getRoleAliases(String roleName) throws ModelerException {
        String aliasKey = "geo." + roleName + ".aliases";
        String aliases = this.props.getProperty(aliasKey);
        if (aliases == null || aliases.trim().length() == 0) {
            throw new ModelerException("Error while building GeoContext from properties: No Aliases found for role  " + roleName + ". Make sure there is a " + aliasKey + " property defined");
        }
        return aliases;
    }

    public String getRoleRequirements(String roleName) throws ModelerException {
        String key = "geo." + roleName + ".required-parents";
        return this.props.getProperty(key);
    }
}

