/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.ActiveBtreeExtent;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeDataFile;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.Converter;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.DeletedBtreeExtent;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.IntHolder;

class NormalBtreeExtent
extends ActiveBtreeExtent {
    static final int NORMAL_FIXED_LENGTH = 18;
    static final int MAX_KEY_LENGTH = 14;
    byte[] key;
    int totalLength;

    NormalBtreeExtent(BtreeDataFile file, int chunkNum, short numChunks) {
        super(file, chunkNum, numChunks);
    }

    NormalBtreeExtent(DeletedBtreeExtent del, byte[] k, int length) {
        super(del);
        this.key = k;
        this.dataStart = 18 + this.key.length;
        this.setMyDataLength(length);
    }

    NormalBtreeExtent(BtreeDataFile file, int chunkNum, short numChunks, int totLen, byte[] k) throws StorageException {
        super(file, chunkNum, numChunks);
        if (k.length > 14) {
            throw new StorageBadRequestException(MessageFormat.format("Invalid key length: {0}", new Integer(k.length)));
        }
        this.key = k;
        this.setMyDataLength(totLen);
        this.totalLength = totLen;
        this.dataStart = 18 + this.key.length;
        this.headerIsDirty = true;
    }

    void readHeaderFromPage(byte[] buffer, IntHolder offset) {
        short keyLen = Converter.readShort(buffer, offset);
        this.key = new byte[keyLen];
        this.dataLength = Converter.readInt(buffer, offset);
        this.totalLength = Converter.readInt(buffer, offset);
        System.arraycopy(buffer, offset.getValue(), this.key, 0, keyLen);
        this.dataStart = 18 + this.key.length;
    }

    protected void writeHeaderToPage(CachedPage page, int offset) {
        offset = Converter.writeShort(page.contents, offset, (short)this.key.length);
        offset = Converter.writeInt(page.contents, offset, this.dataLength);
        offset = Converter.writeInt(page.contents, offset, this.totalLength);
        System.arraycopy(this.key, 0, page.contents, offset, this.key.length);
    }

    int getMyDataLength() {
        return this.dataLength;
    }

    int getTotalDataLength() {
        return this.totalLength;
    }

    int getAvailableDataLength() {
        return NormalBtreeExtent.getAvailableDataLength(this.chunks, this.key.length);
    }

    short getMagic() {
        return 10794;
    }

    static int getNumChunks(int keyLength, int dataLength) {
        int size = (keyLength + dataLength + 18 - 1) / 32 + 1;
        return Math.min(size, 256);
    }

    static int getAvailableDataLength(int numChunks, int keyLength) {
        return 32 * numChunks - 18 - keyLength;
    }

    int setMyDataLength(int length) {
        int oldDataLength = this.dataLength;
        this.dataLength = Math.min(length, this.getAvailableDataLength());
        if (this.dataLength != oldDataLength) {
            this.headerIsDirty = true;
        }
        if (this.totalLength != length) {
            this.totalLength = length;
            this.headerIsDirty = true;
        }
        return this.dataLength;
    }

    boolean isMaximum() {
        return this.key.length + this.dataLength + 18 == 8192;
    }

    byte getType() {
        return 1;
    }

    String getTypeName() {
        return "normal";
    }

    void dump(int level, PrintWriter strm) throws StorageException {
        super.dump(level, strm);
        if ((level & 1) != 0) {
            strm.println(this.totalLength + " bytes in record");
            strm.println(this.key.length + " bytes in key");
        }
        if ((level & 2) != 0) {
            NormalBtreeExtent.dumpBytesAsHex(new ByteArrayInputStream(this.key), strm, "\t");
        }
    }
}

