/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.lifecycle.pdi;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.VFS;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.annotations.LifecyclePlugin;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.gui.GUIOption;
import org.pentaho.di.core.lifecycle.LifeEventHandler;
import org.pentaho.di.core.lifecycle.LifeEventInfo;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.lifecycle.LifecycleListener;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.PluginClassTypeMapping;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.versionchecker.BasicVersionCheckerProvider;
import org.pentaho.versionchecker.IVersionCheckDataProvider;
import org.pentaho.versionchecker.IVersionCheckErrorHandler;
import org.pentaho.versionchecker.IVersionCheckResultHandler;
import org.pentaho.versionchecker.VersionChecker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@LifecyclePlugin(id="VersionChecker", name="Version checker")
@PluginClassTypeMapping(classTypes={GUIOption.class}, implementationClass={VersionCheckerListener.class})
public class VersionCheckerListener
implements LifecycleListener,
GUIOption<Boolean> {
    private static Class<?> PKG = VersionCheckerListener.class;
    private static final String PDI_CHECK_VERSION_FLAG = "pdi.check.version.flag";
    private LifecycleException root;
    private static LogChannelInterface log = new LogChannel((Object)"Version checker");
    public static final String VERSION_CHECKER = "Version Checker";

    public void onStart(final LifeEventHandler handler) throws LifecycleException {
        String prop = Props.getInstance().getProperty(PDI_CHECK_VERSION_FLAG);
        if (prop != null && !Boolean.parseBoolean(prop)) {
            log.logBasic("Skipping version check.", new Object[0]);
            return;
        }
        try {
            Class.forName("org.pentaho.versionchecker.BasicVersionCheckerProvider");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                final BasicVersionCheckerProvider dataProvider = new BasicVersionCheckerProvider(Spoon.class);
                final StringBuilder message = new StringBuilder();
                final StringBuilder version = new StringBuilder();
                final StringBuilder url = new StringBuilder();
                VersionChecker vc = new VersionChecker();
                vc.setDataProvider((IVersionCheckDataProvider)dataProvider);
                vc.addResultHandler(new IVersionCheckResultHandler(){

                    public void processResults(String result) {
                        block7: {
                            try {
                                Document doc = XMLHandler.loadXMLString((String)result);
                                Element vers = doc.getDocumentElement();
                                Node product = XMLHandler.getNodeWithAttributeValue((Node)vers, (String)"product", (String)"id", (String)dataProvider.getApplicationID());
                                if (product != null) {
                                    Node update = XMLHandler.getSubNode((Node)product, (String)"update");
                                    try {
                                        FileObject html = KettleVFS.getFileObject((String)"docs/English/welcome/kettle_version_check.html");
                                        String line = null;
                                        version.append(update.getAttributes().getNamedItem("version").getTextContent());
                                        url.append(XMLHandler.getTagValue((Node)update, (String)"downloadurl"));
                                        BufferedReader myInput = new BufferedReader(new InputStreamReader(html.getURL().openStream()));
                                        while ((line = myInput.readLine()) != null) {
                                            message.append(line);
                                        }
                                        break block7;
                                    }
                                    catch (Exception e) {
                                        VersionCheckerListener.this.root = new LifecycleException((Throwable)e, false);
                                        break block7;
                                    }
                                }
                                log.logBasic("OK");
                            }
                            catch (KettleXMLException e) {
                                if (log.isDebug()) {
                                    log.logDebug("XML ERROR", new Object[]{e});
                                }
                                VersionCheckerListener.this.root = new LifecycleException((Throwable)e, false);
                            }
                        }
                    }
                });
                vc.addErrorHandler(new IVersionCheckErrorHandler(){

                    public void handleException(Exception e) {
                        VersionCheckerListener.this.root = new LifecycleException((Throwable)e, false);
                    }
                });
                vc.performCheck(false);
                if (VersionCheckerListener.this.root != null) {
                    return;
                }
                if (message.length() > 0) {
                    String smsg = message.toString().replace("$url$", url).replace("$version$", version);
                    try {
                        FileObject root = KettleVFS.getFileObject((String)"docs/English/welcome");
                        FileObject logo = VFS.getManager().resolveFile(root, "images/pentaho_logo.png");
                        FileObject css = VFS.getManager().resolveFile(root, "images/styles-new.css");
                        smsg = smsg.replace("$pentaho_logo$", logo.getURL().toString()).replace("$css$", css.getURL().toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    LifeEventInfo info = new LifeEventInfo();
                    info.setName(VersionCheckerListener.VERSION_CHECKER);
                    info.setMessage(smsg);
                    info.setHint(LifeEventInfo.Hint.DISPLAY_BROWSER);
                    info.setState(LifeEventInfo.State.SUCCESS);
                    handler.consume(info);
                }
            }
        };
        new Thread(r).start();
    }

    public void onExit(LifeEventHandler handler) throws LifecycleException {
    }

    public Boolean getLastValue() {
        String prop = Props.getInstance().getProperty(PDI_CHECK_VERSION_FLAG);
        return prop == null ? true : new Boolean(prop);
    }

    public void setValue(Boolean arg0) {
        Props.getInstance().setProperty(PDI_CHECK_VERSION_FLAG, arg0.toString());
    }

    public GUIOption.DisplayType getType() {
        return GUIOption.DisplayType.CHECK_BOX;
    }

    public String getLabelText() {
        return BaseMessages.getString(PKG, (String)"versioncheck.label.text", (String[])new String[0]);
    }
}

