/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class ReptFunction
implements Function {
    private static final long serialVersionUID = -6832781189129832501L;

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        Object textValue1;
        Object countValue;
        Type countType;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount != 2) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        int count = typeRegistry.convertToNumber(countType = parameters.getType(1), countValue = parameters.getValue(1)).intValue();
        if (count < 0) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        Type textType1 = parameters.getType(0);
        String rawText = typeRegistry.convertToText(textType1, textValue1 = parameters.getValue(0));
        if (rawText == null) {
            return new TypeValuePair(TextType.TYPE, "");
        }
        StringBuilder buffer = new StringBuilder(rawText.length() * count);
        for (int i = 0; i < count; ++i) {
            buffer.append(rawText);
        }
        return new TypeValuePair(TextType.TYPE, buffer.toString());
    }

    public String getCanonicalName() {
        return "REPT";
    }
}

